/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.SyslogWriter;
import org.apache.log4j.spi.LoggingEvent;

public class SyslogAppender
extends AppenderSkeleton {
    protected static final int SYSLOG_HOST_OI = 0;
    protected static final int FACILITY_OI = 1;
    static final String TAB = "    ";
    int facility;
    String facilityStr;
    String localHostname;
    String syslogHost;
    SyslogWriter sw;
    Calendar calendar = Calendar.getInstance();
    long now = -1L;
    Date date = new Date();
    StringBuffer timestamp = new StringBuffer();
    protected FieldPosition pos = new FieldPosition(0);
    private SimpleDateFormat sdf = new SimpleDateFormat("MMM dd hh:mm:ss", new DateFormatSymbols(Locale.US));
    Layout layout;

    public synchronized void close() {
        this.closed = true;
        this.sw = null;
    }

    public String getLocalHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            this.getLogger().error((Object)("Could not determine local host name for SyslogAppendernamed [" + this.name + "]."), uhe);
            return "UNKNOWN_HOST";
        }
    }

    static int facilityStringToint(String facilityStr) {
        if ("KERN".equalsIgnoreCase(facilityStr)) {
            return 0;
        }
        if ("USER".equalsIgnoreCase(facilityStr)) {
            return 8;
        }
        if ("MAIL".equalsIgnoreCase(facilityStr)) {
            return 16;
        }
        if ("DAEMON".equalsIgnoreCase(facilityStr)) {
            return 24;
        }
        if ("AUTH".equalsIgnoreCase(facilityStr)) {
            return 32;
        }
        if ("SYSLOG".equalsIgnoreCase(facilityStr)) {
            return 40;
        }
        if ("LPR".equalsIgnoreCase(facilityStr)) {
            return 48;
        }
        if ("NEWS".equalsIgnoreCase(facilityStr)) {
            return 56;
        }
        if ("UUCP".equalsIgnoreCase(facilityStr)) {
            return 64;
        }
        if ("CRON".equalsIgnoreCase(facilityStr)) {
            return 72;
        }
        if ("AUTHPRIV".equalsIgnoreCase(facilityStr)) {
            return 80;
        }
        if ("FTP".equalsIgnoreCase(facilityStr)) {
            return 88;
        }
        if ("LOCAL0".equalsIgnoreCase(facilityStr)) {
            return 128;
        }
        if ("LOCAL1".equalsIgnoreCase(facilityStr)) {
            return 136;
        }
        if ("LOCAL2".equalsIgnoreCase(facilityStr)) {
            return 144;
        }
        if ("LOCAL3".equalsIgnoreCase(facilityStr)) {
            return 152;
        }
        if ("LOCAL4".equalsIgnoreCase(facilityStr)) {
            return 160;
        }
        if ("LOCAL5".equalsIgnoreCase(facilityStr)) {
            return 168;
        }
        if ("LOCAL6".equalsIgnoreCase(facilityStr)) {
            return 176;
        }
        if ("LOCAL7".equalsIgnoreCase(facilityStr)) {
            return 184;
        }
        return -1;
    }

    public void activateOptions() {
        if (this.facilityStr == null) {
            String errMsg = "The Facility option must be set for SyslogAppender named [" + this.name + "].";
            this.getLogger().error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        this.facilityStr = this.facilityStr.trim();
        this.getLogger().debug((Object)"Facility string set to be {}.", this.facilityStr);
        this.facility = SyslogAppender.facilityStringToint(this.facilityStr);
        this.getLogger().debug("Facility set to be " + this.facility);
        if (this.facility == -1) {
            String errMsg = "Unrecognized Facility option \"" + this.facilityStr + "\" SyslogAppender named [" + this.name + "].";
            this.getLogger().error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        if (this.syslogHost == null) {
            String errMsg = "No syslog host is set for SyslogAppedender named \"" + this.name + "\".";
            this.getLogger().error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        if (this.layout == null) {
            String errMsg = "No Layout is set for SyslogAppedender named \"" + this.name + "\".";
            this.getLogger().error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        this.localHostname = this.getLocalHostname();
        this.sw = new SyslogWriter(this.syslogHost);
    }

    public void setSyslogHost(String syslogHost) {
        this.syslogHost = syslogHost;
    }

    public String getSyslogHost() {
        return this.syslogHost;
    }

    public void setFacility(String facility) {
        this.facilityStr = facility;
    }

    public String getFacility() {
        return this.facilityStr;
    }

    void fillInTimestamp() throws IOException {
        long n = System.currentTimeMillis();
        if ((n -= n & 0x3E8L) != this.now || this.timestamp.length() == 0) {
            this.now = n;
            this.date.setTime(n);
            this.timestamp.setLength(0);
            this.sdf.format(this.date, this.timestamp, this.pos);
            if (this.timestamp.charAt(4) == '0') {
                this.timestamp.setCharAt(4, ' ');
            }
        }
        this.sw.write(this.timestamp.toString());
    }

    void writeInitialParts(LoggingEvent event) throws IOException {
        int pri = this.facility + event.getLevel().getSyslogEquivalent();
        System.out.println("" + pri);
        this.sw.write("<");
        this.sw.write(String.valueOf(pri));
        this.sw.write(">");
        this.fillInTimestamp();
        this.sw.write(32);
        this.sw.write(this.localHostname);
        this.sw.write(32);
    }

    public void append(LoggingEvent event) {
        if (this.sw == null) {
            return;
        }
        try {
            this.writeInitialParts(event);
            this.layout.format(this.sw, event);
            this.sw.flush();
        }
        catch (IOException ioe) {}
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }
}

