/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import org.apache.log4j.helpers.Option;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.joran.action.Action;
import org.apache.log4j.joran.spi.ExecutionContext;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.spi.ErrorItem;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.OptionHandler;
import org.xml.sax.Attributes;

public class PluginAction
extends Action {
    Plugin plugin;
    boolean inError = false;
    static /* synthetic */ Class class$org$apache$log4j$plugins$Plugin;

    public void begin(ExecutionContext ec, String localName, Attributes attributes) {
        String className = attributes.getValue("class");
        try {
            this.getLogger().debug("About to instantiate plugin of type [" + className + "]");
            this.plugin = (Plugin)OptionConverter.instantiateByClassName(className, class$org$apache$log4j$plugins$Plugin == null ? (class$org$apache$log4j$plugins$Plugin = PluginAction.class$("org.apache.log4j.plugins.Plugin")) : class$org$apache$log4j$plugins$Plugin, null);
            String pluginName = attributes.getValue("name");
            if (Option.isEmpty(pluginName)) {
                this.getLogger().warn("No plugin name given for plugin of type " + className + "].");
            } else {
                this.plugin.setName(pluginName);
                this.getLogger().debug("plugin named as [" + pluginName + "]");
            }
            LoggerRepository repository = (LoggerRepository)ec.getObject(0);
            repository.getPluginRegistry().addPlugin(this.plugin);
            this.plugin.setLoggerRepository(repository);
            this.getLogger().debug("Pushing plugin on to the object stack.");
            ec.pushObject(this.plugin);
        }
        catch (Exception oops) {
            this.inError = true;
            this.getLogger().error((Object)"Could not create a plugin. Reported error follows.", oops);
            ec.addError(new ErrorItem("Could not create plugin of type " + className + "]."));
        }
    }

    public void end(ExecutionContext ec, String name) {
        Object o;
        if (this.inError) {
            return;
        }
        if (this.plugin instanceof OptionHandler) {
            this.plugin.activateOptions();
        }
        if ((o = ec.peekObject()) != this.plugin) {
            this.getLogger().warn("The object at the of the stack is not the plugin named [" + this.plugin.getName() + "] pushed earlier.");
        } else {
            this.getLogger().debug((Object)"Popping plugin named [{}] from the object stack", this.plugin.getName());
            ec.popObject();
        }
    }

    public void finish(ExecutionContext ec) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

