/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.joran.action.Action;
import org.apache.log4j.joran.spi.ExecutionContext;
import org.apache.log4j.spi.ErrorItem;
import org.xml.sax.Attributes;

public class ParamAction
extends Action {
    static String NO_NAME = "No name attribute in <param> element";
    static String NO_VALUE = "No name attribute in <param> element";
    boolean inError = false;

    public void begin(ExecutionContext ec, String localName, Attributes attributes) {
        String name = attributes.getValue("name");
        String value = attributes.getValue("value");
        if (name == null) {
            this.inError = true;
            this.getLogger().error(NO_NAME);
            ec.addError(new ErrorItem(NO_NAME));
            return;
        }
        if (value == null) {
            this.inError = true;
            this.getLogger().error(NO_VALUE);
            ec.addError(new ErrorItem(NO_VALUE));
            return;
        }
        value = value.trim();
        Object o = ec.peekObject();
        PropertySetter propSetter = new PropertySetter(o);
        value = ec.subst(OptionConverter.convertSpecialChars(value));
        name = ec.subst(name);
        this.getLogger().debug("In ParamAction setting parameter [{}] to value [{}].", name, value);
        propSetter.setProperty(name, value);
    }

    public void end(ExecutionContext ec, String localName) {
    }

    public void finish(ExecutionContext ec) {
    }
}

