/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import java.util.HashMap;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.Option;
import org.apache.log4j.joran.action.Action;
import org.apache.log4j.joran.spi.ExecutionContext;
import org.apache.log4j.spi.ErrorItem;
import org.apache.log4j.spi.LoggerRepository;
import org.xml.sax.Attributes;

public class ConversionRuleAction
extends Action {
    Layout layout;
    boolean inError = false;

    public void begin(ExecutionContext ec, String localName, Attributes attributes) {
        this.inError = false;
        String conversionWord = attributes.getValue("conversionWord");
        String converterClass = attributes.getValue("converterClass");
        if (Option.isEmpty(conversionWord)) {
            this.inError = true;
            String errorMsg = "No 'conversionWord' attribute in <conversionRule>";
            this.getLogger().warn(errorMsg);
            ec.addError(new ErrorItem(errorMsg));
            return;
        }
        if (Option.isEmpty(converterClass)) {
            this.inError = true;
            String errorMsg = "No 'converterClass' attribute in <conversionRule>";
            this.getLogger().warn(errorMsg);
            ec.addError(new ErrorItem(errorMsg));
            return;
        }
        try {
            this.getLogger().debug("About to add conversion rule [{}, {}] to layout", conversionWord, converterClass);
            LoggerRepository repository = (LoggerRepository)ec.getObjectStack().get(0);
            HashMap<String, String> ruleRegistry = (HashMap<String, String>)repository.getObject("PATTERN_RULE_REGISTRY");
            if (ruleRegistry == null) {
                ruleRegistry = new HashMap<String, String>();
                repository.putObject("PATTERN_RULE_REGISTRY", ruleRegistry);
            }
            ruleRegistry.put(conversionWord, converterClass);
        }
        catch (Exception oops) {
            this.inError = true;
            String errorMsg = "Could not add conversion rule to PatternLayout.";
            this.getLogger().error((Object)errorMsg, oops);
            ec.addError(new ErrorItem(errorMsg));
        }
    }

    public void end(ExecutionContext ec, String n) {
    }

    public void finish(ExecutionContext ec) {
    }
}

