/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.pattern.PatternConverter;
import org.apache.log4j.pattern.PatternParser;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class HTMLLayout
extends Layout {
    public static final String DEFAULT_CONVERSION_PATTERN = "%m";
    public static final String TTCC_CONVERSION_PATTERN = "%r%t%p%c%x%m";
    static String TRACE_PREFIX = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
    protected final int BUF_SIZE = 256;
    protected final int MAX_CAPACITY = 1024;
    private String pattern;
    private PatternConverter head;
    private String timezone;
    private String title = "Log4J Log Messages";
    private boolean internalCSS = false;
    private String url2ExternalCSS = "http://logging.apache.org/log4j/docs/css/eventTable-1.0.css";
    private boolean chainHandlesThrowable;
    private long counter = 0L;

    public HTMLLayout() {
        this(DEFAULT_CONVERSION_PATTERN);
    }

    public HTMLLayout(String pattern) {
        this.pattern = pattern;
        this.activateOptions();
    }

    public void setConversionPattern(String conversionPattern) {
        this.pattern = conversionPattern;
    }

    public String getConversionPattern() {
        return this.pattern;
    }

    public void activateOptions() {
        this.head = this.createPatternParser(this.pattern, this.repository).parse();
        this.chainHandlesThrowable = PatternConverter.chainHandlesThrowable(this.head);
    }

    protected PatternParser createPatternParser(String pattern, LoggerRepository repository) {
        return new PatternParser(pattern, repository);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isInternalCSS() {
        return this.internalCSS;
    }

    public void setInternalCSS(boolean internalCSS) {
        this.internalCSS = internalCSS;
    }

    public String getURL2ExternalCSS() {
        return this.url2ExternalCSS;
    }

    public void setURL2ExternalCSS(String url2ExternalCSS) {
        this.url2ExternalCSS = url2ExternalCSS;
    }

    public String getContentType() {
        return "text/html";
    }

    void appendThrowableAsHTML(String[] s, Writer sbuf) throws IOException {
        if (s != null) {
            int len = s.length;
            if (len == 0) {
                return;
            }
            Transform.escapeTags(s[0], sbuf);
            sbuf.write(Layout.LINE_SEP);
            int i = 1;
            while (i < len) {
                sbuf.write(TRACE_PREFIX);
                Transform.escapeTags(s[i], sbuf);
                sbuf.write(Layout.LINE_SEP);
                ++i;
            }
        }
    }

    public String getHeader() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"");
        sbuf.append(" \"http://www.w3.org/TR/html4/loose.dtd\">");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<html>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<head>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<title>" + this.title + "</title>");
        sbuf.append(Layout.LINE_SEP);
        if (this.internalCSS) {
            this.getInternalCSS(sbuf);
        } else {
            sbuf.append("<LINK REL=StyleSheet HREF=\"" + this.url2ExternalCSS + "\" TITLE=\"Basic\">");
        }
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("</head>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<body>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<hr size=\"1\" noshade>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("Log session start time " + new Date() + "<br>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<br>");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<table cellspacing=\"0\">");
        sbuf.append(Layout.LINE_SEP);
        sbuf.append("<tr class=\"header\">");
        sbuf.append(Layout.LINE_SEP);
        PatternConverter c = this.head;
        while (c != null) {
            sbuf.append("<td class=\"");
            sbuf.append(c.getStyleClass(null).toLowerCase());
            sbuf.append("\">");
            sbuf.append(c.getName());
            sbuf.append("</td>");
            sbuf.append(Layout.LINE_SEP);
            c = c.next;
        }
        sbuf.append("</tr>");
        sbuf.append(Layout.LINE_SEP);
        return sbuf.toString();
    }

    public String getFooter() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("</table>" + Layout.LINE_SEP);
        sbuf.append("<br>" + Layout.LINE_SEP);
        sbuf.append("</body></html>");
        return sbuf.toString();
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void format(Writer output, LoggingEvent event) throws IOException {
        String[] s;
        boolean odd = true;
        if ((this.counter++ & 1L) == 0L) {
            odd = false;
        }
        String level = event.getLevel().toString().toLowerCase();
        output.write(Layout.LINE_SEP);
        output.write("<tr class=\"");
        output.write(level);
        if (odd) {
            output.write(" odd\">");
        } else {
            output.write(" even\">");
        }
        output.write(Layout.LINE_SEP);
        PatternConverter c = this.head;
        while (c != null) {
            output.write("<td class=\"");
            output.write(c.getStyleClass(event).toLowerCase());
            output.write("\">");
            c.format(output, event);
            output.write("</td>");
            output.write(Layout.LINE_SEP);
            c = c.next;
        }
        output.write("</tr>");
        output.write(Layout.LINE_SEP);
        if (!this.chainHandlesThrowable && (s = event.getThrowableStrRep()) != null) {
            output.write("<tr><td class=\"exception\" colspan=\"6\">");
            this.appendThrowableAsHTML(s, output);
            output.write("</td></tr>" + Layout.LINE_SEP);
        }
    }

    void getInternalCSS(StringBuffer buf) {
        buf.append("<STYLE  type=\"text/css\">");
        buf.append(Layout.LINE_SEP);
        buf.append("table { margin-left: 2em; margin-right: 2em; border-left: 2px solid #AAA; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TR.even { background: #FFFFFF; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TR.odd { background: #DADADA; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TR.warn TD.level, TR.error TD.level, TR.fatal TD.level {font-weight: bold; color: #FF4040 }");
        buf.append(Layout.LINE_SEP);
        buf.append("TD { padding-right: 1ex; padding-left: 1ex; border-right: 2px solid #AAA; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TD.time, TD.date { text-align: right; font-family: courier, monospace; font-size: smaller; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TD.sn { text-align: right; width: 5ex; font-family: courier, monospace; font-size: smaller; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TD.thread { text-align: left; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TD.level { text-align: right; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TD.logger { text-align: left; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TR.header { background: #9090FF; color: #FFF; font-weight: bold; font-size: larger; }");
        buf.append(Layout.LINE_SEP);
        buf.append("TD.exception { background: #C0C0F0; font-family: courier, monospace;}");
        buf.append(Layout.LINE_SEP);
        buf.append("</STYLE>");
        buf.append(Layout.LINE_SEP);
    }
}

