/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.io.IOException;
import java.io.Writer;

public class Transform {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String CDATA_PSEUDO_END = "]]&gt;";
    private static final String CDATA_EMBEDED_END = "]]>]]&gt;<![CDATA[";
    private static final int CDATA_END_LEN = "]]>".length();

    public static void escapeTags(String input, Writer output) throws IOException {
        if (input == null || input.length() == 0) {
            return;
        }
        int ch = 32;
        int len = input.length();
        int i = 0;
        while (i < len) {
            ch = input.charAt(i);
            if (ch == 60) {
                output.write("&lt;");
            } else if (ch == 62) {
                output.write("&gt;");
            } else {
                output.write(ch);
            }
            ++i;
        }
    }

    public static void appendEscapingCDATA(Writer output, String str) throws IOException {
        if (str == null) {
            return;
        }
        int end = str.indexOf(CDATA_END);
        if (end < 0) {
            output.write(str);
            return;
        }
        int start = 0;
        while (end > -1) {
            output.write(str.substring(start, end));
            output.write(CDATA_EMBEDED_END);
            start = end + CDATA_END_LEN;
            if (start < str.length()) {
                end = str.indexOf(CDATA_END, start);
                continue;
            }
            return;
        }
        output.write(str.substring(start));
    }
}

