/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.io.File;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class FileWatchdog
extends Thread {
    public static final long DEFAULT_DELAY = 60000L;
    protected String filename;
    private Logger logger = LogManager.getLogger(class$org$apache$log4j$helpers$SyslogWriter == null ? (class$org$apache$log4j$helpers$SyslogWriter = FileWatchdog.class$("org.apache.log4j.helpers.SyslogWriter")) : class$org$apache$log4j$helpers$SyslogWriter);
    protected long delay = 60000L;
    File file;
    long lastModif = 0L;
    boolean warnedAlready = false;
    boolean interrupted = false;
    static /* synthetic */ Class class$org$apache$log4j$helpers$SyslogWriter;

    protected FileWatchdog(String filename) {
        this.filename = filename;
        this.file = new File(filename);
        this.setDaemon(true);
        this.checkAndConfigure();
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    protected abstract void doOnChange();

    protected void checkAndConfigure() {
        boolean fileExists;
        try {
            fileExists = this.file.exists();
        }
        catch (SecurityException e) {
            this.logger.warn("Was not allowed to read check file existance, file:[" + this.filename + "].");
            this.interrupted = true;
            return;
        }
        if (fileExists) {
            long l = this.file.lastModified();
            if (l > this.lastModif) {
                this.lastModif = l;
                this.doOnChange();
                this.warnedAlready = false;
            }
        } else if (!this.warnedAlready) {
            this.logger.debug("[" + this.filename + "] does not exist.");
            this.warnedAlready = true;
        }
    }

    public void run() {
        while (!this.interrupted) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.checkAndConfigure();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

