/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import java.util.List;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.ErrorItem;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.varia.ListAppender;

public abstract class ConfiguratorBase
implements Configurator {
    public static final String DEBUG_KEY = "log4j.debug";

    protected Logger getLogger(LoggerRepository repository) {
        return repository.getLogger(this.getClass().getName());
    }

    protected void addError(ErrorItem errorItem) {
        this.getErrorList().add(errorItem);
    }

    public abstract List getErrorList();

    protected void attachListAppender(LoggerRepository repository) {
        Logger ll = repository.getLogger("org.apache.log4j");
        ListAppender appender = new ListAppender();
        appender.setName("TEMP_LIST_APPENDER");
        ll.addAppender(appender);
        ll.setAdditivity(false);
    }

    protected void detachListAppender(LoggerRepository repository) {
        Logger ll = repository.getLogger("org.apache.log4j");
        ll.setAdditivity(true);
        ListAppender listAppender = (ListAppender)ll.getAppender("TEMP_LIST_APPENDER");
        if (listAppender == null) {
            String errMsg = "Could not find appender TEMP_LIST_APPENDER";
            this.getLogger(repository).error(errMsg);
            this.addError(new ErrorItem(errMsg));
            return;
        }
        List eventList = listAppender.getList();
        int size = eventList.size();
        int i = 0;
        while (i < size) {
            LoggingEvent event = (LoggingEvent)eventList.get(i);
            Logger xLogger = event.getLogger();
            if (event.getLevel().isGreaterOrEqual(xLogger.getEffectiveLevel())) {
                xLogger.callAppenders(event);
            }
            ++i;
        }
        listAppender.clearList();
        listAppender.close();
        ll.removeAppender(listAppender);
    }

    public static void attachTemporaryConsoleAppender(LoggerRepository repository) {
        Logger ll = repository.getLogger("org.apache.log4j");
        ConsoleAppender appender = new ConsoleAppender();
        appender.setLayout(new PatternLayout("LOG4J-INTERNAL: %d %level [%t] %c#%M:%L)- %m%n"));
        appender.setName("TEMP_CONSOLE_APPENDER");
        appender.activateOptions();
        ll.addAppender(appender);
    }

    public static void detachTemporaryConsoleAppender(LoggerRepository repository, List errorList) {
        Logger ll = repository.getLogger("org.apache.log4j");
        ConsoleAppender consoleAppender = (ConsoleAppender)ll.getAppender("TEMP_CONSOLE_APPENDER");
        if (consoleAppender == null) {
            String errMsg = "Could not find appender TEMP_LIST_APPENDER";
            errorList.add(new ErrorItem(errMsg));
            return;
        }
        consoleAppender.close();
        ll.removeAppender(consoleAppender);
    }

    public void dumpErrors() {
        List errorList = this.getErrorList();
        int i = 0;
        while (i < errorList.size()) {
            ErrorItem ei = (ErrorItem)errorList.get(i);
            ei.dump(System.out);
            ++i;
        }
    }
}

