/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class WriterAppender
extends AppenderSkeleton {
    protected boolean inOrder = false;
    protected boolean immediateFlush = true;
    protected String encoding;
    protected Writer writer;

    public WriterAppender() {
    }

    public WriterAppender(Layout layout, OutputStream os) {
        this(layout, new OutputStreamWriter(os));
    }

    public WriterAppender(Layout layout, Writer writer) {
        this.layout = layout;
        this.setWriter(writer);
    }

    public void setImmediateFlush(boolean value) {
        this.immediateFlush = value;
    }

    public boolean getImmediateFlush() {
        return this.immediateFlush;
    }

    public void activateOptions() {
        if (this.layout == null) {
            this.getLogger().error((Object)"No layout set for the appender named [{}].", this.name);
        }
        if (this.writer != null) {
            this.inOrder = true;
        }
    }

    public void append(LoggingEvent event) {
        if (!this.checkEntryConditions()) {
            return;
        }
        this.subAppend(event);
    }

    protected boolean checkEntryConditions() {
        if (this.closed) {
            this.getLogger().warn("Not allowed to write to a closed appender.");
            return false;
        }
        if (this.writer == null) {
            this.getLogger().error((Object)"No output stream or file set for the appender named [{}].", this.name);
            return false;
        }
        return true;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closeWriter();
    }

    protected void closeWriter() {
        block2: {
            if (this.writer == null) break block2;
            try {
                this.writeFooter();
                this.writer.close();
                this.writer = null;
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Could not close writer for WriterAppener named " + this.name), e);
            }
        }
    }

    protected OutputStreamWriter createWriter(OutputStream os) {
        OutputStreamWriter retval = null;
        String enc = this.getEncoding();
        if (enc != null) {
            try {
                retval = new OutputStreamWriter(os, enc);
            }
            catch (IOException e) {
                this.getLogger().warn("Error initializing output writer.");
                this.getLogger().warn("Unsupported encoding?");
            }
        }
        if (retval == null) {
            retval = new OutputStreamWriter(os);
        }
        return retval;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    public synchronized void setWriter(Writer writer) {
        this.closeWriter();
        this.writer = writer;
        this.writeHeader();
    }

    protected void subAppend(LoggingEvent event) {
        if (!this.inOrder) {
            return;
        }
        try {
            String[] s;
            this.writer.write(this.layout.format(event));
            if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
                int len = s.length;
                int i = 0;
                while (i < len) {
                    this.writer.write(s[i]);
                    this.writer.write(Layout.LINE_SEP);
                    ++i;
                }
            }
            if (this.immediateFlush) {
                this.writer.flush();
            }
        }
        catch (IOException ioe) {
            this.inOrder = false;
            this.getLogger().error((Object)("IO failure for appender named " + this.name), ioe);
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void xreset() {
        this.closeWriter();
    }

    protected void writeFooter() {
        block2: {
            String f;
            if (this.layout == null || (f = this.layout.getFooter()) == null || this.writer == null) break block2;
            try {
                this.writer.write(f);
                this.writer.flush();
            }
            catch (IOException ioe) {
                this.inOrder = false;
                this.getLogger().error((Object)("Failed to write footer for Appender named " + this.name), ioe);
            }
        }
    }

    protected void writeHeader() {
        block2: {
            String h;
            if (this.layout == null || (h = this.layout.getHeader()) == null || this.writer == null) break block2;
            try {
                this.writer.write(h);
            }
            catch (IOException ioe) {
                this.inOrder = false;
                this.getLogger().error((Object)("Failed to write header for WriterAppender named " + this.name), ioe);
            }
        }
    }
}

