/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class TTCCLayout
extends Layout {
    private boolean threadPrinting = true;
    private boolean categoryPrefixing = true;
    private boolean contextPrinting = true;
    protected final StringBuffer buf = new StringBuffer(64);
    Date date = new Date();
    DateFormat formatter;
    protected FieldPosition pos = new FieldPosition(0);

    public TTCCLayout() {
        this.setDateFormat("ISO8601");
    }

    public void activateOptions() {
    }

    public void setThreadPrinting(boolean threadPrinting) {
        this.threadPrinting = threadPrinting;
    }

    public boolean getThreadPrinting() {
        return this.threadPrinting;
    }

    public void setCategoryPrefixing(boolean categoryPrefixing) {
        this.categoryPrefixing = categoryPrefixing;
    }

    public boolean getCategoryPrefixing() {
        return this.categoryPrefixing;
    }

    public void setContextPrinting(boolean contextPrinting) {
        this.contextPrinting = contextPrinting;
    }

    public boolean getContextPrinting() {
        return this.contextPrinting;
    }

    public void setDateFormat(String dateFormatStr) {
        if (dateFormatStr == null) {
            this.formatter = null;
            return;
        }
        String dateFormatPattern = null;
        dateFormatPattern = dateFormatStr.equalsIgnoreCase("NULL") ? null : (dateFormatStr.equalsIgnoreCase("ABSOLUTE") ? "HH:mm:ss,SSS" : (dateFormatStr.equalsIgnoreCase("DATE") ? "dd MMM yyyy HH:mm:ss,SSS" : (dateFormatStr.equalsIgnoreCase("ISO8601") ? "yyyy-MM-dd HH:mm:ss,SSS" : dateFormatStr)));
        if (dateFormatPattern != null) {
            this.formatter = new SimpleDateFormat(dateFormatPattern);
        }
    }

    public void format(Writer output, LoggingEvent event) throws IOException {
        String ndc;
        this.buf.setLength(0);
        if (this.formatter != null) {
            this.date.setTime(event.getTimeStamp());
            this.formatter.format(this.date, this.buf, this.pos);
            this.buf.append(' ');
        }
        output.write(this.buf.toString());
        if (this.threadPrinting) {
            output.write(91);
            output.write(event.getThreadName());
            output.write("] ");
        }
        output.write(event.getLevel().toString());
        output.write(32);
        if (this.categoryPrefixing) {
            output.write(event.getLoggerName());
            output.write(32);
        }
        if (this.contextPrinting && (ndc = event.getNDC()) != null) {
            output.write(ndc);
            output.write(32);
        }
        output.write("- ");
        output.write(event.getRenderedMessage());
        output.write(Layout.LINE_SEP);
    }
}

