/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.DefaultCategoryFactory;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.config.ConfiguratorBase;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.ErrorItem;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.OptionHandler;
import org.apache.log4j.spi.RendererSupport;

public class PropertyConfigurator
extends ConfiguratorBase {
    static final String CATEGORY_PREFIX = "log4j.category.";
    static final String LOGGER_PREFIX = "log4j.logger.";
    static final String FACTORY_PREFIX = "log4j.factory";
    static final String ADDITIVITY_PREFIX = "log4j.additivity.";
    static final String ROOT_CATEGORY_PREFIX = "log4j.rootCategory";
    static final String ROOT_LOGGER_PREFIX = "log4j.rootLogger";
    static final String APPENDER_PREFIX = "log4j.appender.";
    static final String RENDERER_PREFIX = "log4j.renderer.";
    static final String THRESHOLD_PREFIX = "log4j.threshold";
    public static final String LOGGER_FACTORY_KEY = "log4j.loggerFactory";
    private static final String INTERNAL_ROOT_NAME = "root";
    protected Hashtable registry = new Hashtable(11);
    protected LoggerFactory loggerFactory = new DefaultCategoryFactory();
    protected List errorList = new Vector();
    static /* synthetic */ Class class$org$apache$log4j$spi$LoggerFactory;
    static /* synthetic */ Class class$org$apache$log4j$Appender;
    static /* synthetic */ Class class$org$apache$log4j$Layout;

    public void doConfigure(String configFileName, LoggerRepository repo) {
        Properties props = new Properties();
        try {
            FileInputStream istream = new FileInputStream(configFileName);
            props.load(istream);
            istream.close();
        }
        catch (IOException e) {
            String errMsg = "Could not read configuration file [" + configFileName + "].";
            this.addError(new ErrorItem(errMsg, e));
            this.getLogger(repo).error((Object)errMsg, e);
            return;
        }
        this.doConfigure(props, repo);
    }

    public static void configure(String configFilename) {
        new PropertyConfigurator().doConfigure(configFilename, LogManager.getLoggerRepository());
    }

    public static void configure(URL configURL) {
        new PropertyConfigurator().doConfigure(configURL, LogManager.getLoggerRepository());
    }

    public static void configure(Properties properties) {
        new PropertyConfigurator().doConfigure(properties, LogManager.getLoggerRepository());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConfigure(Properties properties, LoggerRepository repository) {
        String value = properties.getProperty("log4j.debug");
        try {
            this.attachListAppender(repository);
            boolean attachedConsoleApepnder = false;
            if (value != null && OptionConverter.toBoolean(value, true)) {
                ConfiguratorBase.attachTemporaryConsoleAppender(repository);
                attachedConsoleApepnder = true;
            }
            repository.setPristine(false);
            String thresholdStr = OptionConverter.findAndSubst(THRESHOLD_PREFIX, properties);
            if (thresholdStr != null) {
                repository.setThreshold(OptionConverter.toLevel(thresholdStr, Level.ALL));
                this.getLogger(repository).debug("Hierarchy threshold set to [" + repository.getThreshold() + "].");
            }
            this.configureRootCategory(properties, repository);
            this.configureLoggerFactory(properties, repository);
            this.parseCatsAndRenderers(properties, repository);
            this.getLogger(repository).debug("Finished configuring.");
            if (attachedConsoleApepnder) {
                ConfiguratorBase.detachTemporaryConsoleAppender(repository, this.errorList);
            }
            this.clearRegistry();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.detachListAppender(repository);
            throw throwable;
        }
        this.detachListAppender(repository);
    }

    protected void clearRegistry() {
        this.registry.clear();
    }

    public void doConfigure(URL configURL, LoggerRepository repository) {
        Properties props = new Properties();
        this.getLogger(repository).debug((Object)"Reading configuration from URL {}", configURL);
        try {
            InputStream in = configURL.openStream();
            props.load(in);
            in.close();
        }
        catch (IOException e) {
            String errMsg = "Could not read configuration file from URL [" + configURL + "].";
            this.addError(new ErrorItem(errMsg, e));
            this.getLogger(repository).error((Object)errMsg, e);
            return;
        }
        this.doConfigure(props, repository);
    }

    public void doConfigure(InputStream configStream, LoggerRepository repository) {
        Properties props = new Properties();
        this.getLogger(repository).debug("Reading configuration from input stream");
        try {
            props.load(configStream);
        }
        catch (IOException e) {
            String errMsg = "Could not read configuration file from input stream.";
            this.addError(new ErrorItem(errMsg, e));
            this.getLogger(repository).error((Object)errMsg, e);
            return;
        }
        this.doConfigure(props, repository);
    }

    protected void configureLoggerFactory(Properties props, LoggerRepository repository) {
        String factoryClassName = OptionConverter.findAndSubst(LOGGER_FACTORY_KEY, props);
        if (factoryClassName != null) {
            this.loggerFactory = (LoggerFactory)OptionConverter.instantiateByClassName(factoryClassName, class$org$apache$log4j$spi$LoggerFactory == null ? (class$org$apache$log4j$spi$LoggerFactory = PropertyConfigurator.class$("org.apache.log4j.spi.LoggerFactory")) : class$org$apache$log4j$spi$LoggerFactory, this.loggerFactory);
            PropertySetter setter = new PropertySetter(this.loggerFactory);
            setter.setLoggerRepository(repository);
            setter.setProperties(props, "log4j.factory.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configureRootCategory(Properties props, LoggerRepository repository) {
        String effectiveFrefix = ROOT_LOGGER_PREFIX;
        String value = OptionConverter.findAndSubst(ROOT_LOGGER_PREFIX, props);
        if (value == null) {
            value = OptionConverter.findAndSubst(ROOT_CATEGORY_PREFIX, props);
            effectiveFrefix = ROOT_CATEGORY_PREFIX;
        }
        if (value == null) {
            this.getLogger(repository).debug("Could not find root logger information. Is this OK?");
        } else {
            Logger root;
            Logger logger = root = repository.getRootLogger();
            synchronized (logger) {
                this.parseCategory(repository, props, root, effectiveFrefix, INTERNAL_ROOT_NAME, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCatsAndRenderers(Properties props, LoggerRepository repository) {
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (key.startsWith(CATEGORY_PREFIX) || key.startsWith(LOGGER_PREFIX)) {
                Logger logger;
                String loggerName = null;
                if (key.startsWith(CATEGORY_PREFIX)) {
                    loggerName = key.substring(CATEGORY_PREFIX.length());
                } else if (key.startsWith(LOGGER_PREFIX)) {
                    loggerName = key.substring(LOGGER_PREFIX.length());
                }
                String value = OptionConverter.findAndSubst(key, props);
                Logger logger2 = logger = repository.getLogger(loggerName, this.loggerFactory);
                synchronized (logger2) {
                    this.parseCategory(repository, props, logger, key, loggerName, value);
                    this.parseAdditivityForLogger(repository, props, logger, loggerName);
                    continue;
                }
            }
            if (!key.startsWith(RENDERER_PREFIX)) continue;
            String renderedClass = key.substring(RENDERER_PREFIX.length());
            String renderingClass = OptionConverter.findAndSubst(key, props);
            if (!(repository instanceof RendererSupport)) continue;
            RendererSupport rs = (RendererSupport)((Object)repository);
            RendererMap rm = rs.getRendererMap();
            rm.addRenderer(renderedClass, renderingClass);
        }
    }

    void parseAdditivityForLogger(LoggerRepository repository, Properties props, Logger cat, String loggerName) {
        String value = OptionConverter.findAndSubst(ADDITIVITY_PREFIX + loggerName, props);
        this.getLogger(repository).debug("Handling log4j.additivity." + loggerName + "=[" + value + "]");
        if (value != null && !value.equals("")) {
            boolean additivity = OptionConverter.toBoolean(value, true);
            this.getLogger(repository).debug("Setting additivity for \"" + loggerName + "\" to " + additivity);
            cat.setAdditivity(additivity);
        }
    }

    void parseCategory(LoggerRepository repository, Properties props, Logger logger, String optionKey, String loggerName, String value) {
        this.getLogger(repository).debug("Parsing for [{}] with value=[{}].", loggerName, value);
        StringTokenizer st = new StringTokenizer(value, ",");
        if (!value.startsWith(",") && !value.equals("")) {
            if (!st.hasMoreTokens()) {
                return;
            }
            String levelStr = st.nextToken().trim();
            this.getLogger(repository).debug((Object)"Level token is [{}].", levelStr);
            if ("inherited".equalsIgnoreCase(levelStr) || "null".equalsIgnoreCase(levelStr)) {
                if (loggerName.equals(INTERNAL_ROOT_NAME)) {
                    this.getLogger(repository).warn("The root logger cannot be set to null.");
                } else {
                    logger.setLevel(null);
                }
            } else {
                logger.setLevel(OptionConverter.toLevel(levelStr, Level.DEBUG));
            }
            this.getLogger(repository).debug("Category {} set to {}.", loggerName, logger.getLevel());
        }
        logger.removeAllAppenders();
        while (st.hasMoreTokens()) {
            String appenderName = st.nextToken().trim();
            if (appenderName == null || appenderName.equals(",")) continue;
            this.getLogger(repository).debug((Object)"Parsing appender named \"{}\".", appenderName);
            Appender appender = this.parseAppender(repository, props, appenderName);
            if (appender == null) continue;
            logger.addAppender(appender);
        }
    }

    Appender parseAppender(LoggerRepository repository, Properties props, String appenderName) {
        Appender appender = this.registryGet(appenderName);
        if (appender != null) {
            this.getLogger(repository).debug((Object)"Appender \"{}\" was already parsed.", appenderName);
            return appender;
        }
        String prefix = APPENDER_PREFIX + appenderName;
        String layoutPrefix = prefix + ".layout";
        appender = (Appender)OptionConverter.instantiateByKey(props, prefix, class$org$apache$log4j$Appender == null ? (class$org$apache$log4j$Appender = PropertyConfigurator.class$("org.apache.log4j.Appender")) : class$org$apache$log4j$Appender, null);
        if (appender == null) {
            String errMsg = "Could not instantiate appender named \"" + appenderName + "\".";
            this.addError(new ErrorItem(errMsg));
            this.getLogger(repository).error(errMsg);
            return null;
        }
        appender.setName(appenderName);
        appender.setLoggerRepository(repository);
        if (appender instanceof OptionHandler) {
            Layout layout;
            String layoutClassName = OptionConverter.findAndSubst(layoutPrefix, props);
            if (layoutClassName != null && (layout = (Layout)OptionConverter.instantiateByClassName(layoutClassName.trim(), class$org$apache$log4j$Layout == null ? (class$org$apache$log4j$Layout = PropertyConfigurator.class$("org.apache.log4j.Layout")) : class$org$apache$log4j$Layout, null)) != null) {
                layout.setLoggerRepository(repository);
                appender.setLayout(layout);
                this.getLogger(repository).debug("Parsing layout options for \"" + appenderName + "\".");
                PropertySetter layoutPS = new PropertySetter(layout);
                layoutPS.setLoggerRepository(repository);
                layoutPS.setProperties(props, layoutPrefix + ".");
                this.activateOptions(layout);
                this.getLogger(repository).debug("End of parsing for \"" + appenderName + "\".");
            }
            PropertySetter appenderPS = new PropertySetter(appender);
            appenderPS.setLoggerRepository(repository);
            appenderPS.setProperties(props, prefix + ".");
            this.activateOptions(appender);
            this.getLogger(repository).debug("Parsed \"" + appenderName + "\" options.");
        }
        this.registryPut(appender);
        return appender;
    }

    void activateOptions(Object obj) {
        if (obj instanceof OptionHandler) {
            ((OptionHandler)obj).activateOptions();
        }
    }

    void registryPut(Appender appender) {
        this.registry.put(appender.getName(), appender);
    }

    Appender registryGet(String name) {
        return (Appender)this.registry.get(name);
    }

    public List getErrorList() {
        return this.errorList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

