/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.log4j.Layout;
import org.apache.log4j.pattern.PatternConverter;
import org.apache.log4j.pattern.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class PatternLayout
extends Layout {
    public static final String DEFAULT_CONVERSION_PATTERN = "%m%n";
    public static final String TTCC_CONVERSION_PATTERN = "%r [%t] %p %c %x - %m%n";
    public static final String PATTERN_RULE_REGISTRY = "PATTERN_RULE_REGISTRY";
    private String conversionPattern;
    private PatternConverter head;
    private boolean handlesExceptions;

    public PatternLayout() {
        this(DEFAULT_CONVERSION_PATTERN);
    }

    public PatternLayout(String pattern) {
        this.conversionPattern = pattern;
        this.activateOptions();
    }

    public void setConversionPattern(String conversionPattern) {
        this.conversionPattern = conversionPattern;
    }

    public String getConversionPattern() {
        return this.conversionPattern;
    }

    public void activateOptions() {
        PatternParser patternParser = new PatternParser(this.conversionPattern, this.repository);
        if (this.repository != null) {
            patternParser.setConverterRegistry((Map)this.repository.getObject(PATTERN_RULE_REGISTRY));
        }
        this.head = patternParser.parse();
        this.handlesExceptions = PatternConverter.chainHandlesThrowable(this.head);
    }

    public void format(Writer output, LoggingEvent event) throws IOException {
        PatternConverter c = this.head;
        while (c != null) {
            c.format(output, event);
            c = c.next;
        }
    }

    public boolean ignoresThrowable() {
        return !this.handlesExceptions;
    }
}

