/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.IntializationUtil;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.selector.ContextJNDISelector;
import org.apache.log4j.spi.DefaultRepositorySelector;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.apache.log4j.spi.RootLogger;
import org.apache.ugli.impl.SimpleLoggerFA;

public class LogManager {
    private static Object guard = null;
    private static RepositorySelector repositorySelector;
    public static final LoggerRepository defaultLoggerRepository;
    public static final SimpleLoggerFA SIMPLE_LOGGER_FA;
    static /* synthetic */ Class class$org$apache$log4j$spi$RepositorySelector;

    public static void setRepositorySelector(RepositorySelector selector, Object guard) throws IllegalArgumentException {
        if (LogManager.guard != null && LogManager.guard != guard) {
            throw new IllegalArgumentException("Attempted to reset the LoggerFactory without possessing the guard.");
        }
        if (selector == null) {
            throw new IllegalArgumentException("RepositorySelector must be non-null.");
        }
        LogManager.guard = guard;
        repositorySelector = selector;
    }

    public static RepositorySelector getRepositorySelector() {
        return repositorySelector;
    }

    public static LoggerRepository getLoggerRepository() {
        return repositorySelector.getLoggerRepository();
    }

    public static Logger getRootLogger() {
        return repositorySelector.getLoggerRepository().getRootLogger();
    }

    public static Logger getLogger(String name) {
        return repositorySelector.getLoggerRepository().getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return repositorySelector.getLoggerRepository().getLogger(clazz.getName());
    }

    public static Logger getLogger(String name, LoggerFactory factory) {
        return repositorySelector.getLoggerRepository().getLogger(name, factory);
    }

    public static Logger exists(String name) {
        return repositorySelector.getLoggerRepository().exists(name);
    }

    public static Enumeration getCurrentLoggers() {
        return repositorySelector.getLoggerRepository().getCurrentLoggers();
    }

    public static void shutdown() {
        repositorySelector.getLoggerRepository().shutdown();
    }

    public static void resetConfiguration() {
        repositorySelector.getLoggerRepository().resetConfiguration();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SIMPLE_LOGGER_FA = new SimpleLoggerFA();
        defaultLoggerRepository = new Hierarchy(new RootLogger(Level.DEBUG));
        defaultLoggerRepository.setName("default");
        repositorySelector = new DefaultRepositorySelector(defaultLoggerRepository);
        String configuratorClassName = OptionConverter.getSystemProperty("log4j.configuratorClass", null);
        String configurationOptionStr = OptionConverter.getSystemProperty("log4j.configuration", null);
        if (configurationOptionStr == null) {
            if (Loader.getResource("log4j.xml") != null) {
                configurationOptionStr = "log4j.xml";
            } else if (Loader.getResource("log4j.properties") != null) {
                configurationOptionStr = "log4j.properties";
            }
        }
        System.out.println("*** configurationOptionStr=" + configurationOptionStr);
        IntializationUtil.initialConfiguration(defaultLoggerRepository, configurationOptionStr, configuratorClassName);
        String repositorySelectorStr = OptionConverter.getSystemProperty("log4j.repositorySelector", null);
        if (repositorySelectorStr != null) {
            if (repositorySelectorStr.equalsIgnoreCase("JNDI")) {
                System.out.println("*** Will use ContextJNDISelector **");
                repositorySelector = new ContextJNDISelector();
                guard = new Object();
            } else {
                Object r = OptionConverter.instantiateByClassName(repositorySelectorStr, class$org$apache$log4j$spi$RepositorySelector == null ? (class$org$apache$log4j$spi$RepositorySelector = LogManager.class$("org.apache.log4j.spi.RepositorySelector")) : class$org$apache$log4j$spi$RepositorySelector, null);
                if (r instanceof RepositorySelector) {
                    System.out.println("*** Using [" + repositorySelectorStr + "] instance as repository selector.");
                    repositorySelector = (RepositorySelector)r;
                    guard = new Object();
                } else {
                    System.out.println("*** Could not insantiate [" + repositorySelectorStr + "] as repository selector.");
                    System.out.println("*** Using default repository selector");
                    repositorySelector = new DefaultRepositorySelector(defaultLoggerRepository);
                }
            }
        }
        System.out.println("** End of LogManager static initializer");
    }
}

