/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Layout;
import org.apache.log4j.WriterAppender;

public class ConsoleAppender
extends WriterAppender {
    public static final String SYSTEM_OUT = "System.out";
    public static final String SYSTEM_ERR = "System.err";
    protected String target = "System.out";

    public ConsoleAppender() {
    }

    public ConsoleAppender(Layout layout) {
        this(layout, SYSTEM_OUT);
    }

    public ConsoleAppender(Layout layout, String targetStr) {
        this.layout = layout;
        this.setTarget(targetStr);
        this.activateOptions();
    }

    public void setTarget(String value) {
        String v = value.trim();
        if (SYSTEM_OUT.equalsIgnoreCase(v)) {
            this.target = SYSTEM_OUT;
        } else if (SYSTEM_ERR.equalsIgnoreCase(v)) {
            this.target = SYSTEM_ERR;
        } else {
            this.targetWarn(value);
        }
    }

    public String getTarget() {
        return this.target;
    }

    void targetWarn(String val) {
        this.getLogger().warn((Object)"[{}] should be System.out or System.err.", val);
        this.getLogger().warn("Using previously set target, System.out by default.");
    }

    public void activateOptions() {
        if (this.target.equals(SYSTEM_OUT)) {
            this.setWriter(this.createWriter(System.out));
        } else {
            this.setWriter(this.createWriter(System.err));
        }
        super.activateOptions();
    }

    protected final void closeWriter() {
    }
}

