/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;

public abstract class AppenderSkeleton
extends ComponentBase
implements Appender,
OptionHandler {
    protected Layout layout;
    protected String name;
    protected Level threshold;
    protected Filter headFilter;
    protected Filter tailFilter;
    protected boolean closed = false;
    private boolean guard = false;

    public void activateOptions() {
    }

    public void addFilter(Filter newFilter) {
        if (this.headFilter == null) {
            this.headFilter = newFilter;
            this.tailFilter = newFilter;
        } else {
            this.tailFilter.setNext(newFilter);
            this.tailFilter = newFilter;
        }
    }

    protected abstract void append(LoggingEvent var1);

    public void clearFilters() {
        this.headFilter = null;
        this.tailFilter = null;
    }

    public void finalize() {
        if (this.closed) {
            return;
        }
        this.getLogger().debug((Object)"Finalizing appender named [{}].", this.name);
        this.close();
    }

    public Filter getFilter() {
        return this.headFilter;
    }

    public final Filter getFirstFilter() {
        return this.headFilter;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public final String getName() {
        return this.name;
    }

    public Level getThreshold() {
        return this.threshold;
    }

    public boolean isAsSevereAsThreshold(Level level) {
        return this.threshold == null || level.isGreaterOrEqual(this.threshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void doAppend(LoggingEvent event) {
        if (this.guard) {
            return;
        }
        try {
            this.guard = true;
            if (this.closed) {
                this.getLogger().error((Object)"Attempted to append to closed appender named [{}].", this.name);
                Object var4_2 = null;
                this.guard = false;
                return;
            }
            if (this.isAsSevereAsThreshold(event.getLevel())) {
                Filter f = this.headFilter;
                block7: while (f != null) {
                    switch (f.decide(event)) {
                        case -1: {
                            Object var4_4 = null;
                            this.guard = false;
                            return;
                        }
                        case 1: {
                            break block7;
                        }
                        case 0: {
                            f = f.getNext();
                        }
                        default: {
                            continue block7;
                        }
                    }
                }
                this.append(event);
                Object var4_5 = null;
                this.guard = false;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.guard = false;
            throw throwable;
        }
        Object var4_3 = null;
        this.guard = false;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setThreshold(Level threshold) {
        this.threshold = threshold;
    }
}

