<?xml version='1.0' encoding='utf-8' ?>
<xsl:transform version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" indent="yes" />
  <xsl:template match="/partdescriptionfile" name="pdf">
  <xsl:copy-of select="part/part_name" />
  <core>
    <xsl:copy-of select="core/registers" />
  </core>
  <memory>
  <xsl:for-each select="memory/block">
    <xsl:element name="block">
       <xsl:attribute name="name"><xsl:value-of select="name" /></xsl:attribute>
       <xsl:attribute name="type"><xsl:value-of select="type" /></xsl:attribute>
       <xsl:attribute name="address"><xsl:value-of select="address" /></xsl:attribute>
       <xsl:attribute name="size"><xsl:value-of select="size" /></xsl:attribute>
    </xsl:element>
  </xsl:for-each>
  </memory>
  <io_modules>
    <xsl:for-each select="io_modules/io_module">
      <io_module>
	<xsl:copy-of select="name" />
	<xsl:copy-of select="text" />
	<xsl:copy-of select="registers" />
        <instances>
          <xsl:for-each select="instances/instance">
            <instance>
              <xsl:copy-of select="name" />
              <xsl:copy-of select="memory_ranges" />
            </instance>
          </xsl:for-each>
        </instances>
      </io_module>
    </xsl:for-each>
  </io_modules>
  </xsl:template>

  <xsl:template match="/">
    <partdescriptionfile>
    <xsl:apply-templates />
    </partdescriptionfile>
  </xsl:template>

</xsl:transform>
