/* This file is part of the ATMEL AVR32-UC3-SoftwareFramework-1.6.0 Release */

/*This file is prepared for Doxygen automatic documentation generation.*/
/*! \file *********************************************************************
 *
 * \brief AVR32 UC3 ISP.
 *
 * In order to be able to program a project with both BatchISP and JTAGICE mkII
 * without erasing the pre-programmed ISP, add this file to the project and
 * change the program entry point to _isp.
 *
 * The general-purpose fuses will have to be set to the value specified in the
 * ISP user's manual if JTAGICE mkII is used.
 *
 * - Compiler:           GNU GCC for AVR32
 * - Supported devices:  All AVR32UC devices can be used.
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 ******************************************************************************/

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
 *
 */

#include "../CONF/conf_isp.h"


#if   __AVR32_UC3A0128__ ||                                                    \
      __AVR32_UC3A0256__ ||                                                    \
      __AVR32_UC3A0512__ ||                                                    \
      __AVR32_UC3A1128__ ||                                                    \
      __AVR32_UC3A1256__ ||                                                    \
      __AVR32_UC3A1512__
  #define ISP_BIN             "../AT32UC3A/GCC/at32uc3a-isp.bin"
#elif __AVR32_UC3A364__   ||                                                   \
      __AVR32_UC3A364S__  ||                                                   \
      __AVR32_UC3A3128__  ||                                                   \
      __AVR32_UC3A3128S__ ||                                                   \
      __AVR32_UC3A3256__  ||                                                   \
      __AVR32_UC3A3256S__
  #define ISP_BIN             "../AT32UC3A3/GCC/at32uc3a3-isp.bin"
#elif __AVR32_UC3B064__  ||                                                    \
      __AVR32_UC3B0128__ ||                                                    \
      __AVR32_UC3B0256__ ||                                                    \
      __AVR32_UC3B164__  ||                                                    \
      __AVR32_UC3B1128__ ||                                                    \
      __AVR32_UC3B1256__
  #define ISP_BIN             "../AT32UC3B/GCC/at32uc3b-isp.bin"
#endif


//! @{
//! \verbatim


  // This must be linked @ 0x80000000 if it is to be run upon reset.
  .section  .reset, "ax", @progbits


  .global _isp
  .type _isp, @function
_isp:
  // Include the ISP raw binary image.
  .incbin ISP_BIN

  .org  PROGRAM_START_OFFSET
program_start:
  // Jump to the C runtime startup routine.
  lda.w   pc, _stext


//! \endverbatim
//! @}
