/* This header file is part of the ATMEL AVR32-UC3-SoftwareFramework-1.6.0 Release */

/*This file is prepared for Doxygen automatic documentation generation.*/
/*! \file *********************************************************************
 *
 * \brief FreeRTOS application example for AVR32 UC3.
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All AVR32 devices can be used.
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 ******************************************************************************/

/*! \mainpage
 * \section intro Introduction
 *
 * This is the documentation for the data structures, functions, variables,
 * defines, enums, and typedefs for the FreeRTOS application.
 *
 * \image html freertos.gif
 *
 * FreeRTOS.orgTM is a portable, open source, mini Real Time Kernel - a
 * free to download and royalty free RTOS that can be used in commercial
 * applications (see license text). This site shows how a complete embedded
 * real time system can be created from a Windows host using quality open
 * source development tools (where available). See the FreeRTOS.org features
 * summary.
 * Highlights include:
 * - Free RTOS kernel - preemptive, cooperative and hybrid configuration options.
 * - Designed to be small, simple and easy to use.
 * - Very portable code structure predominantly written in C.
 * - Supports both tasks and co-routines.
 * - No software restriction on the number of tasks that can be created.
 * - No software restriction on the number of priorities that can be used.
 * - No restrictions imposed on priority assignment - more than one task can be assigned the same priority.
 * - Queues and semaphores for communication and synchronisation between tasks, or between tasks and interrupts.
 * - Free embedded software source code.
 * - Royalty free.
 * - Cross development from a standard Windows host.
 * - Pre-configured demo applications for selected single board computers allowing 'out of the box' operation and fast learning curve.
 * - Compile time configuration allows small FLASH footprint
 * - The SafeRTOS derivative product provides a high level of confidence in the code integrity.
 *
 * \section files Main Files
 * - main.c : FreeRTOS example
 *
 * \section compilinfo Compilation Information
 * This software is written for GNU GCC for AVR32 and for IAR Embedded Workbench
 * for Atmel AVR32. Other compilers may or may not work.
 *
 * \section deviceinfo Device Information
 * All AVR32 devices can be used.
 *
 * \section configinfo Configuration Information
 * This example has been tested with the following configuration:
 * - EVK1100, EVK1101, EVK1104 or EVK1105 evalutation kit;
 * - CPU clock: 12 MHz;
 * - USART1 (on EVK1100 or EVK1101) connected to a PC serial port via a standard
 *   RS232 DB9 cable, or USART0 (on EVK1105) or USART1 (on EVK1104) abstracted
 *   with a USB CDC connection to a PC;
 * - PC terminal settings:
 *   - 57600 bps,
 *   - 8 data bits,
 *   - no parity bit,
 *   - 1 stop bit,
 *   - no flow control.
 * - The application is made as the USART1 should be looped back by connecting the TX line with the RX line.
 *  - On \b EVK1100, connect pin number 39 (PA05) with 41 (PA06) with AT32UC3A0512 in QFP144 package.
 *  - On \b EVK1101, connect pin number 47 (PA23) with 59 (PA24) with AT32UC3B0256 in QFP64 package.
 *
 * Check the LEDs for all EVKs. The LEDs should blink at different rates.\n
 * On the PC terminal, you should also see the following message:
 * \code ../../main.c:176: Starting the FreeRTOS AVR32 UC3 Demo...
 * ABCDEFGHIJKLMNOPQRSTUVWXABCDEFGHIJKLMNOPQRSTUVWXABCDEFGHIJKLMNOPQRSTUVWXABCDEFGH
 * IJKLMNOPQRSTUVWXABCDEFGHIJKLMNOPQRSTUVWXABCDEFGHIJKLMNOPQRSTUVWXABCDEFGHIJKLMNO
 * \endcode
 * The \e ABCD... sequence should be printed recurently on the terminal, which means the
 * communication through the USART is established and is working.
 *
 * \section contactinfo Contact Information
 * For further information, visit
 * <A href="http://www.atmel.com/products/AVR32/" >Atmel AVR32</A>. and
 * <A href="http://www.freertos.org/" >FreeRTOS home page</A>.\n
 * Support and FAQ: http://support.atmel.no/
 */
