/* This header file is part of the ATMEL AVR32-UC3-SoftwareFramework-1.6.0 Release */

/*This file is prepared for Doxygen automatic documentation generation.*/
/*! \file *********************************************************************
 *
 * \brief Fixed Point DSP library
 *
 * This file declares the functions supported by the DSP library
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All AVR32 devices.
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 ******************************************************************************/

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
 *
 */
#ifndef __DSP_H__
#define __DSP_H__

/*! \name Algorithm's optimization options
 * \warning WARNING! Do not modify those defines. There are here to be used with the \ref DSP_OPTIMIZATION definition.
 */
//! \{
/*! \ingroup group_optimization
 * \brief To accelerate the algorithms
*/
#define DSP_OPTI_SPEED  0
/*! \ingroup group_optimization
 * \brief To be the more accurate as the algorithm can be
 */
#define DSP_OPTI_ACCURACY   1
/*! \ingroup group_optimization
 * \brief To minimize the size of the data needed to compute the algorithms
 */
#define DSP_OPTI_SIZE  2
/*! \ingroup group_optimization
 * \brief To be the more accurate and smallest as the algorithm can be
 */
#define DSP_OPTI_ACC_AND_SIZE  (DSP_OPTI_ACCURACY | DSP_OPTI_SIZE)
//! \}

/*! \name Algorithm's optimization
 * \ingroup group_optimization
 * \brief This is the define you have to modify in order to optimize the algorithms according to your needs.
 * i.e.: if you want to make the algorithms as accurate as they can be and the smallest possible, use this definition:
 * \code #define DSP_OPTIMIZATION  DSP_OPTI_ACC_AND_SIZE \endcode
 * \note You can directly modify this value by defining at the compilation this define with the desired value.
 */
//! \{
#ifndef DSP_OPTIMIZATION
# if (defined __GNUC__) && (defined __OPTIMIZE_SIZE__)
#   define DSP_OPTIMIZATION  (DSP_OPTI_SIZE)
# else
#   define DSP_OPTIMIZATION  (DSP_OPTI_SPEED)
# endif
#endif
//! \}

// Type definitions
#include "dsp_types.h"

// Target optimizations
#include "target_optim.h"

// ******* Function definitions *******
// Advanced module
#include "dsp_advanced.h"
// Basic module
#include "dsp_vectors.h"
#include "dsp_filtering.h"
#include "dsp_operators.h"
#include "dsp_signal_generation.h"
#include "dsp_transforms.h"
#include "dsp_windowing.h"
// ********************************

#endif //__DSP_H__
