/* This header file is part of the ATMEL AVR32-UC3-SoftwareFramework-1.6.0 Release */

/*This file is prepared for Doxygen automatic documentation generation.*/
/*! \file *********************************************************************
 *
 * \brief Doxygen documentation
 *
 * This file add some doxygen documentation to the project
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All AVR32 devices.
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 ******************************************************************************/

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
 *
 */
/************* Group definition for doxygen documentation ******************/

/*! \defgroup group_functions Basic
 *  This group regroups all the basic functions you can use in your project.
 */
/*! \defgroup group_filtering Filtering
 *  \ingroup group_functions
 *  All the filtering functions currently supported by the DSP library.
 */
/*! \defgroup group_operators Operators
 *  \ingroup group_functions
 *  All the fixed point operators functions currently implemented in the DSP library.
 */
/*! \defgroup group_signal_generation Signal generation
 *  \ingroup group_functions
 *  All the signal generation functions currently supported by the DSP library.
 */
/*! \defgroup group_transforms Transforms
 *  \ingroup group_functions
 *  All the transforms functions currently supported by the DSP library.
 */
/*! \defgroup group_vectors Vectors
 *  \ingroup group_functions
 *  All the vector management functions currently supported by the DSP library.
 */
/*! \defgroup group_windowing Windowing
 *  \ingroup group_functions
 *  All the windowing functions currently supported by the DSP library.
 */

/*! \defgroup group_config Configuration
 *  This group regroups all the defines you can change to optimize the DSP Library for your needs.
 */
/*! \defgroup group_cstdata Constant tables
 *  \ingroup group_config
 * These defines are used to configure data table storage methods
 */
/*! \defgroup group_optimization Optimization options
 *  \ingroup group_config
 * Those parameters are used for optimizing the algorithms according to your needs.\n
 * By default algorithms are defined to run the fastest as they can.
 */
/*! \defgroup group_qformat Q Format
 * \ingroup group_config
 * This module regroups the options used to configure the signed fixed point Q format.\n
 */
/*! \defgroup group_constants Constants
 *  This group regroups all the constants you can use in your project.
 */
/*! \defgroup group_macros Macros
 *  This group regroups all the defined macros you can use in your project.
 */
/*! \defgroup group_types Types
 *  This group regroups all the types you can use in your project.
 */

/***********************************************************************/
