# Hey Emacs, this is a -*- makefile -*-

# The purpose of this file is to define the build configuration variables used
# by the generic Makefile. See Makefile header for further information.

# Copyright (c) 2009 Atmel Corporation. All rights reserved. 
#
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, this
# list of conditions and the following disclaimer. 
#
# 2. Redistributions in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation 
# and/or other materials provided with the distribution.
#
# 3. The name of Atmel may not be used to endorse or promote products derived 
# from this software without specific prior written permission.  
#
# 4. This software may only be redistributed and used in connection with an Atmel 
# AVR product. 
#
# THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED 
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE 
# EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR 
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND 
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
#
# Base paths
GENERIC_PRJ_PATH = ../../../../..
GENERIC_APPS_PATH = $(GENERIC_PRJ_PATH)/APPLICATIONS
GENERIC_BRDS_PATH = $(GENERIC_PRJ_PATH)/BOARDS
GENERIC_COMP_PATH = $(GENERIC_PRJ_PATH)/COMPONENTS
GENERIC_DRVR_PATH = $(GENERIC_PRJ_PATH)/DRIVERS
GENERIC_SERV_PATH = $(GENERIC_PRJ_PATH)/SERVICES
GENERIC_UTIL_PATH = $(GENERIC_PRJ_PATH)/UTILS

# DSP library path
GENERIC_DSPLIB_PATH = $(DSPLIB_PATH)
GENERIC_DSPLIB_GENERIC_PATH = $(DSPLIB_PATH)/GENERIC
GENERIC_DSPLIB_BASIC_PATH = $(DSPLIB_GENERIC_PATH)/BASIC
GENERIC_DSPLIB_ADVANCED_PATH = $(DSPLIB_GENERIC_PATH)/ADVANCED

# Include path
INC_PATH = \
  $(GENERIC_UTIL_PATH)/ \
  $(GENERIC_UTIL_PATH)/PREPROCESSOR/ \
  $(GENERIC_DSPLIB_PATH)/INCLUDE/ \
  $(GENERIC_DSPLIB_BASIC_PATH)/FILTERING/ \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/ \
  $(GENERIC_DSPLIB_BASIC_PATH)/SIGNAL_GENERATION/ \
  $(GENERIC_DSPLIB_BASIC_PATH)/TRANSFORMS/ \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/ \
  $(GENERIC_DSPLIB_BASIC_PATH)/WINDOWING/

# Basic library generic sources

# Generic C sources for the filtering module
GENERIC_FILTERING_SRC = \
  $(GENERIC_DSPLIB_BASIC_PATH)/FILTERING/filt_dsp16_iir.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/FILTERING/filt_dsp16_iirpart.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/FILTERING/filt_dsp16_lms.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/FILTERING/filt_dsp16_nlms.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/FILTERING/filt_dsp32_iir.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/FILTERING/filt_dsp32_iirpart.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/FILTERING/filt_dsp32_lms.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/FILTERING/filt_dsp32_nlms.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/FILTERING/filt_dsp16_lpfirdesign.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/FILTERING/dsp16_filt_interpolation.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/FILTERING/dsp16_filt_interpolation_coefsort.c

# Generic C sources for the operators module
GENERIC_OPERATORS_SRC = \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/op_dsp16_fix_sqrt.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/op_dsp16_kfix_ln.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/op_dsp32_fix_sqrt.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/op_dsp32_kfix_ln.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/op_fix_asin.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/op_fix_exp.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/op_fix_ln.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/op_fix_log2.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/op_fix_log10.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/op_fix_pow.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/op_fix_rand.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/op_fix_sin.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/op_kfix_cos.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/OPERATORS/op_kfix_sin.c

# Generic C sources for the signal generation module
GENERIC_SIGNAL_GENERATION_SRC = \
  $(GENERIC_DSPLIB_BASIC_PATH)/SIGNAL_GENERATION/gen_cosinusoidal.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/SIGNAL_GENERATION/gen_noise.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/SIGNAL_GENERATION/gen_sinusoidal.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/SIGNAL_GENERATION/gen_rectangular.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/SIGNAL_GENERATION/gen_sawtooth.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/SIGNAL_GENERATION/gen_diraccomb.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/SIGNAL_GENERATION/gen_ramp.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/SIGNAL_GENERATION/gen_step.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/SIGNAL_GENERATION/gen_dirac.c

# Generic C sources for the transforms module
GENERIC_TRANSFORMS_SRC = \
  $(GENERIC_DSPLIB_BASIC_PATH)/TRANSFORMS/trans_dsp16_twiddle_factors.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/TRANSFORMS/trans_dsp32_twiddle_factors.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/TRANSFORMS/trans_dsp16_complex_fft.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/TRANSFORMS/trans_dsp16_complex_ifft.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/TRANSFORMS/trans_dsp16_realcomplex_fft.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/TRANSFORMS/trans_dsp32_realcomplex_fft.c

# Generic C sources for the vectors module
GENERIC_VECTORS_SRC = \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_convolution.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_add.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_add_and_saturate.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_realadd.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_realsub.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_convpart.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_dotdiv.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_dotmul.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_max.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_min.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_neg.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_pow.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_realdiv.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_realmul.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_sub.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_intmul.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_intdiv.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_add.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_add_and_saturate.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_realadd.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_realsub.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_convpart.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_dotdiv.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_dotmul.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_max.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_min.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_neg.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_pow.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_realdiv.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_realmul.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_sub.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_intmul.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_intdiv.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_complex_abs.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_complex_add.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_complex_sub.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_complex_abs.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_complex_add.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp32_complex_sub.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/VECTORS/vect_dsp16_complex_conj.c

# Generic C sources for the windowing module
GENERIC_WINDOWING_SRC = \
  $(GENERIC_DSPLIB_BASIC_PATH)/WINDOWING/win_rectangular.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/WINDOWING/win_bartlett.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/WINDOWING/win_blackman.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/WINDOWING/win_hamming.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/WINDOWING/win_gauss.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/WINDOWING/win_hann.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/WINDOWING/win_dsp16_kaiser.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/WINDOWING/win_dsp32_kaiser.c \
  $(GENERIC_DSPLIB_BASIC_PATH)/WINDOWING/win_welch.c

# Advanced library generic sources
GENERIC_ADVANCED_SRC = \
  $(GENERIC_DSPLIB_ADVANCED_PATH)/ADPCM/adpcm.c \
  $(GENERIC_DSPLIB_ADVANCED_PATH)/RESAMPLING/dsp16_resampling.c

# C source files
CSRCS = \
  $(GENERIC_FILTERING_SRC) \
  $(GENERIC_OPERATORS_SRC) \
  $(GENERIC_SIGNAL_GENERATION_SRC) \
  $(GENERIC_TRANSFORMS_SRC) \
  $(GENERIC_VECTORS_SRC) \
  $(GENERIC_WINDOWING_SRC) \
  $(GENERIC_ADVANCED_SRC)

# Assembler source files
ASSRCS =

# Library path
LIB_PATH =

# Libraries to link with the project
LIBS =

# Linker script file if any
LINKER_SCRIPT =

# Options to request or suppress warnings: [-fsyntax-only] [-pedantic[-errors]] [-w] [-Wwarning...]
# For further details, refer to the chapter "GCC Command Options" of the GCC manual.
WARNINGS = -Wall

# Options for debugging: [-g]...
# For further details, refer to the chapter "GCC Command Options" of the GCC manual.
DEBUG =

# Extra flags to use when preprocessing
CPP_EXTRA_FLAGS =

# Extra flags to use when compiling
C_EXTRA_FLAGS =

# Extra flags to use when assembling
AS_EXTRA_FLAGS =

# Extra flags to use when linking
LD_EXTRA_FLAGS = -Wl,--gc-sections -nostartfiles -Wl,-e,_trampoline

# Documentation path
DOC_PATH = \
  ../../DOC/

# Documentation configuration file
DOC_CFG = \
  ../doxyfile.doxygen
