/* This source file is part of the ATMEL AVR32-UC3-SoftwareFramework-1.6.0 Release */

/*This file is prepared for Doxygen automatic documentation generation.*/
/*! \file *********************************************************************
 *
 * \brief 16-bit and 32-bit welch windowing functions for the AVR32 UC3
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All AVR32 devices.
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 ******************************************************************************/

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
 *
 */

#include "dsp.h"

#if defined(FORCE_ALL_GENERICS) || \
    defined(FORCE_GENERIC_WIN16_WELCH) || \
    !defined(TARGET_SPECIFIC_WIN16_WELCH)

// w = 1-((n - N/2)/(N/2))^2
void dsp16_win_welch(dsp16_t *vect1, int size)
{
  dsp16_t s, t, w;
  int i;

  // Initialization
  t = DSP16_Q(0.);
  // Increment 1/(size*0.5)
  s = (DSP16_Q(1.) / size) << 1;
  // Compute the 1st half
  for(i=0; i<(size >> 1); i++)
  {
    w = t - DSP16_Q(1.);
    w = (((S32) w)*((S32) w)) >> DSP16_QB;
    w = DSP16_Q(1.) - w;
    vect1[i] = w;
    vect1[size-i-1] = w;
    t += s;
  }

  // If the size is odd
  if (size & 1)
    vect1[size >> 1] = DSP16_Q(1.);
}

#endif

#if defined(FORCE_ALL_GENERICS) || \
    defined(FORCE_GENERIC_WIN32_WELCH) || \
    !defined(TARGET_SPECIFIC_WIN32_WELCH)

void dsp32_win_welch(dsp32_t *vect1, int size)
{
  dsp32_t s, t, w;
  int i;

  // Initialization
  t = DSP32_Q(0.);
  // Increment 1/(size*0.5)
  s = (DSP32_Q(1.) / size) << 1;
  // Compute the 1st half
  for(i=0; i<(size >> 1); i++)
  {
    w = t - DSP32_Q(1.);
    w = (((S64) w)*((S64) w)) >> DSP32_QB;
    w = DSP32_Q(1.) - w;
    vect1[i] = w;
    vect1[size-i-1] = w;
    t += s;
  }

  // If the size is odd
  if (size & 1)
    vect1[size >> 1] = DSP32_Q(1.);
}

#endif
