#!/bin/sh

root_path=`pwd`'/../../EXAMPLES/'
path='ADPCM:ADPCM_ENCODER:ADPCM_STREAMING:DSP16_COMPLEX_FFT:DSP16_CONVOLUTION:DSP16_FIR:DSP16_IIR:DSP16_IIRPART:DSP16_LMS:DSP16_NLMS:DSP16_OPERATORS:DSP16_SIGNAL_GENERATION:DSP16_VECTORS:DSP32_COMPLEX_FFT:DSP32_CONVOLUTION:DSP32_FIR:DSP32_IIR:DSP32_IIRPART:DSP32_LMS:DSP32_NLMS:DSP32_OPERATORS:DSP32_SIGNAL_GENERATION:DSP32_VECTORS';
temp_file=`pwd`'/.temp'
iar_comp=`reg query "HKEY_LOCAL_MACHINE\SOFTWARE\IAR Systems\Embedded Workbench\3.1\EWAVR32" | grep "InstallPath" | sed 's/.*REG_SZ.\s*//' | sed 's/\\\\/\\//g'`'/common/bin/iarbuild.exe'

skip_patterns='/VALIDATION'

# Skip patterns
skip_patterns=`echo $skip_patterns | tr -s ':' '\n'`

# directories' names
param=`echo $path | tr -s ':' '\n'`
nb_param=`echo $param | wc -w`


# Argument 1 is the name of the file
check_ew () {
	warning=`grep 'Warning' $1`
	error=`grep 'Error' $1`
	if [ "$error" ] ; then
    printf "\033[0;31m[ ERROR ]\033[0;0m\n"
    printf "\033[0;35m"
    echo $error;
    if [ "$warning" ] ; then
      echo $warning;
    fi
    printf "\033[0;0m"
	elif [ "$warning" ] ; then
    printf "\033[0;33m[ WARNING ]\033[0;0m\n"
    printf "\033[0;35m"
    echo $warning;
    printf "\033[0;0m"
  else
    printf "\033[0;32m[ OK ]\033[0;0m\n"
  fi
}



# Main loop to check every projects
for cur_param in $param
do
  cd "$root_path$cur_param";
	printf "\033[1;34m"$cur_param"\033[0;0m\n";

  # GCC projects
  gcc_project_path=`find ./ -name GCC -type d`
  for cur_gcc_project in $gcc_project_path
  do
    # Skip patterns
    skip=0;
    for cur_skip_pattern in $skip_patterns
    do
      case $cur_gcc_project in
        *$cur_skip_pattern*) skip=1;;
      esac
    done;

    if [ $skip == 0 ] ; then
      cd "$root_path$cur_param";
      cd $cur_gcc_project;
  
      # Doxygen documentation
      if [ -e "Makefile" ] ; then
        printf "<\033[0;36m"$cur_gcc_project"\033[0;0m> ";
    	  printf "Documentation\t"
        make doc 2> $temp_file > /dev/null
        check_ew $temp_file
      fi

      # GCC compilation
      if [ -e "Makefile" ] ; then
        printf "<\033[0;36m"$cur_gcc_project"\033[0;0m> ";
      	printf "Compilation - GCC\t"
      	make rebuild > /dev/null 2> $temp_file
        check_ew $temp_file
      fi
    fi

  done;

  # IAR projects
  cd "$root_path$cur_param";
  iar_project_path=`find ./ -name IAR -type d`
  for cur_iar_project in $iar_project_path
  do
    # Skip patterns
    skip=0;
    for cur_skip_pattern in $skip_patterns
    do
      case $cur_gcc_project in
        *$cur_iar_project*) skip=1;;
      esac
    done;

    if [ $skip == 0 ] ; then
      cd "$root_path$cur_param";
      cd $cur_iar_project;
  
      # IAR compilation
      project_file_name=`find ./ -name *.ewp | head -n 1`
      if [ -e "$project_file_name" ] ; then
        printf "<\033[0;36m"$cur_iar_project"\033[0;0m> ";
       	printf "Compilation - IAR\t"
       	"$iar_comp" "$project_file_name" -build Debug -log warnings > $temp_file
        check_ew $temp_file
      fi
    fi

  done;

done;

rm "$temp_file"
