clear

exec('dsp_op_gcd.sci');
exec('dsp_up_sample.sci');
exec('dsp_down_sample.sci');

pi=%pi;

function [Out] = flatop(In)
  Nb = length(In);
  for k=0:Nb-1
    w = 2*pi*k/(Nb-1);
    c = 1-1.93*cos(w)+1.29*cos(2*w)-0.388*cos(3*w)+0.032*cos(4*w);
    Out(k+1)=c*In(k+1);
  end
endfunction;

function [u,w] = resampling(Fsignal,Fsin,Fsout,Size,Amplitude)
    // ---------- Input Signal ---------
    t = 0:1/Fsin:(SIZE*(1/Fsin));
    t = t(1:length(t)-1);
    N=size(t,'*'); 
    u=Amplitude*sin(2*%pi*Fsignal*t);
    u = flatop(u)';

    // ---------- L and M calculation ---------
    M = Fsin/(dsp_op_gcd(Fsin,Fsout));
    L = Fsout/(dsp_op_gcd(Fsin,Fsout));     ;// interpolation factor
    // ----------------------------------------


    // ---------- Interpolation --------------
    // -- Step 1/ Up-Sampling
    vp = dsp_up_sample(u,L);
    //Low Pass FIR filter
    fc_filter     = (Fsout/3);
    fs_filter     = Fsin*L;
    FIR_COEF_SIZE = 6 * L;

    fir_coef      = wfir('lp', FIR_COEF_SIZE, [fc_filter/fs_filter, 0], 're', [0 0]);
    win           = window('hn', FIR_COEF_SIZE);
    fir_coef      = fir_coef .* win;
    [v]           = convol(fir_coef, vp);


    // -- Step 2/ Down-Sampling
    w = dsp_down_sample(v,M);
endfunction;

Fsin      = 44100;
Fsout     = 48510;
SIZE      = 1024;
Amplitude = 1;

Fstep     = 1;
Fstart   = 1000;
Fend     = 22000;
Res      = Fsin/SIZE;
Nbpoints = length(Fstart:Fstep:Fend);

index = 1;

for i=Fstart:Fstep:Fend
  
  [u,w] = resampling(i,Fsin,Fsout,SIZE,Amplitude);
  
  SIZE_W   = length(w);
  fft_w    = fft(w);
  fft_w    = 2*fft_w(1:length(fft_w)/2);
  f_w      = Fsout*(0:(SIZE_W/2))/SIZE_W; // The fft response is symetric we retain only the first N/2 points
  f_w      = f_w(1:length(f_w));          // We divide by 10 length of f, to rescale the frequency observation window
  //plot(20*log10(abs(fft_w)));

  SIZE_U   = length(u);
  fft_u    = fft(u);
  fft_u    = 2*fft_u(1:length(fft_u)/2);
  f_u      = Fsin*(0:(SIZE_U/2))/SIZE_U; // The fft response is symetric we retain only the first N/2 points
  f_u      = f_u(1:length(f_u));         // We divide by 10 length of f, to rescale the frequency observation window

  freq_u = i;
  j=1;
  while ((f_w(j) < freq_u)&(j<length(f_w)))
    j=j+1;
  end;

  index = -((Fend-i)/(Fstep))+Nbpoints;
  
  fft_finalw(index) = fft_w(j);
  fft_finalu(index) = Amplitude;        // !! Amplitude == fft_u(j) is similar !! 
  scale_uw(index) = fft_finalw(index)./fft_finalu(index);

end

f_scale_uw      = Fstart:Fstep:Fend;
n_scale_uw      = size(f_scale_uw,'*');
plot2d(f_scale_uw,20*log10(abs(scale_uw(1:n_scale_uw))));
title('Frequency Response');



