clear

exec('dsp_op_gcd.sci');
exec('dsp_up_sample.sci');
exec('dsp_down_sample.sci');

pi=%pi;

Fsignal   = 1000;
Amplitude = 1;
Fsin      = 22050;
Fsout     = 48510;
SIZE      = 200;

  
// ---------- Input Signal ---------
t = 0:1/Fsin:(SIZE*(1/Fsin));
t = t(1:length(t)-1);
N=size(t,'*'); 
u=Amplitude*sin(2*%pi*Fsignal*t);


// ---------- L and M calculation ---------
M = Fsin/(dsp_op_gcd(Fsin,Fsout));
L = Fsout/(dsp_op_gcd(Fsin,Fsout));     ;// interpolation factor
// ----------------------------------------


// ---------- Interpolation --------------
// -- Step 1/ Up-Sampling
vp = dsp_up_sample(u,L);

//Low Pass FIR filter
fc_filter     = (Fsout/3);
fs_filter     = Fsin*L;
FIR_COEF_SIZE = 6*L;

fir_coef      = wfir('lp', FIR_COEF_SIZE, [fc_filter/fs_filter, 0], 're', [0 0]);
win           = window('hn', FIR_COEF_SIZE);
fir_coef      = fir_coef .* win;

//fir_coef      = [0 0.050933 0.148101 0.186981 0.128204 0.035858 0.000457 0.059417 0.155426 0.185333 0.119659 0.029266 0.001861 0.068267 0.162139 0.182830 0.110931 0.023284 0.004180 0.077362 0.168121 0.179473 0.102020 0.017913 0.007354 0.086578 0.173431 0.175323 0.093109 0.013214 0.011444 0.095916 0.177947 0.17044 0.084197 0.009185  0.016265 0.105194 0.181610 0.164825 0.075469 0.005889 0.021942 0.114410 0.184478 0.158538 0.066864 0.003265 0.028289 0.123321 0.186431 0.151641 0.058502 0.001434 0.035308 0.131988 0.187530 0.144256 0.050567 0.000335 0.042877 0.140289 0.187713 0.136383 0.042938 0];
//FIR_COEF_SIZE = length(fir_coef);

[v]           = convol(fir_coef, vp);
v = v(FIR_COEF_SIZE:length(v));

// -- Step 2/ Down-Sampling
w = dsp_down_sample(v,M);


printf("--------------------------------------------\n");
printf("-------------Input Signal -------------------\n");
printf("--------------------------------------------\n");
printf("--------------------------------------------\n");
for i=1:SIZE,
  printf("DSP16_Q(%.11f),\n", u(1, i));
end

printf("--------------------------------------------\n");
printf("-------------Output Signal -------------------\n");
printf("--------------------------------------------\n");
printf("--------------------------------------------\n");
for i=1:length(w),
  printf("%i    %.11f \n",i,w(i));
end

// ----------- Display -----------------
subplot(4,1,1)
plot(u)
title('Original Signal at 1kHz');

subplot(4,1,2)
plot(w(1:SIZE))
title('Re-sampled Signal at 1kHz');

subplot(4,1,3)
SIZE_U   = length(u);
fft_u    = fft(u);
f_u      = Fsin*(0:(SIZE_U/2))/SIZE_U; //the fft response is symetric we retain only the first N/2 points
f_u      = f_u(1:length(f_u));      // We divide by 10 length of f, to rescale the frequency observation window
n_u      = size(f_u,'*');
plot2d(f_u,abs(fft_u(1:n_u)));
title('FFT of Original Signal at 1kHz');

subplot(4,1,4)
SIZE_W   = length(w);
fft_w    = fft(w);
f_w      = Fsout*(0:(SIZE_W/2))/SIZE_W;  //the fft response is symetric we retain only the first N/2 points
f_w      = f_w(1:length(f_w));        // We divide by 10 length of f, to rescale the frequency observation window
n_w      = size(f_w,'*');
plot2d(f_w,abs(fft_w(1:n_w)));
title('FFT of Re-sampled Signal at 1kHz');
