function y = dsp_up_sample(x,l)
// dsp_up_sample -- up-sampling operator
//  Usage
//    u = UpSample(x) 
//  Inputs
//    x   1-d signal, of length n
//    l   factor of up-sampling
//  Outputs
//    u   1-d signal, of length l*n with zeros
//        interpolating alternate samples
//        u(2*i-1) = d(i), i=1,...,n
//
 n = length(x)*l;
 y = zeros(1,n);
 y(1:l:(n-1) )=x;
endfunction

