clear

% ---------- Input Signal ---------
Fsin  = 48000;
Fsout = 48510;

Fstart    = 20;
Fend      = Fsin/2;
Elapsed   = 0.1;
dt        = 1/Fsin;
t         = 0:dt:Elapsed-dt;
Nmax      = length(t);
df=(Fend-Fstart)/(2*Nmax);
f=Fstart:df:Fend-df;

  
for(i=1:Nmax)
   u(i)=(0.1)*sin(2*pi*f(i)*t(i));
end;

% ---------- Output Signal ---------
w = resampling(u,Fsout,Fsin);


% ---------- FFT Compute ---------
duree  = dt*length(u);
df     = 1/duree;
freq_u = 0:df:(length(u)-1)*df;
SIZE_U = length(u);
fft_u  = fft(u)/SIZE_U;

freq_w   = 0:df:(length(w)-1)*df;
SIZE_W   = length(w);
fft_w    = fft(w)/SIZE_W;

% ---------- Display ---------
figure(1);
plot(freq_u(1:floor(length(freq_u)/2)),(abs(fft_u(1:floor(length(freq_u)/2)))),'b');hold on;
plot(freq_w(1:floor(length(freq_w)/2)),(abs(fft_w(1:floor(length(freq_w)/2)))),'r');
title('Frequency response of Signal and Re-sampled Signal');

figure(2);
if (length(fft_u) < length(fft_w))
    fft_u = [fft_u zeros(1,length(fft_w)-length(fft_u))];    
    rep_freq = fft_w./fft_u;
    plot(freq_w(1:floor(length(freq_w)/2)),20*log10(abs(rep_freq(1:floor(length(freq_w)/2)))));
else
    fft_w = [fft_w.' zeros(1,length(fft_u)-length(fft_w))];
    rep_fre = fft_w.'./fft_u;
    plot(freq(1:floor(length(freq_u)/2)),(abs(rep_freq(1:floor(length(freq_u)/2)))));    
end
title('Transfer frequency response of resampling stage');

