clear;


% ---------- Input Signal ---------
Fsignal   = 10000;
Fsin      = 44100;
Amplitude = 1;
SIZE      = 200; %2048*10;
t = 0:1/Fsin:(SIZE*(1/Fsin))-(1/Fsin);
t = t(1:length(t)-1);
u = Amplitude*sin(2*pi*Fsignal*t);
% u = flatop(u);

Fsout     = 48510;
% [u,Fsin,NBITS]=WAVREAD('wobul-0-20k-0db_mono.wav');

%w_the = resample(u,Fsout,Fsin);
w = resampling(u,Fsout,Fsin);


% ----------- Display -----------------
subplot(2,2,1)
plot(u)
title('Original Signal');

subplot(2,2,2)
plot(w)
title('Re-sampled Signal');

subplot(2,2,3)

SIZE_U   = length(u);
fft_u    = fft(u)/SIZE_U;

SIZE_W   = length(w);
fft_w    = fft(w)/SIZE_W;

freq_s = 0:Fsout/SIZE_W:Fsout-Fsout/SIZE_W;
freq   = 0:Fsin/SIZE_U:Fsin-Fsin/SIZE_U;

plot(freq(1:floor(length(freq)/2)),(abs(fft_u(1:floor(length(freq)/2)))),'b');hold on;
plot(freq_s(1:floor(length(freq_s)/2)),(abs(fft_w(1:floor(length(freq_s)/2)))),'r');
title('Frequency response of Signal and Re-sampled Signal');

subplot(2,2,4)

if (length(fft_u) < length(fft_w))
    fft_u = [fft_u.' zeros(1,length(fft_w)-length(fft_u))];    
    rep_freq = fft_w./fft_u;
    semilogx(freq_s(1:floor(length(freq_s)/2.4)),20*log10(abs(rep_freq(1:floor(length(freq_s)/2.4)))));
else
    fft_w = [fft_w.' zeros(1,length(fft_u)-length(fft_w))];
    rep_fre = fft_w.'./fft_u;
    plot(freq(1:floor(length(freq)/2)),(abs(rep_freq(1:floor(length(freq)/2)))));    
end
title('Transfer frequency response of resampling stage');
