clear;

//
// Twiddle factors for a 2048-point FFT
//
twiddle_factors = [ 1.000000+0.000000*%i;   1.000000+0.000000*%i;
        0.999995+-0.003068*%i;  0.999958+-0.009204*%i;
        0.999981+-0.006136*%i;  0.999831+-0.018407*%i;
        0.999958+-0.009204*%i;  0.999619+-0.027608*%i;
        0.999925+-0.012272*%i;  0.999322+-0.036807*%i;
        0.999882+-0.015339*%i;  0.998941+-0.046003*%i;
        0.999831+-0.018407*%i;  0.998476+-0.055195*%i;
        0.999769+-0.021474*%i;  0.997925+-0.064383*%i;
        0.999699+-0.024541*%i;  0.997290+-0.073565*%i;
        0.999619+-0.027608*%i;  0.996571+-0.082740*%i;
        0.999529+-0.030675*%i;  0.995767+-0.091909*%i;
        0.999431+-0.033741*%i;  0.994879+-0.101070*%i;
        0.999322+-0.036807*%i;  0.993907+-0.110222*%i;
        0.999205+-0.039873*%i;  0.992850+-0.119365*%i;
        0.999078+-0.042938*%i;  0.991710+-0.128498*%i;
        0.998941+-0.046003*%i;  0.990485+-0.137620*%i;
        0.998795+-0.049068*%i;  0.989177+-0.146730*%i;
        0.998640+-0.052132*%i;  0.987784+-0.155828*%i;
        0.998476+-0.055195*%i;  0.986308+-0.164913*%i;
        0.998302+-0.058258*%i;  0.984749+-0.173984*%i;
        0.998118+-0.061321*%i;  0.983105+-0.183040*%i;
        0.997925+-0.064383*%i;  0.981379+-0.192080*%i;
        0.997723+-0.067444*%i;  0.979570+-0.201105*%i;
        0.997511+-0.070505*%i;  0.977677+-0.210112*%i;
        0.997290+-0.073565*%i;  0.975702+-0.219101*%i;
        0.997060+-0.076624*%i;  0.973644+-0.228072*%i;
        0.996820+-0.079682*%i;  0.971504+-0.237024*%i;
        0.996571+-0.082740*%i;  0.969281+-0.245955*%i;
        0.996313+-0.085797*%i;  0.966976+-0.254866*%i;
        0.996045+-0.088854*%i;  0.964590+-0.263755*%i;
        0.995767+-0.091909*%i;  0.962121+-0.272621*%i;
        0.995481+-0.094963*%i;  0.959572+-0.281465*%i;
        0.995185+-0.098017*%i;  0.956940+-0.290285*%i;
        0.994879+-0.101070*%i;  0.954228+-0.299080*%i;
        0.994565+-0.104122*%i;  0.951435+-0.307850*%i;
        0.994240+-0.107172*%i;  0.948561+-0.316593*%i;
        0.993907+-0.110222*%i;  0.945607+-0.325310*%i;
        0.993564+-0.113271*%i;  0.942573+-0.334000*%i;
        0.993212+-0.116319*%i;  0.939459+-0.342661*%i;
        0.992850+-0.119365*%i;  0.936266+-0.351293*%i;
        0.992480+-0.122411*%i;  0.932993+-0.359895*%i;
        0.992099+-0.125455*%i;  0.929641+-0.368467*%i;
        0.991710+-0.128498*%i;  0.926210+-0.377007*%i;
        0.991311+-0.131540*%i;  0.922701+-0.385516*%i;
        0.990903+-0.134581*%i;  0.919114+-0.393992*%i;
        0.990485+-0.137620*%i;  0.915449+-0.402435*%i;
        0.990058+-0.140658*%i;  0.911706+-0.410843*%i;
        0.989622+-0.143695*%i;  0.907886+-0.419217*%i;
        0.989177+-0.146730*%i;  0.903989+-0.427555*%i;
        0.988722+-0.149765*%i;  0.900016+-0.435857*%i;
        0.988258+-0.152797*%i;  0.895966+-0.444122*%i;
        0.987784+-0.155828*%i;  0.891841+-0.452350*%i;
        0.987301+-0.158858*%i;  0.887640+-0.460539*%i;
        0.986809+-0.161886*%i;  0.883363+-0.468689*%i;
        0.986308+-0.164913*%i;  0.879012+-0.476799*%i;
        0.985798+-0.167938*%i;  0.874587+-0.484869*%i;
        0.985278+-0.170962*%i;  0.870087+-0.492898*%i;
        0.984749+-0.173984*%i;  0.865514+-0.500885*%i;
        0.984210+-0.177004*%i;  0.860867+-0.508830*%i;
        0.983662+-0.180023*%i;  0.856147+-0.516732*%i;
        0.983105+-0.183040*%i;  0.851355+-0.524590*%i;
        0.982539+-0.186055*%i;  0.846491+-0.532403*%i;
        0.981964+-0.189069*%i;  0.841555+-0.540171*%i;
        0.981379+-0.192080*%i;  0.836548+-0.547894*%i;
        0.980785+-0.195090*%i;  0.831470+-0.555570*%i;
        0.980182+-0.198098*%i;  0.826321+-0.563199*%i;
        0.979570+-0.201105*%i;  0.821103+-0.570781*%i;
        0.978948+-0.204109*%i;  0.815814+-0.578314*%i;
        0.978317+-0.207111*%i;  0.810457+-0.585798*%i;
        0.977677+-0.210112*%i;  0.805031+-0.593232*%i;
        0.977028+-0.213110*%i;  0.799537+-0.600616*%i;
        0.976370+-0.216107*%i;  0.793975+-0.607950*%i;
        0.975702+-0.219101*%i;  0.788346+-0.615232*%i;
        0.975025+-0.222094*%i;  0.782651+-0.622461*%i;
        0.974339+-0.225084*%i;  0.776888+-0.629638*%i;
        0.973644+-0.228072*%i;  0.771061+-0.636762*%i;
        0.972940+-0.231058*%i;  0.765167+-0.643832*%i;
        0.972226+-0.234042*%i;  0.759209+-0.650847*%i;
        0.971504+-0.237024*%i;  0.753187+-0.657807*%i;
        0.970772+-0.240003*%i;  0.747101+-0.664711*%i;
        0.970031+-0.242980*%i;  0.740951+-0.671559*%i;
        0.969281+-0.245955*%i;  0.734739+-0.678350*%i;
        0.968522+-0.248928*%i;  0.728464+-0.685084*%i;
        0.967754+-0.251898*%i;  0.722128+-0.691759*%i;
        0.966976+-0.254866*%i;  0.715731+-0.698376*%i;
        0.966190+-0.257831*%i;  0.709273+-0.704934*%i;
        0.965394+-0.260794*%i;  0.702755+-0.711432*%i;
        0.964590+-0.263755*%i;  0.696177+-0.717870*%i;
        0.963776+-0.266713*%i;  0.689541+-0.724247*%i;
        0.962953+-0.269668*%i;  0.682846+-0.730563*%i;
        0.962121+-0.272621*%i;  0.676093+-0.736817*%i;
        0.961280+-0.275572*%i;  0.669283+-0.743008*%i;
        0.960431+-0.278520*%i;  0.662416+-0.749136*%i;
        0.959572+-0.281465*%i;  0.655493+-0.755201*%i;
        0.958703+-0.284408*%i;  0.648514+-0.761202*%i;
        0.957826+-0.287347*%i;  0.641481+-0.767139*%i;
        0.956940+-0.290285*%i;  0.634393+-0.773010*%i;
        0.956045+-0.293219*%i;  0.627252+-0.778817*%i;
        0.955141+-0.296151*%i;  0.620057+-0.784557*%i;
        0.954228+-0.299080*%i;  0.612810+-0.790230*%i;
        0.953306+-0.302006*%i;  0.605511+-0.795837*%i;
        0.952375+-0.304929*%i;  0.598161+-0.801376*%i;
        0.951435+-0.307850*%i;  0.590760+-0.806848*%i;
        0.950486+-0.310767*%i;  0.583309+-0.812251*%i;
        0.949528+-0.313682*%i;  0.575808+-0.817585*%i;
        0.948561+-0.316593*%i;  0.568259+-0.822850*%i;
        0.947586+-0.319502*%i;  0.560662+-0.828045*%i;
        0.946601+-0.322408*%i;  0.553017+-0.833170*%i;
        0.945607+-0.325310*%i;  0.545325+-0.838225*%i;
        0.944605+-0.328210*%i;  0.537587+-0.843208*%i;
        0.943593+-0.331106*%i;  0.529804+-0.848120*%i;
        0.942573+-0.334000*%i;  0.521975+-0.852961*%i;
        0.941544+-0.336890*%i;  0.514103+-0.857729*%i;
        0.940506+-0.339777*%i;  0.506187+-0.862424*%i;
        0.939459+-0.342661*%i;  0.498228+-0.867046*%i;
        0.938404+-0.345541*%i;  0.490226+-0.871595*%i;
        0.937339+-0.348419*%i;  0.482184+-0.876070*%i;
        0.936266+-0.351293*%i;  0.474100+-0.880471*%i;
        0.935184+-0.354164*%i;  0.465976+-0.884797*%i;
        0.934093+-0.357031*%i;  0.457813+-0.889048*%i;
        0.932993+-0.359895*%i;  0.449611+-0.893224*%i;
        0.931884+-0.362756*%i;  0.441371+-0.897325*%i;
        0.930767+-0.365613*%i;  0.433094+-0.901349*%i;
        0.929641+-0.368467*%i;  0.424780+-0.905297*%i;
        0.928506+-0.371317*%i;  0.416430+-0.909168*%i;
        0.927363+-0.374164*%i;  0.408044+-0.912962*%i;
        0.926210+-0.377007*%i;  0.399624+-0.916679*%i;
        0.925049+-0.379847*%i;  0.391170+-0.920318*%i;
        0.923880+-0.382683*%i;  0.382683+-0.923880*%i;
        0.922701+-0.385516*%i;  0.374164+-0.927363*%i;
        0.921514+-0.388345*%i;  0.365613+-0.930767*%i;
        0.920318+-0.391170*%i;  0.357031+-0.934093*%i;
        0.919114+-0.393992*%i;  0.348419+-0.937339*%i;
        0.917901+-0.396810*%i;  0.339777+-0.940506*%i;
        0.916679+-0.399624*%i;  0.331106+-0.943593*%i;
        0.915449+-0.402435*%i;  0.322408+-0.946601*%i;
        0.914210+-0.405241*%i;  0.313682+-0.949528*%i;
        0.912962+-0.408044*%i;  0.304929+-0.952375*%i;
        0.911706+-0.410843*%i;  0.296151+-0.955141*%i;
        0.910441+-0.413638*%i;  0.287347+-0.957826*%i;
        0.909168+-0.416430*%i;  0.278520+-0.960431*%i;
        0.907886+-0.419217*%i;  0.269668+-0.962953*%i;
        0.906596+-0.422000*%i;  0.260794+-0.965394*%i;
        0.905297+-0.424780*%i;  0.251898+-0.967754*%i;
        0.903989+-0.427555*%i;  0.242980+-0.970031*%i;
        0.902673+-0.430326*%i;  0.234042+-0.972226*%i;
        0.901349+-0.433094*%i;  0.225084+-0.974339*%i;
        0.900016+-0.435857*%i;  0.216107+-0.976370*%i;
        0.898674+-0.438616*%i;  0.207111+-0.978317*%i;
        0.897325+-0.441371*%i;  0.198098+-0.980182*%i;
        0.895966+-0.444122*%i;  0.189069+-0.981964*%i;
        0.894599+-0.446869*%i;  0.180023+-0.983662*%i;
        0.893224+-0.449611*%i;  0.170962+-0.985278*%i;
        0.891841+-0.452350*%i;  0.161886+-0.986809*%i;
        0.890449+-0.455084*%i;  0.152797+-0.988258*%i;
        0.889048+-0.457813*%i;  0.143695+-0.989622*%i;
        0.887640+-0.460539*%i;  0.134581+-0.990903*%i;
        0.886223+-0.463260*%i;  0.125455+-0.992099*%i;
        0.884797+-0.465976*%i;  0.116319+-0.993212*%i;
        0.883363+-0.468689*%i;  0.107172+-0.994240*%i;
        0.881921+-0.471397*%i;  0.098017+-0.995185*%i;
        0.880471+-0.474100*%i;  0.088854+-0.996045*%i;
        0.879012+-0.476799*%i;  0.079682+-0.996820*%i;
        0.877545+-0.479494*%i;  0.070505+-0.997511*%i;
        0.876070+-0.482184*%i;  0.061321+-0.998118*%i;
        0.874587+-0.484869*%i;  0.052132+-0.998640*%i;
        0.873095+-0.487550*%i;  0.042938+-0.999078*%i;
        0.871595+-0.490226*%i;  0.033741+-0.999431*%i;
        0.870087+-0.492898*%i;  0.024541+-0.999699*%i;
        0.868571+-0.495565*%i;  0.015339+-0.999882*%i;
        0.867046+-0.498228*%i;  0.006136+-0.999981*%i;
        0.865514+-0.500885*%i;  -0.003068+-0.999995*%i;
        0.863973+-0.503538*%i;  -0.012272+-0.999925*%i;
        0.862424+-0.506187*%i;  -0.021474+-0.999769*%i;
        0.860867+-0.508830*%i;  -0.030675+-0.999529*%i;
        0.859302+-0.511469*%i;  -0.039873+-0.999205*%i;
        0.857729+-0.514103*%i;  -0.049068+-0.998795*%i;
        0.856147+-0.516732*%i;  -0.058258+-0.998302*%i;
        0.854558+-0.519356*%i;  -0.067444+-0.997723*%i;
        0.852961+-0.521975*%i;  -0.076624+-0.997060*%i;
        0.851355+-0.524590*%i;  -0.085797+-0.996313*%i;
        0.849742+-0.527199*%i;  -0.094963+-0.995481*%i;
        0.848120+-0.529804*%i;  -0.104122+-0.994565*%i;
        0.846491+-0.532403*%i;  -0.113271+-0.993564*%i;
        0.844854+-0.534998*%i;  -0.122411+-0.992480*%i;
        0.843208+-0.537587*%i;  -0.131540+-0.991311*%i;
        0.841555+-0.540171*%i;  -0.140658+-0.990058*%i;
        0.839894+-0.542751*%i;  -0.149765+-0.988722*%i;
        0.838225+-0.545325*%i;  -0.158858+-0.987301*%i;
        0.836548+-0.547894*%i;  -0.167938+-0.985798*%i;
        0.834863+-0.550458*%i;  -0.177004+-0.984210*%i;
        0.833170+-0.553017*%i;  -0.186055+-0.982539*%i;
        0.831470+-0.555570*%i;  -0.195090+-0.980785*%i;
        0.829761+-0.558119*%i;  -0.204109+-0.978948*%i;
        0.828045+-0.560662*%i;  -0.213110+-0.977028*%i;
        0.826321+-0.563199*%i;  -0.222094+-0.975025*%i;
        0.824589+-0.565732*%i;  -0.231058+-0.972940*%i;
        0.822850+-0.568259*%i;  -0.240003+-0.970772*%i;
        0.821103+-0.570781*%i;  -0.248928+-0.968522*%i;
        0.819348+-0.573297*%i;  -0.257831+-0.966190*%i;
        0.817585+-0.575808*%i;  -0.266713+-0.963776*%i;
        0.815814+-0.578314*%i;  -0.275572+-0.961280*%i;
        0.814036+-0.580814*%i;  -0.284408+-0.958703*%i;
        0.812251+-0.583309*%i;  -0.293219+-0.956045*%i;
        0.810457+-0.585798*%i;  -0.302006+-0.953306*%i;
        0.808656+-0.588282*%i;  -0.310767+-0.950486*%i;
        0.806848+-0.590760*%i;  -0.319502+-0.947586*%i;
        0.805031+-0.593232*%i;  -0.328210+-0.944605*%i;
        0.803208+-0.595699*%i;  -0.336890+-0.941544*%i;
        0.801376+-0.598161*%i;  -0.345541+-0.938404*%i;
        0.799537+-0.600616*%i;  -0.354164+-0.935184*%i;
        0.797691+-0.603067*%i;  -0.362756+-0.931884*%i;
        0.795837+-0.605511*%i;  -0.371317+-0.928506*%i;
        0.793975+-0.607950*%i;  -0.379847+-0.925049*%i;
        0.792107+-0.610383*%i;  -0.388345+-0.921514*%i;
        0.790230+-0.612810*%i;  -0.396810+-0.917901*%i;
        0.788346+-0.615232*%i;  -0.405241+-0.914210*%i;
        0.786455+-0.617647*%i;  -0.413638+-0.910441*%i;
        0.784557+-0.620057*%i;  -0.422000+-0.906596*%i;
        0.782651+-0.622461*%i;  -0.430326+-0.902673*%i;
        0.780737+-0.624859*%i;  -0.438616+-0.898674*%i;
        0.778817+-0.627252*%i;  -0.446869+-0.894599*%i;
        0.776888+-0.629638*%i;  -0.455084+-0.890449*%i;
        0.774953+-0.632019*%i;  -0.463260+-0.886223*%i;
        0.773010+-0.634393*%i;  -0.471397+-0.881921*%i;
        0.771061+-0.636762*%i;  -0.479494+-0.877545*%i;
        0.769103+-0.639124*%i;  -0.487550+-0.873095*%i;
        0.767139+-0.641481*%i;  -0.495565+-0.868571*%i;
        0.765167+-0.643832*%i;  -0.503538+-0.863973*%i;
        0.763188+-0.646176*%i;  -0.511469+-0.859302*%i;
        0.761202+-0.648514*%i;  -0.519356+-0.854558*%i;
        0.759209+-0.650847*%i;  -0.527199+-0.849742*%i;
        0.757209+-0.653173*%i;  -0.534998+-0.844854*%i;
        0.755201+-0.655493*%i;  -0.542751+-0.839894*%i;
        0.753187+-0.657807*%i;  -0.550458+-0.834863*%i;
        0.751165+-0.660114*%i;  -0.558119+-0.829761*%i;
        0.749136+-0.662416*%i;  -0.565732+-0.824589*%i;
        0.747101+-0.664711*%i;  -0.573297+-0.819348*%i;
        0.745058+-0.667000*%i;  -0.580814+-0.814036*%i;
        0.743008+-0.669283*%i;  -0.588282+-0.808656*%i;
        0.740951+-0.671559*%i;  -0.595699+-0.803208*%i;
        0.738887+-0.673829*%i;  -0.603067+-0.797691*%i;
        0.736817+-0.676093*%i;  -0.610383+-0.792107*%i;
        0.734739+-0.678350*%i;  -0.617647+-0.786455*%i;
        0.732654+-0.680601*%i;  -0.624859+-0.780737*%i;
        0.730563+-0.682846*%i;  -0.632019+-0.774953*%i;
        0.728464+-0.685084*%i;  -0.639124+-0.769103*%i;
        0.726359+-0.687315*%i;  -0.646176+-0.763188*%i;
        0.724247+-0.689541*%i;  -0.653173+-0.757209*%i;
        0.722128+-0.691759*%i;  -0.660114+-0.751165*%i;
        0.720003+-0.693971*%i;  -0.667000+-0.745058*%i;
        0.717870+-0.696177*%i;  -0.673829+-0.738887*%i;
        0.715731+-0.698376*%i;  -0.680601+-0.732654*%i;
        0.713585+-0.700569*%i;  -0.687315+-0.726359*%i;
        0.711432+-0.702755*%i;  -0.693971+-0.720003*%i;
        0.709273+-0.704934*%i;  -0.700569+-0.713585*%i;
        0.707107+-0.707107*%i;  -0.707107+-0.707107*%i;
        0.704934+-0.709273*%i;  -0.713585+-0.700569*%i;
        0.702755+-0.711432*%i;  -0.720003+-0.693971*%i;
        0.700569+-0.713585*%i;  -0.726359+-0.687315*%i;
        0.698376+-0.715731*%i;  -0.732654+-0.680601*%i;
        0.696177+-0.717870*%i;  -0.738887+-0.673829*%i;
        0.693971+-0.720003*%i;  -0.745058+-0.667000*%i;
        0.691759+-0.722128*%i;  -0.751165+-0.660114*%i;
        0.689541+-0.724247*%i;  -0.757209+-0.653173*%i;
        0.687315+-0.726359*%i;  -0.763188+-0.646176*%i;
        0.685084+-0.728464*%i;  -0.769103+-0.639124*%i;
        0.682846+-0.730563*%i;  -0.774953+-0.632019*%i;
        0.680601+-0.732654*%i;  -0.780737+-0.624859*%i;
        0.678350+-0.734739*%i;  -0.786455+-0.617647*%i;
        0.676093+-0.736817*%i;  -0.792107+-0.610383*%i;
        0.673829+-0.738887*%i;  -0.797691+-0.603067*%i;
        0.671559+-0.740951*%i;  -0.803208+-0.595699*%i;
        0.669283+-0.743008*%i;  -0.808656+-0.588282*%i;
        0.667000+-0.745058*%i;  -0.814036+-0.580814*%i;
        0.664711+-0.747101*%i;  -0.819348+-0.573297*%i;
        0.662416+-0.749136*%i;  -0.824589+-0.565732*%i;
        0.660114+-0.751165*%i;  -0.829761+-0.558119*%i;
        0.657807+-0.753187*%i;  -0.834863+-0.550458*%i;
        0.655493+-0.755201*%i;  -0.839894+-0.542751*%i;
        0.653173+-0.757209*%i;  -0.844854+-0.534998*%i;
        0.650847+-0.759209*%i;  -0.849742+-0.527199*%i;
        0.648514+-0.761202*%i;  -0.854558+-0.519356*%i;
        0.646176+-0.763188*%i;  -0.859302+-0.511469*%i;
        0.643832+-0.765167*%i;  -0.863973+-0.503538*%i;
        0.641481+-0.767139*%i;  -0.868571+-0.495565*%i;
        0.639124+-0.769103*%i;  -0.873095+-0.487550*%i;
        0.636762+-0.771061*%i;  -0.877545+-0.479494*%i;
        0.634393+-0.773010*%i;  -0.881921+-0.471397*%i;
        0.632019+-0.774953*%i;  -0.886223+-0.463260*%i;
        0.629638+-0.776888*%i;  -0.890449+-0.455084*%i;
        0.627252+-0.778817*%i;  -0.894599+-0.446869*%i;
        0.624859+-0.780737*%i;  -0.898674+-0.438616*%i;
        0.622461+-0.782651*%i;  -0.902673+-0.430326*%i;
        0.620057+-0.784557*%i;  -0.906596+-0.422000*%i;
        0.617647+-0.786455*%i;  -0.910441+-0.413638*%i;
        0.615232+-0.788346*%i;  -0.914210+-0.405241*%i;
        0.612810+-0.790230*%i;  -0.917901+-0.396810*%i;
        0.610383+-0.792107*%i;  -0.921514+-0.388345*%i;
        0.607950+-0.793975*%i;  -0.925049+-0.379847*%i;
        0.605511+-0.795837*%i;  -0.928506+-0.371317*%i;
        0.603067+-0.797691*%i;  -0.931884+-0.362756*%i;
        0.600616+-0.799537*%i;  -0.935184+-0.354164*%i;
        0.598161+-0.801376*%i;  -0.938404+-0.345541*%i;
        0.595699+-0.803208*%i;  -0.941544+-0.336890*%i;
        0.593232+-0.805031*%i;  -0.944605+-0.328210*%i;
        0.590760+-0.806848*%i;  -0.947586+-0.319502*%i;
        0.588282+-0.808656*%i;  -0.950486+-0.310767*%i;
        0.585798+-0.810457*%i;  -0.953306+-0.302006*%i;
        0.583309+-0.812251*%i;  -0.956045+-0.293219*%i;
        0.580814+-0.814036*%i;  -0.958703+-0.284408*%i;
        0.578314+-0.815814*%i;  -0.961280+-0.275572*%i;
        0.575808+-0.817585*%i;  -0.963776+-0.266713*%i;
        0.573297+-0.819348*%i;  -0.966190+-0.257831*%i;
        0.570781+-0.821103*%i;  -0.968522+-0.248928*%i;
        0.568259+-0.822850*%i;  -0.970772+-0.240003*%i;
        0.565732+-0.824589*%i;  -0.972940+-0.231058*%i;
        0.563199+-0.826321*%i;  -0.975025+-0.222094*%i;
        0.560662+-0.828045*%i;  -0.977028+-0.213110*%i;
        0.558119+-0.829761*%i;  -0.978948+-0.204109*%i;
        0.555570+-0.831470*%i;  -0.980785+-0.195090*%i;
        0.553017+-0.833170*%i;  -0.982539+-0.186055*%i;
        0.550458+-0.834863*%i;  -0.984210+-0.177004*%i;
        0.547894+-0.836548*%i;  -0.985798+-0.167938*%i;
        0.545325+-0.838225*%i;  -0.987301+-0.158858*%i;
        0.542751+-0.839894*%i;  -0.988722+-0.149765*%i;
        0.540171+-0.841555*%i;  -0.990058+-0.140658*%i;
        0.537587+-0.843208*%i;  -0.991311+-0.131540*%i;
        0.534998+-0.844854*%i;  -0.992480+-0.122411*%i;
        0.532403+-0.846491*%i;  -0.993564+-0.113271*%i;
        0.529804+-0.848120*%i;  -0.994565+-0.104122*%i;
        0.527199+-0.849742*%i;  -0.995481+-0.094963*%i;
        0.524590+-0.851355*%i;  -0.996313+-0.085797*%i;
        0.521975+-0.852961*%i;  -0.997060+-0.076624*%i;
        0.519356+-0.854558*%i;  -0.997723+-0.067444*%i;
        0.516732+-0.856147*%i;  -0.998302+-0.058258*%i;
        0.514103+-0.857729*%i;  -0.998795+-0.049068*%i;
        0.511469+-0.859302*%i;  -0.999205+-0.039873*%i;
        0.508830+-0.860867*%i;  -0.999529+-0.030675*%i;
        0.506187+-0.862424*%i;  -0.999769+-0.021474*%i;
        0.503538+-0.863973*%i;  -0.999925+-0.012272*%i;
        0.500885+-0.865514*%i;  -0.999995+-0.003068*%i;
        0.498228+-0.867046*%i;  -0.999981+0.006136*%i;
        0.495565+-0.868571*%i;  -0.999882+0.015339*%i;
        0.492898+-0.870087*%i;  -0.999699+0.024541*%i;
        0.490226+-0.871595*%i;  -0.999431+0.033741*%i;
        0.487550+-0.873095*%i;  -0.999078+0.042938*%i;
        0.484869+-0.874587*%i;  -0.998640+0.052132*%i;
        0.482184+-0.876070*%i;  -0.998118+0.061321*%i;
        0.479494+-0.877545*%i;  -0.997511+0.070505*%i;
        0.476799+-0.879012*%i;  -0.996820+0.079682*%i;
        0.474100+-0.880471*%i;  -0.996045+0.088854*%i;
        0.471397+-0.881921*%i;  -0.995185+0.098017*%i;
        0.468689+-0.883363*%i;  -0.994240+0.107172*%i;
        0.465976+-0.884797*%i;  -0.993212+0.116319*%i;
        0.463260+-0.886223*%i;  -0.992099+0.125455*%i;
        0.460539+-0.887640*%i;  -0.990903+0.134581*%i;
        0.457813+-0.889048*%i;  -0.989622+0.143695*%i;
        0.455084+-0.890449*%i;  -0.988258+0.152797*%i;
        0.452350+-0.891841*%i;  -0.986809+0.161886*%i;
        0.449611+-0.893224*%i;  -0.985278+0.170962*%i;
        0.446869+-0.894599*%i;  -0.983662+0.180023*%i;
        0.444122+-0.895966*%i;  -0.981964+0.189069*%i;
        0.441371+-0.897325*%i;  -0.980182+0.198098*%i;
        0.438616+-0.898674*%i;  -0.978317+0.207111*%i;
        0.435857+-0.900016*%i;  -0.976370+0.216107*%i;
        0.433094+-0.901349*%i;  -0.974339+0.225084*%i;
        0.430326+-0.902673*%i;  -0.972226+0.234042*%i;
        0.427555+-0.903989*%i;  -0.970031+0.242980*%i;
        0.424780+-0.905297*%i;  -0.967754+0.251898*%i;
        0.422000+-0.906596*%i;  -0.965394+0.260794*%i;
        0.419217+-0.907886*%i;  -0.962953+0.269668*%i;
        0.416430+-0.909168*%i;  -0.960431+0.278520*%i;
        0.413638+-0.910441*%i;  -0.957826+0.287347*%i;
        0.410843+-0.911706*%i;  -0.955141+0.296151*%i;
        0.408044+-0.912962*%i;  -0.952375+0.304929*%i;
        0.405241+-0.914210*%i;  -0.949528+0.313682*%i;
        0.402435+-0.915449*%i;  -0.946601+0.322408*%i;
        0.399624+-0.916679*%i;  -0.943593+0.331106*%i;
        0.396810+-0.917901*%i;  -0.940506+0.339777*%i;
        0.393992+-0.919114*%i;  -0.937339+0.348419*%i;
        0.391170+-0.920318*%i;  -0.934093+0.357031*%i;
        0.388345+-0.921514*%i;  -0.930767+0.365613*%i;
        0.385516+-0.922701*%i;  -0.927363+0.374164*%i;
        0.382683+-0.923880*%i;  -0.923880+0.382683*%i;
        0.379847+-0.925049*%i;  -0.920318+0.391170*%i;
        0.377007+-0.926210*%i;  -0.916679+0.399624*%i;
        0.374164+-0.927363*%i;  -0.912962+0.408044*%i;
        0.371317+-0.928506*%i;  -0.909168+0.416430*%i;
        0.368467+-0.929641*%i;  -0.905297+0.424780*%i;
        0.365613+-0.930767*%i;  -0.901349+0.433094*%i;
        0.362756+-0.931884*%i;  -0.897325+0.441371*%i;
        0.359895+-0.932993*%i;  -0.893224+0.449611*%i;
        0.357031+-0.934093*%i;  -0.889048+0.457813*%i;
        0.354164+-0.935184*%i;  -0.884797+0.465976*%i;
        0.351293+-0.936266*%i;  -0.880471+0.474100*%i;
        0.348419+-0.937339*%i;  -0.876070+0.482184*%i;
        0.345541+-0.938404*%i;  -0.871595+0.490226*%i;
        0.342661+-0.939459*%i;  -0.867046+0.498228*%i;
        0.339777+-0.940506*%i;  -0.862424+0.506187*%i;
        0.336890+-0.941544*%i;  -0.857729+0.514103*%i;
        0.334000+-0.942573*%i;  -0.852961+0.521975*%i;
        0.331106+-0.943593*%i;  -0.848120+0.529804*%i;
        0.328210+-0.944605*%i;  -0.843208+0.537587*%i;
        0.325310+-0.945607*%i;  -0.838225+0.545325*%i;
        0.322408+-0.946601*%i;  -0.833170+0.553017*%i;
        0.319502+-0.947586*%i;  -0.828045+0.560662*%i;
        0.316593+-0.948561*%i;  -0.822850+0.568259*%i;
        0.313682+-0.949528*%i;  -0.817585+0.575808*%i;
        0.310767+-0.950486*%i;  -0.812251+0.583309*%i;
        0.307850+-0.951435*%i;  -0.806848+0.590760*%i;
        0.304929+-0.952375*%i;  -0.801376+0.598161*%i;
        0.302006+-0.953306*%i;  -0.795837+0.605511*%i;
        0.299080+-0.954228*%i;  -0.790230+0.612810*%i;
        0.296151+-0.955141*%i;  -0.784557+0.620057*%i;
        0.293219+-0.956045*%i;  -0.778817+0.627252*%i;
        0.290285+-0.956940*%i;  -0.773010+0.634393*%i;
        0.287347+-0.957826*%i;  -0.767139+0.641481*%i;
        0.284408+-0.958703*%i;  -0.761202+0.648514*%i;
        0.281465+-0.959572*%i;  -0.755201+0.655493*%i;
        0.278520+-0.960431*%i;  -0.749136+0.662416*%i;
        0.275572+-0.961280*%i;  -0.743008+0.669283*%i;
        0.272621+-0.962121*%i;  -0.736817+0.676093*%i;
        0.269668+-0.962953*%i;  -0.730563+0.682846*%i;
        0.266713+-0.963776*%i;  -0.724247+0.689541*%i;
        0.263755+-0.964590*%i;  -0.717870+0.696177*%i;
        0.260794+-0.965394*%i;  -0.711432+0.702755*%i;
        0.257831+-0.966190*%i;  -0.704934+0.709273*%i;
        0.254866+-0.966976*%i;  -0.698376+0.715731*%i;
        0.251898+-0.967754*%i;  -0.691759+0.722128*%i;
        0.248928+-0.968522*%i;  -0.685084+0.728464*%i;
        0.245955+-0.969281*%i;  -0.678350+0.734739*%i;
        0.242980+-0.970031*%i;  -0.671559+0.740951*%i;
        0.240003+-0.970772*%i;  -0.664711+0.747101*%i;
        0.237024+-0.971504*%i;  -0.657807+0.753187*%i;
        0.234042+-0.972226*%i;  -0.650847+0.759209*%i;
        0.231058+-0.972940*%i;  -0.643832+0.765167*%i;
        0.228072+-0.973644*%i;  -0.636762+0.771061*%i;
        0.225084+-0.974339*%i;  -0.629638+0.776888*%i;
        0.222094+-0.975025*%i;  -0.622461+0.782651*%i;
        0.219101+-0.975702*%i;  -0.615232+0.788346*%i;
        0.216107+-0.976370*%i;  -0.607950+0.793975*%i;
        0.213110+-0.977028*%i;  -0.600616+0.799537*%i;
        0.210112+-0.977677*%i;  -0.593232+0.805031*%i;
        0.207111+-0.978317*%i;  -0.585798+0.810457*%i;
        0.204109+-0.978948*%i;  -0.578314+0.815814*%i;
        0.201105+-0.979570*%i;  -0.570781+0.821103*%i;
        0.198098+-0.980182*%i;  -0.563199+0.826321*%i;
        0.195090+-0.980785*%i;  -0.555570+0.831470*%i;
        0.192080+-0.981379*%i;  -0.547894+0.836548*%i;
        0.189069+-0.981964*%i;  -0.540171+0.841555*%i;
        0.186055+-0.982539*%i;  -0.532403+0.846491*%i;
        0.183040+-0.983105*%i;  -0.524590+0.851355*%i;
        0.180023+-0.983662*%i;  -0.516732+0.856147*%i;
        0.177004+-0.984210*%i;  -0.508830+0.860867*%i;
        0.173984+-0.984749*%i;  -0.500885+0.865514*%i;
        0.170962+-0.985278*%i;  -0.492898+0.870087*%i;
        0.167938+-0.985798*%i;  -0.484869+0.874587*%i;
        0.164913+-0.986308*%i;  -0.476799+0.879012*%i;
        0.161886+-0.986809*%i;  -0.468689+0.883363*%i;
        0.158858+-0.987301*%i;  -0.460539+0.887640*%i;
        0.155828+-0.987784*%i;  -0.452350+0.891841*%i;
        0.152797+-0.988258*%i;  -0.444122+0.895966*%i;
        0.149765+-0.988722*%i;  -0.435857+0.900016*%i;
        0.146730+-0.989177*%i;  -0.427555+0.903989*%i;
        0.143695+-0.989622*%i;  -0.419217+0.907886*%i;
        0.140658+-0.990058*%i;  -0.410843+0.911706*%i;
        0.137620+-0.990485*%i;  -0.402435+0.915449*%i;
        0.134581+-0.990903*%i;  -0.393992+0.919114*%i;
        0.131540+-0.991311*%i;  -0.385516+0.922701*%i;
        0.128498+-0.991710*%i;  -0.377007+0.926210*%i;
        0.125455+-0.992099*%i;  -0.368467+0.929641*%i;
        0.122411+-0.992480*%i;  -0.359895+0.932993*%i;
        0.119365+-0.992850*%i;  -0.351293+0.936266*%i;
        0.116319+-0.993212*%i;  -0.342661+0.939459*%i;
        0.113271+-0.993564*%i;  -0.334000+0.942573*%i;
        0.110222+-0.993907*%i;  -0.325310+0.945607*%i;
        0.107172+-0.994240*%i;  -0.316593+0.948561*%i;
        0.104122+-0.994565*%i;  -0.307850+0.951435*%i;
        0.101070+-0.994879*%i;  -0.299080+0.954228*%i;
        0.098017+-0.995185*%i;  -0.290285+0.956940*%i;
        0.094963+-0.995481*%i;  -0.281465+0.959572*%i;
        0.091909+-0.995767*%i;  -0.272621+0.962121*%i;
        0.088854+-0.996045*%i;  -0.263755+0.964590*%i;
        0.085797+-0.996313*%i;  -0.254866+0.966976*%i;
        0.082740+-0.996571*%i;  -0.245955+0.969281*%i;
        0.079682+-0.996820*%i;  -0.237024+0.971504*%i;
        0.076624+-0.997060*%i;  -0.228072+0.973644*%i;
        0.073565+-0.997290*%i;  -0.219101+0.975702*%i;
        0.070505+-0.997511*%i;  -0.210112+0.977677*%i;
        0.067444+-0.997723*%i;  -0.201105+0.979570*%i;
        0.064383+-0.997925*%i;  -0.192080+0.981379*%i;
        0.061321+-0.998118*%i;  -0.183040+0.983105*%i;
        0.058258+-0.998302*%i;  -0.173984+0.984749*%i;
        0.055195+-0.998476*%i;  -0.164913+0.986308*%i;
        0.052132+-0.998640*%i;  -0.155828+0.987784*%i;
        0.049068+-0.998795*%i;  -0.146730+0.989177*%i;
        0.046003+-0.998941*%i;  -0.137620+0.990485*%i;
        0.042938+-0.999078*%i;  -0.128498+0.991710*%i;
        0.039873+-0.999205*%i;  -0.119365+0.992850*%i;
        0.036807+-0.999322*%i;  -0.110222+0.993907*%i;
        0.033741+-0.999431*%i;  -0.101070+0.994879*%i;
        0.030675+-0.999529*%i;  -0.091909+0.995767*%i;
        0.027608+-0.999619*%i;  -0.082740+0.996571*%i;
        0.024541+-0.999699*%i;  -0.073565+0.997290*%i;
        0.021474+-0.999769*%i;  -0.064383+0.997925*%i;
        0.018407+-0.999831*%i;  -0.055195+0.998476*%i;
        0.015339+-0.999882*%i;  -0.046003+0.998941*%i;
        0.012272+-0.999925*%i;  -0.036807+0.999322*%i;
        0.009204+-0.999958*%i;  -0.027608+0.999619*%i;
        0.006136+-0.999981*%i;  -0.018407+0.999831*%i;
        0.003068+-0.999995*%i;  -0.009204+0.999958*%i];







function a = make_swap_tab(nlog, size_a)
  nlog = nlog - 1;
  if nlog > 0 then
    a = make_swap_tab(nlog, size_a);
  else
    nlog = 0;
    a = zeros(size_a, 1);
  end
  for i=1:size_a,
    a(i) = a(i)*2;
  end
  for i=0:2^(nlog+1):size_a-1,
    for j=1:2^nlog,
      a(i+j+2^nlog) = a(i+j+2^nlog) + 1;
    end
  end
endfunction

function y = l_butterfly(y, i_a, i_twiddle_factor, nb_butterflies)


          i_b = i_a + nb_butterflies;

          // temp1 = k/(2^(stage+1));
          // temp2 = k*2^(11-(stage+1))/(2^11);
          //printf("%f\t%f\n", temp1, temp2);

          k = (i_twiddle_factor-1)/2;
          k = k/(2^11);
          w = exp(-2*PI*%i*k);
          //w2 = exp(-2*PI*%i*k*2);
          w3 = exp(-2*PI*%i*k*3);
          //printf("\tDSP16_Q(%f), DSP16_Q(%f),\n", w2/4, -w2*%i/4);
          // printf(" XOXO(%f), XOXO(%f), XOXO(%f), XOXO(%f),\n", w, -w*%i, w3, -w3*%i);
          

          //printf("%i ", stage);
          // to calculate w and w3
      //     w = exp(-2*PI*%i*k/(2^(stage+1)));
      //     w3 = exp(-2*PI*%i*3*k/(2^(stage+1)));

          // i = (i-1)*2^(11-(stage+1));
        //  disp(i_twiddle_factor);
  //        w = twiddle_factors(i_twiddle_factor);
  //        w3 = twiddle_factors(i_twiddle_factor+1);

        //  printf("\t%f+%f*%%i;\t%f+%f*%%i;\n", w, -w*%i, w3, -w3*%i);
       //   printf("\tDSP16_Q(%f), DSP16_Q(%f),\tDSP16_Q(%f), DSP16_Q(%f),\n", w, -w*%i, w3, -w3*%i);
          //printf("%i - %i\t\tw: %f + %fi\t w3: %f + %fi\n", stage, i, w, -w*%i, w3, -w3*%i);

          y(i_a) = y(i_a)*w/2;
          y(i_b) = y(i_b)*w3/2;
          

          A = y(i_a) + y(i_b);
          B = (y(i_b) - y(i_a))*%i;
        

          y(i_a) = A;
          y(i_b) = B;

          i_a1 = i_a - nb_butterflies*2;
          i_b1 = i_a;
          i_a2 = i_b - nb_butterflies*2;
          i_b2 = i_b;

          y(i_a1) = y(i_a1)/2;
          y(i_b1) = y(i_b1)/2;
          y(i_a2) = y(i_a2)/2;
          y(i_b2) = y(i_b2)/2;

          A = y(i_a1) + y(i_b1);
          B = y(i_a1) - y(i_b1);
          y(i_a1) = A;
          y(i_b1) = B;
          

          A = y(i_a2) + y(i_b2);
          
//          printf("\t%f+%f*%%i;\n", A, -A*%i);
//          printf("\t%f+%f*%%i;\n", y(i_a2), -y(i_a2)*%i);
//          printf("\t%f+%f*%%i;\n", y(i_b2), -y(i_b2)*%i);
          
          B = y(i_a2) - y(i_b2);
          y(i_a2) = A;
          y(i_b2) = B;


endfunction

function [y, nb_mul] = fft_split_dit(x)

  N = size(x, '*');
  nlog = log(N)/log(2);
  nb_mul = 0;

  // Reorganize the table
  swap_tab = make_swap_tab(log2(N), N) + 1;
  for i=1:N,
    y(swap_tab(i)) = x(i);
  end
  y = y';

 // disp(y);

  pattern = [ 0; 1];

  stage = 1;
  // number of butterflies per recursion
  nb_butterflies = 1;
  //number of recursions
  nb_rec = N/2;

  but = 2;

  A = y(1) + y(2);
  B = y(1) - y(2);
  y(1) = A/2;
  y(2) = B/2;

  y = l_butterfly(y, 3, 1, 1);
  nb_mul = nb_mul + 2;

  //disp(y);

  indice = 1;
  comput = 1;
  nb_comput = 1;
  new_pattern = 0;
  new_pattern(1) = 0;

//  printf("\n");

  for i_rec=2:nb_rec/2,

    if comput == 0 then
      j = length(new_pattern);
      if new_pattern(j) == 1 then
        new_pattern(j) = 0;
      else
        new_pattern(j) = 1;
      end
      new_pattern(j+1:j*2) = new_pattern;

      nb_comput = nb_comput*2;
      comput = nb_comput;
      indice = 1;
    end
    comput = comput - 1;

    rec = (i_rec-1)*2+1;

 //   disp((rec-1)*2);

    i_a = (rec-1)*2 + 1;
    i_b = rec*2

    A = y(i_a) + y(i_b);
    B = y(i_a) - y(i_b);

    y(i_a) = A/2;
    y(i_b) = B/2;
  
    rec = rec + 1;

    if new_pattern(indice) == 0 then

 //     printf("0");
      
 //     printf("%i\n", (rec-1)*2);

      i_a = (rec-1)*2 + 1;
      i_b = rec*2

      A = y(i_a) + y(i_b);
      B = y(i_a) - y(i_b);

      y(i_a) = A/2;
      y(i_b) = B/2;

    else

  //    printf("1");

      i_a = (rec-1)*2 + 1;

      i = (0)*2^(11-(stage+1))*2+1;
      y = l_butterfly(y, i_a, i, 1);
      nb_mul = nb_mul + 2;

    end

    indice = indice + 1;

  end

 // printf("\n");


  for stage=2:nlog-1,

    but = 2;
    nb_comput = 1;
    comput = 1;
    new_pattern = 0;
    new_pattern(1) = 0;
    indice = 1;

    // number of butterflies per recursion
    nb_butterflies = 2^(stage-1);

    //number of recursions
    nb_rec = N/(nb_butterflies*2);

    // L Butterfly DIT
    if nb_rec > 1 then
      rec = 2;
      for i=1:nb_butterflies,
        i_a = (rec-1)*nb_butterflies*2 + i;
        j = (i-1)*2^(11-(stage+1))*2+1;
 //       printf("-- %d  %d  %d  %d\n", i, j, stage, i_a)
        
        y = l_butterfly(y, i_a, j, nb_butterflies);
        nb_mul = nb_mul + 2;

      end
    end

    //printf("------------------\n");

    for i_rec=2:nb_rec/2,


      if comput == 0 then
        j = length(new_pattern);
        if new_pattern(j) == 1 then
          new_pattern(j) = 0;
        else
          new_pattern(j) = 1;
        end
        new_pattern(j+1:j*2) = new_pattern;

        nb_comput = nb_comput*2;
        comput = nb_comput;
        indice = 1;
      end
      comput = comput - 1;

      if new_pattern(indice) == 1 then

        for i=1:nb_butterflies,
          i_a = (i_rec*2-1)*nb_butterflies*2 + i;
          // L Butterfly DIT
          j = (i-1)*2^(11-(stage+1))*2+1;
          y = l_butterfly(y, i_a, j, nb_butterflies);
          
   //       printf("< %d  %d  %d  >\n", i_a-1, j-1, nb_butterflies);
          
          nb_mul = nb_mul + 2;
        end
   //     printf("1");

      else
   //     printf("0");
      end

      indice = indice + 1;

    end

  end
  
  //disp(y);

endfunction

//printf("%i\n", 1);
pattern(1) = 0;
for i=1:10,

  for j=1:length(pattern),
 //   printf("%i", pattern(j));
  end
//  printf("\n");

  j = length(pattern);
  if pattern(j) == 1 then
    pattern(j) = 0;
  else
    pattern(j) = 1;
  end
  pattern(j+1:j*2) = pattern;

end

// FFT split-radix test
N = 4096;
PI = 3.14159265358979323846;
Fs = 40000;

// Base signal
t = 0:(N-1);
F1 = 400;
F2 = 2000;
x1 = sin(2*PI*F1/Fs*t);
x2 = cos(2*PI*F2/Fs*t);
x = x1.*x2;



for t=1:N,
  printf('  DSP32_Q(%.10f),\n\r', x(t));
end

clf()
subplot(311)
plot(x);


// Desired result
y = fft(x);
f = Fs*(0:(N/2))/N;
n = size(f, '*');

subplot(312)
xtitle("Scilab FFT")
plot2d(f, abs(y(1:n)));

y_test = 0;
// FFT split-radix DIT implementation
disp("--- FFT split-radix DIT optimised ---");
[y_test, nb_mul] = fft_split_dit(x);
f = Fs*(0:(N/2))/N;
n = size(f, '*');
subplot(313)
xtitle("FFT split-radix DIT optimised")
plot2d(f, abs(y_test(1:n)));
disp('Number of multiplications:');
disp(nb_mul);
