/* This header file is part of the ATMEL AVR32-UC3-SoftwareFramework-1.6.0 Release */

/*This file is prepared for Doxygen automatic documentation generation.*/
/*! \file ******************************************************************
 *
 * \brief Autobaud detection.
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All AVR32 devices.
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 ***************************************************************************/

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
 *
 */
#ifndef _AUTOBAUD_H_
#define _AUTOBAUD_H_

/*! \name Configuration for a frequency detection using a known oscillator as a
 *        reference.
 */
//! \{
struct autobaud_cfg_osc_cmp_t
{
  //! The reference's oscillator frequency.
  int osc_ref_freq_hz;
  //! Callback used to reset the counter of the reference's oscillator.
  void (*osc_ref_counter_reset)(void);
  //! Callback used to read the counter value of the reference's oscillator.
  int (*osc_ref_counter_value)(void);
  //! Callback used to reset the counter of the target oscillator.
  void (*osc_target_counter_reset)(void);
  //! Callback used to read the counter value of the target oscillator.
  int (*osc_target_counter_value)(void);
  //! A coefficient that defines the accuracy of the detection.
  //! The highest it is, the less accurate the result will be but the fastest it
  //! will be generated.
  int convergence_rate;
};
//! \}

/*! \name Matching frequencies.
 */
//! \{
struct autobaud_matching_freq_t
{
  //! A table which contains the expected frequencies.
  const int *freq_hz;
  //! Number of entries in this table.
  const int nb_entries;
};
//! \}

/*! \brief This function guess a frequency by comparing it with a fixed known
 *         oscillator.
 * \param cfg A structure used to describe the context of the system.
 * \return The frequency guessed.
 */
int autobaud_detect_osc_cmp(const struct autobaud_cfg_osc_cmp_t *cfg);
/*! \brief This function matches a reference frequency amongst a list of known
 *         frequencies.
 * \param freq_hz The reference frequency.
 * \param match The list of known frequencies.
 * \return The matching frequency.
 */
int autobaud_match_frequency(int freq_hz, const struct autobaud_matching_freq_t *match);

#endif //_AUTOBAUD_H_
