/* This header file is part of the ATMEL AVR32-UC3-SoftwareFramework-1.6.0 Release */

/*This file is prepared for Doxygen automatic documentation generation.*/
/*! \file ******************************************************************
 *
 * \brief Definition file for AVR32 USBB.
 *
 * This file contains extensions to the autogenerated definitions related to
 * USBB.
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All AVR32 devices with a USBB module can be used.
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 ***************************************************************************/

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
 *
 */

#ifndef _USBB_H_
#define _USBB_H_

#include <avr32/io.h>
#include "compiler.h"
#include "preprocessor.h"




//! Generic definitions for all USBB registers that can be arrayed
//! @{
#define AVR32_USBB_UECFGX                                   AVR32_USBB_UECFG0
#define AVR32_USBB_UECFGX_ALLOC                             AVR32_USBB_UECFG0_ALLOC
#define AVR32_USBB_UECFGX_ALLOC_MASK                        AVR32_USBB_UECFG0_ALLOC_MASK
#define AVR32_USBB_UECFGX_ALLOC_OFFSET                      AVR32_USBB_UECFG0_ALLOC_OFFSET
#define AVR32_USBB_UECFGX_ALLOC_SIZE                        AVR32_USBB_UECFG0_ALLOC_SIZE
#define AVR32_USBB_UECFGX_AUTOSW                            AVR32_USBB_UECFG0_AUTOSW
#define AVR32_USBB_UECFGX_AUTOSW_MASK                       AVR32_USBB_UECFG0_AUTOSW_MASK
#define AVR32_USBB_UECFGX_AUTOSW_OFFSET                     AVR32_USBB_UECFG0_AUTOSW_OFFSET
#define AVR32_USBB_UECFGX_AUTOSW_SIZE                       AVR32_USBB_UECFG0_AUTOSW_SIZE
#define AVR32_USBB_UECFGX_EPBK                              AVR32_USBB_UECFG0_EPBK
#define AVR32_USBB_UECFGX_EPBK_DOUBLE                       AVR32_USBB_UECFG0_EPBK_DOUBLE
#define AVR32_USBB_UECFGX_EPBK_MASK                         AVR32_USBB_UECFG0_EPBK_MASK
#define AVR32_USBB_UECFGX_EPBK_OFFSET                       AVR32_USBB_UECFG0_EPBK_OFFSET
#define AVR32_USBB_UECFGX_EPBK_SINGLE                       AVR32_USBB_UECFG0_EPBK_SINGLE
#define AVR32_USBB_UECFGX_EPBK_SIZE                         AVR32_USBB_UECFG0_EPBK_SIZE
#define AVR32_USBB_UECFGX_EPBK_TRIPLE                       AVR32_USBB_UECFG0_EPBK_TRIPLE
#define AVR32_USBB_UECFGX_EPDIR                             AVR32_USBB_UECFG0_EPDIR
#define AVR32_USBB_UECFGX_EPDIR_IN                          AVR32_USBB_UECFG0_EPDIR_IN
#define AVR32_USBB_UECFGX_EPDIR_MASK                        AVR32_USBB_UECFG0_EPDIR_MASK
#define AVR32_USBB_UECFGX_EPDIR_OFFSET                      AVR32_USBB_UECFG0_EPDIR_OFFSET
#define AVR32_USBB_UECFGX_EPDIR_OUT                         AVR32_USBB_UECFG0_EPDIR_OUT
#define AVR32_USBB_UECFGX_EPDIR_SIZE                        AVR32_USBB_UECFG0_EPDIR_SIZE
#define AVR32_USBB_UECFGX_EPSIZE                            AVR32_USBB_UECFG0_EPSIZE
#define AVR32_USBB_UECFGX_EPSIZE_1024                       AVR32_USBB_UECFG0_EPSIZE_1024
#define AVR32_USBB_UECFGX_EPSIZE_128                        AVR32_USBB_UECFG0_EPSIZE_128
#define AVR32_USBB_UECFGX_EPSIZE_16                         AVR32_USBB_UECFG0_EPSIZE_16
#define AVR32_USBB_UECFGX_EPSIZE_256                        AVR32_USBB_UECFG0_EPSIZE_256
#define AVR32_USBB_UECFGX_EPSIZE_32                         AVR32_USBB_UECFG0_EPSIZE_32
#define AVR32_USBB_UECFGX_EPSIZE_512                        AVR32_USBB_UECFG0_EPSIZE_512
#define AVR32_USBB_UECFGX_EPSIZE_64                         AVR32_USBB_UECFG0_EPSIZE_64
#define AVR32_USBB_UECFGX_EPSIZE_8                          AVR32_USBB_UECFG0_EPSIZE_8
#define AVR32_USBB_UECFGX_EPSIZE_MASK                       AVR32_USBB_UECFG0_EPSIZE_MASK
#define AVR32_USBB_UECFGX_EPSIZE_OFFSET                     AVR32_USBB_UECFG0_EPSIZE_OFFSET
#define AVR32_USBB_UECFGX_EPSIZE_SIZE                       AVR32_USBB_UECFG0_EPSIZE_SIZE
#define AVR32_USBB_UECFGX_EPTYPE                            AVR32_USBB_UECFG0_EPTYPE
#define AVR32_USBB_UECFGX_EPTYPE_BULK                       AVR32_USBB_UECFG0_EPTYPE_BULK
#define AVR32_USBB_UECFGX_EPTYPE_CONTROL                    AVR32_USBB_UECFG0_EPTYPE_CONTROL
#define AVR32_USBB_UECFGX_EPTYPE_INTERRUPT                  AVR32_USBB_UECFG0_EPTYPE_INTERRUPT
#define AVR32_USBB_UECFGX_EPTYPE_ISOCHRONOUS                AVR32_USBB_UECFG0_EPTYPE_ISOCHRONOUS
#define AVR32_USBB_UECFGX_EPTYPE_MASK                       AVR32_USBB_UECFG0_EPTYPE_MASK
#define AVR32_USBB_UECFGX_EPTYPE_OFFSET                     AVR32_USBB_UECFG0_EPTYPE_OFFSET
#define AVR32_USBB_UECFGX_EPTYPE_SIZE                       AVR32_USBB_UECFG0_EPTYPE_SIZE
#define AVR32_USBB_UECONX                                   AVR32_USBB_UECON0
#define AVR32_USBB_UECONXCLR                                AVR32_USBB_UECON0CLR
#define AVR32_USBB_UECONXCLR_EPDISHDMAC                     AVR32_USBB_UECON0CLR_EPDISHDMAC
#define AVR32_USBB_UECONXCLR_EPDISHDMAC_MASK                AVR32_USBB_UECON0CLR_EPDISHDMAC_MASK
#define AVR32_USBB_UECONXCLR_EPDISHDMAC_OFFSET              AVR32_USBB_UECON0CLR_EPDISHDMAC_OFFSET
#define AVR32_USBB_UECONXCLR_EPDISHDMAC_SIZE                AVR32_USBB_UECON0CLR_EPDISHDMAC_SIZE
#define AVR32_USBB_UECONXCLR_FIFOCONC                       AVR32_USBB_UECON0CLR_FIFOCONC
#define AVR32_USBB_UECONXCLR_FIFOCONC_MASK                  AVR32_USBB_UECON0CLR_FIFOCONC_MASK
#define AVR32_USBB_UECONXCLR_FIFOCONC_OFFSET                AVR32_USBB_UECON0CLR_FIFOCONC_OFFSET
#define AVR32_USBB_UECONXCLR_FIFOCONC_SIZE                  AVR32_USBB_UECON0CLR_FIFOCONC_SIZE
#define AVR32_USBB_UECONXCLR_NAKINEC                        AVR32_USBB_UECON0CLR_NAKINEC
#define AVR32_USBB_UECONXCLR_NAKINEC_MASK                   AVR32_USBB_UECON0CLR_NAKINEC_MASK
#define AVR32_USBB_UECONXCLR_NAKINEC_OFFSET                 AVR32_USBB_UECON0CLR_NAKINEC_OFFSET
#define AVR32_USBB_UECONXCLR_NAKINEC_SIZE                   AVR32_USBB_UECON0CLR_NAKINEC_SIZE
#define AVR32_USBB_UECONXCLR_NAKOUTEC                       AVR32_USBB_UECON0CLR_NAKOUTEC
#define AVR32_USBB_UECONXCLR_NAKOUTEC_MASK                  AVR32_USBB_UECON0CLR_NAKOUTEC_MASK
#define AVR32_USBB_UECONXCLR_NAKOUTEC_OFFSET                AVR32_USBB_UECON0CLR_NAKOUTEC_OFFSET
#define AVR32_USBB_UECONXCLR_NAKOUTEC_SIZE                  AVR32_USBB_UECON0CLR_NAKOUTEC_SIZE
#define AVR32_USBB_UECONXCLR_NBUSYBKEC                      AVR32_USBB_UECON0CLR_NBUSYBKEC
#define AVR32_USBB_UECONXCLR_NBUSYBKEC_MASK                 AVR32_USBB_UECON0CLR_NBUSYBKEC_MASK
#define AVR32_USBB_UECONXCLR_NBUSYBKEC_OFFSET               AVR32_USBB_UECON0CLR_NBUSYBKEC_OFFSET
#define AVR32_USBB_UECONXCLR_NBUSYBKEC_SIZE                 AVR32_USBB_UECON0CLR_NBUSYBKEC_SIZE
#define AVR32_USBB_UECONXCLR_OVERFEC                        AVR32_USBB_UECON0CLR_OVERFEC
#define AVR32_USBB_UECONXCLR_OVERFEC_MASK                   AVR32_USBB_UECON0CLR_OVERFEC_MASK
#define AVR32_USBB_UECONXCLR_OVERFEC_OFFSET                 AVR32_USBB_UECON0CLR_OVERFEC_OFFSET
#define AVR32_USBB_UECONXCLR_OVERFEC_SIZE                   AVR32_USBB_UECON0CLR_OVERFEC_SIZE
#define AVR32_USBB_UECONXCLR_RXOUTEC                        AVR32_USBB_UECON0CLR_RXOUTEC
#define AVR32_USBB_UECONXCLR_RXOUTEC_MASK                   AVR32_USBB_UECON0CLR_RXOUTEC_MASK
#define AVR32_USBB_UECONXCLR_RXOUTEC_OFFSET                 AVR32_USBB_UECON0CLR_RXOUTEC_OFFSET
#define AVR32_USBB_UECONXCLR_RXOUTEC_SIZE                   AVR32_USBB_UECON0CLR_RXOUTEC_SIZE
#define AVR32_USBB_UECONXCLR_RXSTPEC                        AVR32_USBB_UECON0CLR_RXSTPEC
#define AVR32_USBB_UECONXCLR_RXSTPEC_MASK                   AVR32_USBB_UECON0CLR_RXSTPEC_MASK
#define AVR32_USBB_UECONXCLR_RXSTPEC_OFFSET                 AVR32_USBB_UECON0CLR_RXSTPEC_OFFSET
#define AVR32_USBB_UECONXCLR_RXSTPEC_SIZE                   AVR32_USBB_UECON0CLR_RXSTPEC_SIZE
#define AVR32_USBB_UECONXCLR_SHORTPACKETEC                  AVR32_USBB_UECON0CLR_SHORTPACKETEC
#define AVR32_USBB_UECONXCLR_SHORTPACKETEC_MASK             AVR32_USBB_UECON0CLR_SHORTPACKETEC_MASK
#define AVR32_USBB_UECONXCLR_SHORTPACKETEC_OFFSET           AVR32_USBB_UECON0CLR_SHORTPACKETEC_OFFSET
#define AVR32_USBB_UECONXCLR_SHORTPACKETEC_SIZE             AVR32_USBB_UECON0CLR_SHORTPACKETEC_SIZE
#define AVR32_USBB_UECONXCLR_STALLEDEC                      AVR32_USBB_UECON0CLR_STALLEDEC
#define AVR32_USBB_UECONXCLR_STALLEDEC_MASK                 AVR32_USBB_UECON0CLR_STALLEDEC_MASK
#define AVR32_USBB_UECONXCLR_STALLEDEC_OFFSET               AVR32_USBB_UECON0CLR_STALLEDEC_OFFSET
#define AVR32_USBB_UECONXCLR_STALLEDEC_SIZE                 AVR32_USBB_UECON0CLR_STALLEDEC_SIZE
#define AVR32_USBB_UECONXCLR_STALLRQC                       AVR32_USBB_UECON0CLR_STALLRQC
#define AVR32_USBB_UECONXCLR_STALLRQC_MASK                  AVR32_USBB_UECON0CLR_STALLRQC_MASK
#define AVR32_USBB_UECONXCLR_STALLRQC_OFFSET                AVR32_USBB_UECON0CLR_STALLRQC_OFFSET
#define AVR32_USBB_UECONXCLR_STALLRQC_SIZE                  AVR32_USBB_UECON0CLR_STALLRQC_SIZE
#define AVR32_USBB_UECONXCLR_TXINEC                         AVR32_USBB_UECON0CLR_TXINEC
#define AVR32_USBB_UECONXCLR_TXINEC_MASK                    AVR32_USBB_UECON0CLR_TXINEC_MASK
#define AVR32_USBB_UECONXCLR_TXINEC_OFFSET                  AVR32_USBB_UECON0CLR_TXINEC_OFFSET
#define AVR32_USBB_UECONXCLR_TXINEC_SIZE                    AVR32_USBB_UECON0CLR_TXINEC_SIZE
#define AVR32_USBB_UECONXSET                                AVR32_USBB_UECON0SET
#define AVR32_USBB_UECONXSET_EPDISHDMAS                     AVR32_USBB_UECON0SET_EPDISHDMAS
#define AVR32_USBB_UECONXSET_EPDISHDMAS_MASK                AVR32_USBB_UECON0SET_EPDISHDMAS_MASK
#define AVR32_USBB_UECONXSET_EPDISHDMAS_OFFSET              AVR32_USBB_UECON0SET_EPDISHDMAS_OFFSET
#define AVR32_USBB_UECONXSET_EPDISHDMAS_SIZE                AVR32_USBB_UECON0SET_EPDISHDMAS_SIZE
#define AVR32_USBB_UECONXSET_KILLBKS                        AVR32_USBB_UECON0SET_KILLBKS
#define AVR32_USBB_UECONXSET_KILLBKS_MASK                   AVR32_USBB_UECON0SET_KILLBKS_MASK
#define AVR32_USBB_UECONXSET_KILLBKS_OFFSET                 AVR32_USBB_UECON0SET_KILLBKS_OFFSET
#define AVR32_USBB_UECONXSET_KILLBKS_SIZE                   AVR32_USBB_UECON0SET_KILLBKS_SIZE
#define AVR32_USBB_UECONXSET_NAKINES                        AVR32_USBB_UECON0SET_NAKINES
#define AVR32_USBB_UECONXSET_NAKINES_MASK                   AVR32_USBB_UECON0SET_NAKINES_MASK
#define AVR32_USBB_UECONXSET_NAKINES_OFFSET                 AVR32_USBB_UECON0SET_NAKINES_OFFSET
#define AVR32_USBB_UECONXSET_NAKINES_SIZE                   AVR32_USBB_UECON0SET_NAKINES_SIZE
#define AVR32_USBB_UECONXSET_NAKOUTES                       AVR32_USBB_UECON0SET_NAKOUTES
#define AVR32_USBB_UECONXSET_NAKOUTES_MASK                  AVR32_USBB_UECON0SET_NAKOUTES_MASK
#define AVR32_USBB_UECONXSET_NAKOUTES_OFFSET                AVR32_USBB_UECON0SET_NAKOUTES_OFFSET
#define AVR32_USBB_UECONXSET_NAKOUTES_SIZE                  AVR32_USBB_UECON0SET_NAKOUTES_SIZE
#define AVR32_USBB_UECONXSET_NBUSYBKES                      AVR32_USBB_UECON0SET_NBUSYBKES
#define AVR32_USBB_UECONXSET_NBUSYBKES_MASK                 AVR32_USBB_UECON0SET_NBUSYBKES_MASK
#define AVR32_USBB_UECONXSET_NBUSYBKES_OFFSET               AVR32_USBB_UECON0SET_NBUSYBKES_OFFSET
#define AVR32_USBB_UECONXSET_NBUSYBKES_SIZE                 AVR32_USBB_UECON0SET_NBUSYBKES_SIZE
#define AVR32_USBB_UECONXSET_OVERFES                        AVR32_USBB_UECON0SET_OVERFES
#define AVR32_USBB_UECONXSET_OVERFES_MASK                   AVR32_USBB_UECON0SET_OVERFES_MASK
#define AVR32_USBB_UECONXSET_OVERFES_OFFSET                 AVR32_USBB_UECON0SET_OVERFES_OFFSET
#define AVR32_USBB_UECONXSET_OVERFES_SIZE                   AVR32_USBB_UECON0SET_OVERFES_SIZE
#define AVR32_USBB_UECONXSET_RSTDTS                         AVR32_USBB_UECON0SET_RSTDTS
#define AVR32_USBB_UECONXSET_RSTDTS_MASK                    AVR32_USBB_UECON0SET_RSTDTS_MASK
#define AVR32_USBB_UECONXSET_RSTDTS_OFFSET                  AVR32_USBB_UECON0SET_RSTDTS_OFFSET
#define AVR32_USBB_UECONXSET_RSTDTS_SIZE                    AVR32_USBB_UECON0SET_RSTDTS_SIZE
#define AVR32_USBB_UECONXSET_RXOUTES                        AVR32_USBB_UECON0SET_RXOUTES
#define AVR32_USBB_UECONXSET_RXOUTES_MASK                   AVR32_USBB_UECON0SET_RXOUTES_MASK
#define AVR32_USBB_UECONXSET_RXOUTES_OFFSET                 AVR32_USBB_UECON0SET_RXOUTES_OFFSET
#define AVR32_USBB_UECONXSET_RXOUTES_SIZE                   AVR32_USBB_UECON0SET_RXOUTES_SIZE
#define AVR32_USBB_UECONXSET_RXSTPES                        AVR32_USBB_UECON0SET_RXSTPES
#define AVR32_USBB_UECONXSET_RXSTPES_MASK                   AVR32_USBB_UECON0SET_RXSTPES_MASK
#define AVR32_USBB_UECONXSET_RXSTPES_OFFSET                 AVR32_USBB_UECON0SET_RXSTPES_OFFSET
#define AVR32_USBB_UECONXSET_RXSTPES_SIZE                   AVR32_USBB_UECON0SET_RXSTPES_SIZE
#define AVR32_USBB_UECONXSET_SHORTPACKETES                  AVR32_USBB_UECON0SET_SHORTPACKETES
#define AVR32_USBB_UECONXSET_SHORTPACKETES_MASK             AVR32_USBB_UECON0SET_SHORTPACKETES_MASK
#define AVR32_USBB_UECONXSET_SHORTPACKETES_OFFSET           AVR32_USBB_UECON0SET_SHORTPACKETES_OFFSET
#define AVR32_USBB_UECONXSET_SHORTPACKETES_SIZE             AVR32_USBB_UECON0SET_SHORTPACKETES_SIZE
#define AVR32_USBB_UECONXSET_STALLEDES                      AVR32_USBB_UECON0SET_STALLEDES
#define AVR32_USBB_UECONXSET_STALLEDES_MASK                 AVR32_USBB_UECON0SET_STALLEDES_MASK
#define AVR32_USBB_UECONXSET_STALLEDES_OFFSET               AVR32_USBB_UECON0SET_STALLEDES_OFFSET
#define AVR32_USBB_UECONXSET_STALLEDES_SIZE                 AVR32_USBB_UECON0SET_STALLEDES_SIZE
#define AVR32_USBB_UECONXSET_STALLRQS                       AVR32_USBB_UECON0SET_STALLRQS
#define AVR32_USBB_UECONXSET_STALLRQS_MASK                  AVR32_USBB_UECON0SET_STALLRQS_MASK
#define AVR32_USBB_UECONXSET_STALLRQS_OFFSET                AVR32_USBB_UECON0SET_STALLRQS_OFFSET
#define AVR32_USBB_UECONXSET_STALLRQS_SIZE                  AVR32_USBB_UECON0SET_STALLRQS_SIZE
#define AVR32_USBB_UECONXSET_TXINES                         AVR32_USBB_UECON0SET_TXINES
#define AVR32_USBB_UECONXSET_TXINES_MASK                    AVR32_USBB_UECON0SET_TXINES_MASK
#define AVR32_USBB_UECONXSET_TXINES_OFFSET                  AVR32_USBB_UECON0SET_TXINES_OFFSET
#define AVR32_USBB_UECONXSET_TXINES_SIZE                    AVR32_USBB_UECON0SET_TXINES_SIZE
#define AVR32_USBB_UECONX_EPDISHDMA                         AVR32_USBB_UECON0_EPDISHDMA
#define AVR32_USBB_UECONX_EPDISHDMA_MASK                    AVR32_USBB_UECON0_EPDISHDMA_MASK
#define AVR32_USBB_UECONX_EPDISHDMA_OFFSET                  AVR32_USBB_UECON0_EPDISHDMA_OFFSET
#define AVR32_USBB_UECONX_EPDISHDMA_SIZE                    AVR32_USBB_UECON0_EPDISHDMA_SIZE
#define AVR32_USBB_UECONX_FIFOCON                           AVR32_USBB_UECON0_FIFOCON
#define AVR32_USBB_UECONX_FIFOCON_MASK                      AVR32_USBB_UECON0_FIFOCON_MASK
#define AVR32_USBB_UECONX_FIFOCON_OFFSET                    AVR32_USBB_UECON0_FIFOCON_OFFSET
#define AVR32_USBB_UECONX_FIFOCON_SIZE                      AVR32_USBB_UECON0_FIFOCON_SIZE
#define AVR32_USBB_UECONX_KILLBK                            AVR32_USBB_UECON0_KILLBK
#define AVR32_USBB_UECONX_KILLBK_MASK                       AVR32_USBB_UECON0_KILLBK_MASK
#define AVR32_USBB_UECONX_KILLBK_OFFSET                     AVR32_USBB_UECON0_KILLBK_OFFSET
#define AVR32_USBB_UECONX_KILLBK_SIZE                       AVR32_USBB_UECON0_KILLBK_SIZE
#define AVR32_USBB_UECONX_NAKINE                            AVR32_USBB_UECON0_NAKINE
#define AVR32_USBB_UECONX_NAKINE_MASK                       AVR32_USBB_UECON0_NAKINE_MASK
#define AVR32_USBB_UECONX_NAKINE_OFFSET                     AVR32_USBB_UECON0_NAKINE_OFFSET
#define AVR32_USBB_UECONX_NAKINE_SIZE                       AVR32_USBB_UECON0_NAKINE_SIZE
#define AVR32_USBB_UECONX_NAKOUTE                           AVR32_USBB_UECON0_NAKOUTE
#define AVR32_USBB_UECONX_NAKOUTE_MASK                      AVR32_USBB_UECON0_NAKOUTE_MASK
#define AVR32_USBB_UECONX_NAKOUTE_OFFSET                    AVR32_USBB_UECON0_NAKOUTE_OFFSET
#define AVR32_USBB_UECONX_NAKOUTE_SIZE                      AVR32_USBB_UECON0_NAKOUTE_SIZE
#define AVR32_USBB_UECONX_NBUSYBKE                          AVR32_USBB_UECON0_NBUSYBKE
#define AVR32_USBB_UECONX_NBUSYBKE_MASK                     AVR32_USBB_UECON0_NBUSYBKE_MASK
#define AVR32_USBB_UECONX_NBUSYBKE_OFFSET                   AVR32_USBB_UECON0_NBUSYBKE_OFFSET
#define AVR32_USBB_UECONX_NBUSYBKE_SIZE                     AVR32_USBB_UECON0_NBUSYBKE_SIZE
#define AVR32_USBB_UECONX_OVERFE                            AVR32_USBB_UECON0_OVERFE
#define AVR32_USBB_UECONX_OVERFE_MASK                       AVR32_USBB_UECON0_OVERFE_MASK
#define AVR32_USBB_UECONX_OVERFE_OFFSET                     AVR32_USBB_UECON0_OVERFE_OFFSET
#define AVR32_USBB_UECONX_OVERFE_SIZE                       AVR32_USBB_UECON0_OVERFE_SIZE
#define AVR32_USBB_UECONX_RSTDT                             AVR32_USBB_UECON0_RSTDT
#define AVR32_USBB_UECONX_RSTDT_MASK                        AVR32_USBB_UECON0_RSTDT_MASK
#define AVR32_USBB_UECONX_RSTDT_OFFSET                      AVR32_USBB_UECON0_RSTDT_OFFSET
#define AVR32_USBB_UECONX_RSTDT_SIZE                        AVR32_USBB_UECON0_RSTDT_SIZE
#define AVR32_USBB_UECONX_RXOUTE                            AVR32_USBB_UECON0_RXOUTE
#define AVR32_USBB_UECONX_RXOUTE_MASK                       AVR32_USBB_UECON0_RXOUTE_MASK
#define AVR32_USBB_UECONX_RXOUTE_OFFSET                     AVR32_USBB_UECON0_RXOUTE_OFFSET
#define AVR32_USBB_UECONX_RXOUTE_SIZE                       AVR32_USBB_UECON0_RXOUTE_SIZE
#define AVR32_USBB_UECONX_RXSTPE                            AVR32_USBB_UECON0_RXSTPE
#define AVR32_USBB_UECONX_RXSTPE_MASK                       AVR32_USBB_UECON0_RXSTPE_MASK
#define AVR32_USBB_UECONX_RXSTPE_OFFSET                     AVR32_USBB_UECON0_RXSTPE_OFFSET
#define AVR32_USBB_UECONX_RXSTPE_SIZE                       AVR32_USBB_UECON0_RXSTPE_SIZE
#define AVR32_USBB_UECONX_SHORTPACKETE                      AVR32_USBB_UECON0_SHORTPACKETE
#define AVR32_USBB_UECONX_SHORTPACKETE_MASK                 AVR32_USBB_UECON0_SHORTPACKETE_MASK
#define AVR32_USBB_UECONX_SHORTPACKETE_OFFSET               AVR32_USBB_UECON0_SHORTPACKETE_OFFSET
#define AVR32_USBB_UECONX_SHORTPACKETE_SIZE                 AVR32_USBB_UECON0_SHORTPACKETE_SIZE
#define AVR32_USBB_UECONX_STALLEDE                          AVR32_USBB_UECON0_STALLEDE
#define AVR32_USBB_UECONX_STALLEDE_MASK                     AVR32_USBB_UECON0_STALLEDE_MASK
#define AVR32_USBB_UECONX_STALLEDE_OFFSET                   AVR32_USBB_UECON0_STALLEDE_OFFSET
#define AVR32_USBB_UECONX_STALLEDE_SIZE                     AVR32_USBB_UECON0_STALLEDE_SIZE
#define AVR32_USBB_UECONX_STALLRQ                           AVR32_USBB_UECON0_STALLRQ
#define AVR32_USBB_UECONX_STALLRQ_MASK                      AVR32_USBB_UECON0_STALLRQ_MASK
#define AVR32_USBB_UECONX_STALLRQ_OFFSET                    AVR32_USBB_UECON0_STALLRQ_OFFSET
#define AVR32_USBB_UECONX_STALLRQ_SIZE                      AVR32_USBB_UECON0_STALLRQ_SIZE
#define AVR32_USBB_UECONX_TXINE                             AVR32_USBB_UECON0_TXINE
#define AVR32_USBB_UECONX_TXINE_MASK                        AVR32_USBB_UECON0_TXINE_MASK
#define AVR32_USBB_UECONX_TXINE_OFFSET                      AVR32_USBB_UECON0_TXINE_OFFSET
#define AVR32_USBB_UECONX_TXINE_SIZE                        AVR32_USBB_UECON0_TXINE_SIZE
#define AVR32_USBB_UESTAX                                   AVR32_USBB_UESTA0
#define AVR32_USBB_UESTAXCLR                                AVR32_USBB_UESTA0CLR
#define AVR32_USBB_UESTAXCLR_NAKINIC                        AVR32_USBB_UESTA0CLR_NAKINIC
#define AVR32_USBB_UESTAXCLR_NAKINIC_MASK                   AVR32_USBB_UESTA0CLR_NAKINIC_MASK
#define AVR32_USBB_UESTAXCLR_NAKINIC_OFFSET                 AVR32_USBB_UESTA0CLR_NAKINIC_OFFSET
#define AVR32_USBB_UESTAXCLR_NAKINIC_SIZE                   AVR32_USBB_UESTA0CLR_NAKINIC_SIZE
#define AVR32_USBB_UESTAXCLR_NAKOUTIC                       AVR32_USBB_UESTA0CLR_NAKOUTIC
#define AVR32_USBB_UESTAXCLR_NAKOUTIC_MASK                  AVR32_USBB_UESTA0CLR_NAKOUTIC_MASK
#define AVR32_USBB_UESTAXCLR_NAKOUTIC_OFFSET                AVR32_USBB_UESTA0CLR_NAKOUTIC_OFFSET
#define AVR32_USBB_UESTAXCLR_NAKOUTIC_SIZE                  AVR32_USBB_UESTA0CLR_NAKOUTIC_SIZE
#define AVR32_USBB_UESTAXCLR_OVERFIC                        AVR32_USBB_UESTA0CLR_OVERFIC
#define AVR32_USBB_UESTAXCLR_OVERFIC_MASK                   AVR32_USBB_UESTA0CLR_OVERFIC_MASK
#define AVR32_USBB_UESTAXCLR_OVERFIC_OFFSET                 AVR32_USBB_UESTA0CLR_OVERFIC_OFFSET
#define AVR32_USBB_UESTAXCLR_OVERFIC_SIZE                   AVR32_USBB_UESTA0CLR_OVERFIC_SIZE
#define AVR32_USBB_UESTAXCLR_RXOUTIC                        AVR32_USBB_UESTA0CLR_RXOUTIC
#define AVR32_USBB_UESTAXCLR_RXOUTIC_MASK                   AVR32_USBB_UESTA0CLR_RXOUTIC_MASK
#define AVR32_USBB_UESTAXCLR_RXOUTIC_OFFSET                 AVR32_USBB_UESTA0CLR_RXOUTIC_OFFSET
#define AVR32_USBB_UESTAXCLR_RXOUTIC_SIZE                   AVR32_USBB_UESTA0CLR_RXOUTIC_SIZE
#define AVR32_USBB_UESTAXCLR_RXSTPIC                        AVR32_USBB_UESTA0CLR_RXSTPIC
#define AVR32_USBB_UESTAXCLR_RXSTPIC_MASK                   AVR32_USBB_UESTA0CLR_RXSTPIC_MASK
#define AVR32_USBB_UESTAXCLR_RXSTPIC_OFFSET                 AVR32_USBB_UESTA0CLR_RXSTPIC_OFFSET
#define AVR32_USBB_UESTAXCLR_RXSTPIC_SIZE                   AVR32_USBB_UESTA0CLR_RXSTPIC_SIZE
#define AVR32_USBB_UESTAXCLR_SHORTPACKETC                   AVR32_USBB_UESTA0CLR_SHORTPACKETC
#define AVR32_USBB_UESTAXCLR_SHORTPACKETC_MASK              AVR32_USBB_UESTA0CLR_SHORTPACKETC_MASK
#define AVR32_USBB_UESTAXCLR_SHORTPACKETC_OFFSET            AVR32_USBB_UESTA0CLR_SHORTPACKETC_OFFSET
#define AVR32_USBB_UESTAXCLR_SHORTPACKETC_SIZE              AVR32_USBB_UESTA0CLR_SHORTPACKETC_SIZE
#define AVR32_USBB_UESTAXCLR_STALLEDIC                      AVR32_USBB_UESTA0CLR_STALLEDIC
#define AVR32_USBB_UESTAXCLR_STALLEDIC_MASK                 AVR32_USBB_UESTA0CLR_STALLEDIC_MASK
#define AVR32_USBB_UESTAXCLR_STALLEDIC_OFFSET               AVR32_USBB_UESTA0CLR_STALLEDIC_OFFSET
#define AVR32_USBB_UESTAXCLR_STALLEDIC_SIZE                 AVR32_USBB_UESTA0CLR_STALLEDIC_SIZE
#define AVR32_USBB_UESTAXCLR_TXINIC                         AVR32_USBB_UESTA0CLR_TXINIC
#define AVR32_USBB_UESTAXCLR_TXINIC_MASK                    AVR32_USBB_UESTA0CLR_TXINIC_MASK
#define AVR32_USBB_UESTAXCLR_TXINIC_OFFSET                  AVR32_USBB_UESTA0CLR_TXINIC_OFFSET
#define AVR32_USBB_UESTAXCLR_TXINIC_SIZE                    AVR32_USBB_UESTA0CLR_TXINIC_SIZE
#define AVR32_USBB_UESTAXSET                                AVR32_USBB_UESTA0SET
#define AVR32_USBB_UESTAXSET_NAKINIS                        AVR32_USBB_UESTA0SET_NAKINIS
#define AVR32_USBB_UESTAXSET_NAKINIS_MASK                   AVR32_USBB_UESTA0SET_NAKINIS_MASK
#define AVR32_USBB_UESTAXSET_NAKINIS_OFFSET                 AVR32_USBB_UESTA0SET_NAKINIS_OFFSET
#define AVR32_USBB_UESTAXSET_NAKINIS_SIZE                   AVR32_USBB_UESTA0SET_NAKINIS_SIZE
#define AVR32_USBB_UESTAXSET_NAKOUTIS                       AVR32_USBB_UESTA0SET_NAKOUTIS
#define AVR32_USBB_UESTAXSET_NAKOUTIS_MASK                  AVR32_USBB_UESTA0SET_NAKOUTIS_MASK
#define AVR32_USBB_UESTAXSET_NAKOUTIS_OFFSET                AVR32_USBB_UESTA0SET_NAKOUTIS_OFFSET
#define AVR32_USBB_UESTAXSET_NAKOUTIS_SIZE                  AVR32_USBB_UESTA0SET_NAKOUTIS_SIZE
#define AVR32_USBB_UESTAXSET_NBUSYBKS                       AVR32_USBB_UESTA0SET_NBUSYBKS
#define AVR32_USBB_UESTAXSET_NBUSYBKS_MASK                  AVR32_USBB_UESTA0SET_NBUSYBKS_MASK
#define AVR32_USBB_UESTAXSET_NBUSYBKS_OFFSET                AVR32_USBB_UESTA0SET_NBUSYBKS_OFFSET
#define AVR32_USBB_UESTAXSET_NBUSYBKS_SIZE                  AVR32_USBB_UESTA0SET_NBUSYBKS_SIZE
#define AVR32_USBB_UESTAXSET_OVERFIS                        AVR32_USBB_UESTA0SET_OVERFIS
#define AVR32_USBB_UESTAXSET_OVERFIS_MASK                   AVR32_USBB_UESTA0SET_OVERFIS_MASK
#define AVR32_USBB_UESTAXSET_OVERFIS_OFFSET                 AVR32_USBB_UESTA0SET_OVERFIS_OFFSET
#define AVR32_USBB_UESTAXSET_OVERFIS_SIZE                   AVR32_USBB_UESTA0SET_OVERFIS_SIZE
#define AVR32_USBB_UESTAXSET_RXOUTIS                        AVR32_USBB_UESTA0SET_RXOUTIS
#define AVR32_USBB_UESTAXSET_RXOUTIS_MASK                   AVR32_USBB_UESTA0SET_RXOUTIS_MASK
#define AVR32_USBB_UESTAXSET_RXOUTIS_OFFSET                 AVR32_USBB_UESTA0SET_RXOUTIS_OFFSET
#define AVR32_USBB_UESTAXSET_RXOUTIS_SIZE                   AVR32_USBB_UESTA0SET_RXOUTIS_SIZE
#define AVR32_USBB_UESTAXSET_RXSTPIS                        AVR32_USBB_UESTA0SET_RXSTPIS
#define AVR32_USBB_UESTAXSET_RXSTPIS_MASK                   AVR32_USBB_UESTA0SET_RXSTPIS_MASK
#define AVR32_USBB_UESTAXSET_RXSTPIS_OFFSET                 AVR32_USBB_UESTA0SET_RXSTPIS_OFFSET
#define AVR32_USBB_UESTAXSET_RXSTPIS_SIZE                   AVR32_USBB_UESTA0SET_RXSTPIS_SIZE
#define AVR32_USBB_UESTAXSET_SHORTPACKETS                   AVR32_USBB_UESTA0SET_SHORTPACKETS
#define AVR32_USBB_UESTAXSET_SHORTPACKETS_MASK              AVR32_USBB_UESTA0SET_SHORTPACKETS_MASK
#define AVR32_USBB_UESTAXSET_SHORTPACKETS_OFFSET            AVR32_USBB_UESTA0SET_SHORTPACKETS_OFFSET
#define AVR32_USBB_UESTAXSET_SHORTPACKETS_SIZE              AVR32_USBB_UESTA0SET_SHORTPACKETS_SIZE
#define AVR32_USBB_UESTAXSET_STALLEDIS                      AVR32_USBB_UESTA0SET_STALLEDIS
#define AVR32_USBB_UESTAXSET_STALLEDIS_MASK                 AVR32_USBB_UESTA0SET_STALLEDIS_MASK
#define AVR32_USBB_UESTAXSET_STALLEDIS_OFFSET               AVR32_USBB_UESTA0SET_STALLEDIS_OFFSET
#define AVR32_USBB_UESTAXSET_STALLEDIS_SIZE                 AVR32_USBB_UESTA0SET_STALLEDIS_SIZE
#define AVR32_USBB_UESTAXSET_TXINIS                         AVR32_USBB_UESTA0SET_TXINIS
#define AVR32_USBB_UESTAXSET_TXINIS_MASK                    AVR32_USBB_UESTA0SET_TXINIS_MASK
#define AVR32_USBB_UESTAXSET_TXINIS_OFFSET                  AVR32_USBB_UESTA0SET_TXINIS_OFFSET
#define AVR32_USBB_UESTAXSET_TXINIS_SIZE                    AVR32_USBB_UESTA0SET_TXINIS_SIZE
#define AVR32_USBB_UESTAX_BYCT                              AVR32_USBB_UESTA0_BYCT
#define AVR32_USBB_UESTAX_BYCT_MASK                         AVR32_USBB_UESTA0_BYCT_MASK
#define AVR32_USBB_UESTAX_BYCT_OFFSET                       AVR32_USBB_UESTA0_BYCT_OFFSET
#define AVR32_USBB_UESTAX_BYCT_SIZE                         AVR32_USBB_UESTA0_BYCT_SIZE
#define AVR32_USBB_UESTAX_CFGOK                             AVR32_USBB_UESTA0_CFGOK
#define AVR32_USBB_UESTAX_CFGOK_MASK                        AVR32_USBB_UESTA0_CFGOK_MASK
#define AVR32_USBB_UESTAX_CFGOK_OFFSET                      AVR32_USBB_UESTA0_CFGOK_OFFSET
#define AVR32_USBB_UESTAX_CFGOK_SIZE                        AVR32_USBB_UESTA0_CFGOK_SIZE
#define AVR32_USBB_UESTAX_CTRLDIR                           AVR32_USBB_UESTA0_CTRLDIR
#define AVR32_USBB_UESTAX_CTRLDIR_IN                        AVR32_USBB_UESTA0_CTRLDIR_IN
#define AVR32_USBB_UESTAX_CTRLDIR_MASK                      AVR32_USBB_UESTA0_CTRLDIR_MASK
#define AVR32_USBB_UESTAX_CTRLDIR_OFFSET                    AVR32_USBB_UESTA0_CTRLDIR_OFFSET
#define AVR32_USBB_UESTAX_CTRLDIR_OUT                       AVR32_USBB_UESTA0_CTRLDIR_OUT
#define AVR32_USBB_UESTAX_CTRLDIR_SIZE                      AVR32_USBB_UESTA0_CTRLDIR_SIZE
#define AVR32_USBB_UESTAX_CURRBK                            AVR32_USBB_UESTA0_CURRBK
#define AVR32_USBB_UESTAX_CURRBK_MASK                       AVR32_USBB_UESTA0_CURRBK_MASK
#define AVR32_USBB_UESTAX_CURRBK_OFFSET                     AVR32_USBB_UESTA0_CURRBK_OFFSET
#define AVR32_USBB_UESTAX_CURRBK_SIZE                       AVR32_USBB_UESTA0_CURRBK_SIZE
#define AVR32_USBB_UESTAX_DTSEQ                             AVR32_USBB_UESTA0_DTSEQ
#define AVR32_USBB_UESTAX_DTSEQ_MASK                        AVR32_USBB_UESTA0_DTSEQ_MASK
#define AVR32_USBB_UESTAX_DTSEQ_OFFSET                      AVR32_USBB_UESTA0_DTSEQ_OFFSET
#define AVR32_USBB_UESTAX_DTSEQ_SIZE                        AVR32_USBB_UESTA0_DTSEQ_SIZE
#define AVR32_USBB_UESTAX_NAKINI                            AVR32_USBB_UESTA0_NAKINI
#define AVR32_USBB_UESTAX_NAKINI_MASK                       AVR32_USBB_UESTA0_NAKINI_MASK
#define AVR32_USBB_UESTAX_NAKINI_OFFSET                     AVR32_USBB_UESTA0_NAKINI_OFFSET
#define AVR32_USBB_UESTAX_NAKINI_SIZE                       AVR32_USBB_UESTA0_NAKINI_SIZE
#define AVR32_USBB_UESTAX_NAKOUTI                           AVR32_USBB_UESTA0_NAKOUTI
#define AVR32_USBB_UESTAX_NAKOUTI_MASK                      AVR32_USBB_UESTA0_NAKOUTI_MASK
#define AVR32_USBB_UESTAX_NAKOUTI_OFFSET                    AVR32_USBB_UESTA0_NAKOUTI_OFFSET
#define AVR32_USBB_UESTAX_NAKOUTI_SIZE                      AVR32_USBB_UESTA0_NAKOUTI_SIZE
#define AVR32_USBB_UESTAX_NBUSYBK                           AVR32_USBB_UESTA0_NBUSYBK
#define AVR32_USBB_UESTAX_NBUSYBK_MASK                      AVR32_USBB_UESTA0_NBUSYBK_MASK
#define AVR32_USBB_UESTAX_NBUSYBK_OFFSET                    AVR32_USBB_UESTA0_NBUSYBK_OFFSET
#define AVR32_USBB_UESTAX_NBUSYBK_SIZE                      AVR32_USBB_UESTA0_NBUSYBK_SIZE
#define AVR32_USBB_UESTAX_OVERFI                            AVR32_USBB_UESTA0_OVERFI
#define AVR32_USBB_UESTAX_OVERFI_MASK                       AVR32_USBB_UESTA0_OVERFI_MASK
#define AVR32_USBB_UESTAX_OVERFI_OFFSET                     AVR32_USBB_UESTA0_OVERFI_OFFSET
#define AVR32_USBB_UESTAX_OVERFI_SIZE                       AVR32_USBB_UESTA0_OVERFI_SIZE
#define AVR32_USBB_UESTAX_RWALL                             AVR32_USBB_UESTA0_RWALL
#define AVR32_USBB_UESTAX_RWALL_MASK                        AVR32_USBB_UESTA0_RWALL_MASK
#define AVR32_USBB_UESTAX_RWALL_OFFSET                      AVR32_USBB_UESTA0_RWALL_OFFSET
#define AVR32_USBB_UESTAX_RWALL_SIZE                        AVR32_USBB_UESTA0_RWALL_SIZE
#define AVR32_USBB_UESTAX_RXOUTI                            AVR32_USBB_UESTA0_RXOUTI
#define AVR32_USBB_UESTAX_RXOUTI_MASK                       AVR32_USBB_UESTA0_RXOUTI_MASK
#define AVR32_USBB_UESTAX_RXOUTI_OFFSET                     AVR32_USBB_UESTA0_RXOUTI_OFFSET
#define AVR32_USBB_UESTAX_RXOUTI_SIZE                       AVR32_USBB_UESTA0_RXOUTI_SIZE
#define AVR32_USBB_UESTAX_RXSTPI                            AVR32_USBB_UESTA0_RXSTPI
#define AVR32_USBB_UESTAX_RXSTPI_MASK                       AVR32_USBB_UESTA0_RXSTPI_MASK
#define AVR32_USBB_UESTAX_RXSTPI_OFFSET                     AVR32_USBB_UESTA0_RXSTPI_OFFSET
#define AVR32_USBB_UESTAX_RXSTPI_SIZE                       AVR32_USBB_UESTA0_RXSTPI_SIZE
#define AVR32_USBB_UESTAX_SHORTPACKET                       AVR32_USBB_UESTA0_SHORTPACKET
#define AVR32_USBB_UESTAX_SHORTPACKET_MASK                  AVR32_USBB_UESTA0_SHORTPACKET_MASK
#define AVR32_USBB_UESTAX_SHORTPACKET_OFFSET                AVR32_USBB_UESTA0_SHORTPACKET_OFFSET
#define AVR32_USBB_UESTAX_SHORTPACKET_SIZE                  AVR32_USBB_UESTA0_SHORTPACKET_SIZE
#define AVR32_USBB_UESTAX_STALLEDI                          AVR32_USBB_UESTA0_STALLEDI
#define AVR32_USBB_UESTAX_STALLEDI_MASK                     AVR32_USBB_UESTA0_STALLEDI_MASK
#define AVR32_USBB_UESTAX_STALLEDI_OFFSET                   AVR32_USBB_UESTA0_STALLEDI_OFFSET
#define AVR32_USBB_UESTAX_STALLEDI_SIZE                     AVR32_USBB_UESTA0_STALLEDI_SIZE
#define AVR32_USBB_UESTAX_TXINI                             AVR32_USBB_UESTA0_TXINI
#define AVR32_USBB_UESTAX_TXINI_MASK                        AVR32_USBB_UESTA0_TXINI_MASK
#define AVR32_USBB_UESTAX_TXINI_OFFSET                      AVR32_USBB_UESTA0_TXINI_OFFSET
#define AVR32_USBB_UESTAX_TXINI_SIZE                        AVR32_USBB_UESTA0_TXINI_SIZE
#define AVR32_USBB_UNAMEX                                   AVR32_USBB_UNAME1
#define AVR32_USBB_UNAMEX_MASK                              AVR32_USBB_UNAME1_MASK
#define AVR32_USBB_UNAMEX_OFFSET                            AVR32_USBB_UNAME1_OFFSET
#define AVR32_USBB_UNAMEX_SIZE                              AVR32_USBB_UNAME1_SIZE
#define AVR32_USBB_UNAMEX_UNAMEX                            AVR32_USBB_UNAME1_UNAME1
#define AVR32_USBB_UNAMEX_UNAMEX_MASK                       AVR32_USBB_UNAME1_UNAME1_MASK
#define AVR32_USBB_UNAMEX_UNAMEX_OFFSET                     AVR32_USBB_UNAME1_UNAME1_OFFSET
#define AVR32_USBB_UNAMEX_UNAMEX_SIZE                       AVR32_USBB_UNAME1_UNAME1_SIZE
#define AVR32_USBB_UPCFGX                                   AVR32_USBB_UPCFG0
#define AVR32_USBB_UPCFGX_ALLOC                             AVR32_USBB_UPCFG0_ALLOC
#define AVR32_USBB_UPCFGX_ALLOC_MASK                        AVR32_USBB_UPCFG0_ALLOC_MASK
#define AVR32_USBB_UPCFGX_ALLOC_OFFSET                      AVR32_USBB_UPCFG0_ALLOC_OFFSET
#define AVR32_USBB_UPCFGX_ALLOC_SIZE                        AVR32_USBB_UPCFG0_ALLOC_SIZE
#define AVR32_USBB_UPCFGX_AUTOSW                            AVR32_USBB_UPCFG0_AUTOSW
#define AVR32_USBB_UPCFGX_AUTOSW_MASK                       AVR32_USBB_UPCFG0_AUTOSW_MASK
#define AVR32_USBB_UPCFGX_AUTOSW_OFFSET                     AVR32_USBB_UPCFG0_AUTOSW_OFFSET
#define AVR32_USBB_UPCFGX_AUTOSW_SIZE                       AVR32_USBB_UPCFG0_AUTOSW_SIZE
#define AVR32_USBB_UPCFGX_INTFRQ                            AVR32_USBB_UPCFG0_INTFRQ
#define AVR32_USBB_UPCFGX_INTFRQ_MASK                       AVR32_USBB_UPCFG0_INTFRQ_MASK
#define AVR32_USBB_UPCFGX_INTFRQ_OFFSET                     AVR32_USBB_UPCFG0_INTFRQ_OFFSET
#define AVR32_USBB_UPCFGX_INTFRQ_SIZE                       AVR32_USBB_UPCFG0_INTFRQ_SIZE
#define AVR32_USBB_UPCFGX_PBK                               AVR32_USBB_UPCFG0_PBK
#define AVR32_USBB_UPCFGX_PBK_DOUBLE                        AVR32_USBB_UPCFG0_PBK_DOUBLE
#define AVR32_USBB_UPCFGX_PBK_MASK                          AVR32_USBB_UPCFG0_PBK_MASK
#define AVR32_USBB_UPCFGX_PBK_OFFSET                        AVR32_USBB_UPCFG0_PBK_OFFSET
#define AVR32_USBB_UPCFGX_PBK_SINGLE                        AVR32_USBB_UPCFG0_PBK_SINGLE
#define AVR32_USBB_UPCFGX_PBK_SIZE                          AVR32_USBB_UPCFG0_PBK_SIZE
#define AVR32_USBB_UPCFGX_PBK_TRIPLE                        AVR32_USBB_UPCFG0_PBK_TRIPLE
#define AVR32_USBB_UPCFGX_PEPNUM                            AVR32_USBB_UPCFG0_PEPNUM
#define AVR32_USBB_UPCFGX_PEPNUM_MASK                       AVR32_USBB_UPCFG0_PEPNUM_MASK
#define AVR32_USBB_UPCFGX_PEPNUM_OFFSET                     AVR32_USBB_UPCFG0_PEPNUM_OFFSET
#define AVR32_USBB_UPCFGX_PEPNUM_SIZE                       AVR32_USBB_UPCFG0_PEPNUM_SIZE
#define AVR32_USBB_UPCFGX_PINGEN                            AVR32_USBB_UPCFG0_PINGEN
#define AVR32_USBB_UPCFGX_PINGEN_MASK                       AVR32_USBB_UPCFG0_PINGEN_MASK
#define AVR32_USBB_UPCFGX_PINGEN_OFFSET                     AVR32_USBB_UPCFG0_PINGEN_OFFSET
#define AVR32_USBB_UPCFGX_PINGEN_SIZE                       AVR32_USBB_UPCFG0_PINGEN_SIZE
#define AVR32_USBB_UPCFGX_PSIZE                             AVR32_USBB_UPCFG0_PSIZE
#define AVR32_USBB_UPCFGX_PSIZE_1024                        AVR32_USBB_UPCFG0_PSIZE_1024
#define AVR32_USBB_UPCFGX_PSIZE_128                         AVR32_USBB_UPCFG0_PSIZE_128
#define AVR32_USBB_UPCFGX_PSIZE_16                          AVR32_USBB_UPCFG0_PSIZE_16
#define AVR32_USBB_UPCFGX_PSIZE_256                         AVR32_USBB_UPCFG0_PSIZE_256
#define AVR32_USBB_UPCFGX_PSIZE_32                          AVR32_USBB_UPCFG0_PSIZE_32
#define AVR32_USBB_UPCFGX_PSIZE_512                         AVR32_USBB_UPCFG0_PSIZE_512
#define AVR32_USBB_UPCFGX_PSIZE_64                          AVR32_USBB_UPCFG0_PSIZE_64
#define AVR32_USBB_UPCFGX_PSIZE_8                           AVR32_USBB_UPCFG0_PSIZE_8
#define AVR32_USBB_UPCFGX_PSIZE_MASK                        AVR32_USBB_UPCFG0_PSIZE_MASK
#define AVR32_USBB_UPCFGX_PSIZE_OFFSET                      AVR32_USBB_UPCFG0_PSIZE_OFFSET
#define AVR32_USBB_UPCFGX_PSIZE_SIZE                        AVR32_USBB_UPCFG0_PSIZE_SIZE
#define AVR32_USBB_UPCFGX_PTOKEN                            AVR32_USBB_UPCFG0_PTOKEN
#define AVR32_USBB_UPCFGX_PTOKEN_IN                         AVR32_USBB_UPCFG0_PTOKEN_IN
#define AVR32_USBB_UPCFGX_PTOKEN_MASK                       AVR32_USBB_UPCFG0_PTOKEN_MASK
#define AVR32_USBB_UPCFGX_PTOKEN_OFFSET                     AVR32_USBB_UPCFG0_PTOKEN_OFFSET
#define AVR32_USBB_UPCFGX_PTOKEN_OUT                        AVR32_USBB_UPCFG0_PTOKEN_OUT
#define AVR32_USBB_UPCFGX_PTOKEN_SETUP                      AVR32_USBB_UPCFG0_PTOKEN_SETUP
#define AVR32_USBB_UPCFGX_PTOKEN_SIZE                       AVR32_USBB_UPCFG0_PTOKEN_SIZE
#define AVR32_USBB_UPCFGX_PTYPE                             AVR32_USBB_UPCFG0_PTYPE
#define AVR32_USBB_UPCFGX_PTYPE_BULK                        AVR32_USBB_UPCFG0_PTYPE_BULK
#define AVR32_USBB_UPCFGX_PTYPE_CONTROL                     AVR32_USBB_UPCFG0_PTYPE_CONTROL
#define AVR32_USBB_UPCFGX_PTYPE_INTERRUPT                   AVR32_USBB_UPCFG0_PTYPE_INTERRUPT
#define AVR32_USBB_UPCFGX_PTYPE_ISOCHRONOUS                 AVR32_USBB_UPCFG0_PTYPE_ISOCHRONOUS
#define AVR32_USBB_UPCFGX_PTYPE_MASK                        AVR32_USBB_UPCFG0_PTYPE_MASK
#define AVR32_USBB_UPCFGX_PTYPE_OFFSET                      AVR32_USBB_UPCFG0_PTYPE_OFFSET
#define AVR32_USBB_UPCFGX_PTYPE_SIZE                        AVR32_USBB_UPCFG0_PTYPE_SIZE
#define AVR32_USBB_UPCONX                                   AVR32_USBB_UPCON0
#define AVR32_USBB_UPCONXCLR                                AVR32_USBB_UPCON0CLR
#define AVR32_USBB_UPCONXCLR_FIFOCONC                       AVR32_USBB_UPCON0CLR_FIFOCONC
#define AVR32_USBB_UPCONXCLR_FIFOCONC_MASK                  AVR32_USBB_UPCON0CLR_FIFOCONC_MASK
#define AVR32_USBB_UPCONXCLR_FIFOCONC_OFFSET                AVR32_USBB_UPCON0CLR_FIFOCONC_OFFSET
#define AVR32_USBB_UPCONXCLR_FIFOCONC_SIZE                  AVR32_USBB_UPCON0CLR_FIFOCONC_SIZE
#define AVR32_USBB_UPCONXCLR_NAKEDEC                        AVR32_USBB_UPCON0CLR_NAKEDEC
#define AVR32_USBB_UPCONXCLR_NAKEDEC_MASK                   AVR32_USBB_UPCON0CLR_NAKEDEC_MASK
#define AVR32_USBB_UPCONXCLR_NAKEDEC_OFFSET                 AVR32_USBB_UPCON0CLR_NAKEDEC_OFFSET
#define AVR32_USBB_UPCONXCLR_NAKEDEC_SIZE                   AVR32_USBB_UPCON0CLR_NAKEDEC_SIZE
#define AVR32_USBB_UPCONXCLR_NBUSYBKEC                      AVR32_USBB_UPCON0CLR_NBUSYBKEC
#define AVR32_USBB_UPCONXCLR_NBUSYBKEC_MASK                 AVR32_USBB_UPCON0CLR_NBUSYBKEC_MASK
#define AVR32_USBB_UPCONXCLR_NBUSYBKEC_OFFSET               AVR32_USBB_UPCON0CLR_NBUSYBKEC_OFFSET
#define AVR32_USBB_UPCONXCLR_NBUSYBKEC_SIZE                 AVR32_USBB_UPCON0CLR_NBUSYBKEC_SIZE
#define AVR32_USBB_UPCONXCLR_OVERFIEC                       AVR32_USBB_UPCON0CLR_OVERFIEC
#define AVR32_USBB_UPCONXCLR_OVERFIEC_MASK                  AVR32_USBB_UPCON0CLR_OVERFIEC_MASK
#define AVR32_USBB_UPCONXCLR_OVERFIEC_OFFSET                AVR32_USBB_UPCON0CLR_OVERFIEC_OFFSET
#define AVR32_USBB_UPCONXCLR_OVERFIEC_SIZE                  AVR32_USBB_UPCON0CLR_OVERFIEC_SIZE
#define AVR32_USBB_UPCONXCLR_PDISHDMAC                      AVR32_USBB_UPCON0CLR_PDISHDMAC
#define AVR32_USBB_UPCONXCLR_PDISHDMAC_MASK                 AVR32_USBB_UPCON0CLR_PDISHDMAC_MASK
#define AVR32_USBB_UPCONXCLR_PDISHDMAC_OFFSET               AVR32_USBB_UPCON0CLR_PDISHDMAC_OFFSET
#define AVR32_USBB_UPCONXCLR_PDISHDMAC_SIZE                 AVR32_USBB_UPCON0CLR_PDISHDMAC_SIZE
#define AVR32_USBB_UPCONXCLR_PERREC                         AVR32_USBB_UPCON0CLR_PERREC
#define AVR32_USBB_UPCONXCLR_PERREC_MASK                    AVR32_USBB_UPCON0CLR_PERREC_MASK
#define AVR32_USBB_UPCONXCLR_PERREC_OFFSET                  AVR32_USBB_UPCON0CLR_PERREC_OFFSET
#define AVR32_USBB_UPCONXCLR_PERREC_SIZE                    AVR32_USBB_UPCON0CLR_PERREC_SIZE
#define AVR32_USBB_UPCONXCLR_PFREEZEC                       AVR32_USBB_UPCON0CLR_PFREEZEC
#define AVR32_USBB_UPCONXCLR_PFREEZEC_MASK                  AVR32_USBB_UPCON0CLR_PFREEZEC_MASK
#define AVR32_USBB_UPCONXCLR_PFREEZEC_OFFSET                AVR32_USBB_UPCON0CLR_PFREEZEC_OFFSET
#define AVR32_USBB_UPCONXCLR_PFREEZEC_SIZE                  AVR32_USBB_UPCON0CLR_PFREEZEC_SIZE
#define AVR32_USBB_UPCONXCLR_RXINEC                         AVR32_USBB_UPCON0CLR_RXINEC
#define AVR32_USBB_UPCONXCLR_RXINEC_MASK                    AVR32_USBB_UPCON0CLR_RXINEC_MASK
#define AVR32_USBB_UPCONXCLR_RXINEC_OFFSET                  AVR32_USBB_UPCON0CLR_RXINEC_OFFSET
#define AVR32_USBB_UPCONXCLR_RXINEC_SIZE                    AVR32_USBB_UPCON0CLR_RXINEC_SIZE
#define AVR32_USBB_UPCONXCLR_RXSTALLDEC                     AVR32_USBB_UPCON0CLR_RXSTALLDEC
#define AVR32_USBB_UPCONXCLR_RXSTALLDEC_MASK                AVR32_USBB_UPCON0CLR_RXSTALLDEC_MASK
#define AVR32_USBB_UPCONXCLR_RXSTALLDEC_OFFSET              AVR32_USBB_UPCON0CLR_RXSTALLDEC_OFFSET
#define AVR32_USBB_UPCONXCLR_RXSTALLDEC_SIZE                AVR32_USBB_UPCON0CLR_RXSTALLDEC_SIZE
#define AVR32_USBB_UPCONXCLR_SHORTPACKETIEC                 AVR32_USBB_UPCON0CLR_SHORTPACKETIEC
#define AVR32_USBB_UPCONXCLR_SHORTPACKETIEC_MASK            AVR32_USBB_UPCON0CLR_SHORTPACKETIEC_MASK
#define AVR32_USBB_UPCONXCLR_SHORTPACKETIEC_OFFSET          AVR32_USBB_UPCON0CLR_SHORTPACKETIEC_OFFSET
#define AVR32_USBB_UPCONXCLR_SHORTPACKETIEC_SIZE            AVR32_USBB_UPCON0CLR_SHORTPACKETIEC_SIZE
#define AVR32_USBB_UPCONXCLR_TXOUTEC                        AVR32_USBB_UPCON0CLR_TXOUTEC
#define AVR32_USBB_UPCONXCLR_TXOUTEC_MASK                   AVR32_USBB_UPCON0CLR_TXOUTEC_MASK
#define AVR32_USBB_UPCONXCLR_TXOUTEC_OFFSET                 AVR32_USBB_UPCON0CLR_TXOUTEC_OFFSET
#define AVR32_USBB_UPCONXCLR_TXOUTEC_SIZE                   AVR32_USBB_UPCON0CLR_TXOUTEC_SIZE
#define AVR32_USBB_UPCONXCLR_TXSTPEC                        AVR32_USBB_UPCON0CLR_TXSTPEC
#define AVR32_USBB_UPCONXCLR_TXSTPEC_MASK                   AVR32_USBB_UPCON0CLR_TXSTPEC_MASK
#define AVR32_USBB_UPCONXCLR_TXSTPEC_OFFSET                 AVR32_USBB_UPCON0CLR_TXSTPEC_OFFSET
#define AVR32_USBB_UPCONXCLR_TXSTPEC_SIZE                   AVR32_USBB_UPCON0CLR_TXSTPEC_SIZE
#define AVR32_USBB_UPCONXSET                                AVR32_USBB_UPCON0SET
#define AVR32_USBB_UPCONXSET_NAKEDES                        AVR32_USBB_UPCON0SET_NAKEDES
#define AVR32_USBB_UPCONXSET_NAKEDES_MASK                   AVR32_USBB_UPCON0SET_NAKEDES_MASK
#define AVR32_USBB_UPCONXSET_NAKEDES_OFFSET                 AVR32_USBB_UPCON0SET_NAKEDES_OFFSET
#define AVR32_USBB_UPCONXSET_NAKEDES_SIZE                   AVR32_USBB_UPCON0SET_NAKEDES_SIZE
#define AVR32_USBB_UPCONXSET_NBUSYBKES                      AVR32_USBB_UPCON0SET_NBUSYBKES
#define AVR32_USBB_UPCONXSET_NBUSYBKES_MASK                 AVR32_USBB_UPCON0SET_NBUSYBKES_MASK
#define AVR32_USBB_UPCONXSET_NBUSYBKES_OFFSET               AVR32_USBB_UPCON0SET_NBUSYBKES_OFFSET
#define AVR32_USBB_UPCONXSET_NBUSYBKES_SIZE                 AVR32_USBB_UPCON0SET_NBUSYBKES_SIZE
#define AVR32_USBB_UPCONXSET_OVERFIES                       AVR32_USBB_UPCON0SET_OVERFIES
#define AVR32_USBB_UPCONXSET_OVERFIES_MASK                  AVR32_USBB_UPCON0SET_OVERFIES_MASK
#define AVR32_USBB_UPCONXSET_OVERFIES_OFFSET                AVR32_USBB_UPCON0SET_OVERFIES_OFFSET
#define AVR32_USBB_UPCONXSET_OVERFIES_SIZE                  AVR32_USBB_UPCON0SET_OVERFIES_SIZE
#define AVR32_USBB_UPCONXSET_PDISHDMAS                      AVR32_USBB_UPCON0SET_PDISHDMAS
#define AVR32_USBB_UPCONXSET_PDISHDMAS_MASK                 AVR32_USBB_UPCON0SET_PDISHDMAS_MASK
#define AVR32_USBB_UPCONXSET_PDISHDMAS_OFFSET               AVR32_USBB_UPCON0SET_PDISHDMAS_OFFSET
#define AVR32_USBB_UPCONXSET_PDISHDMAS_SIZE                 AVR32_USBB_UPCON0SET_PDISHDMAS_SIZE
#define AVR32_USBB_UPCONXSET_PERRES                         AVR32_USBB_UPCON0SET_PERRES
#define AVR32_USBB_UPCONXSET_PERRES_MASK                    AVR32_USBB_UPCON0SET_PERRES_MASK
#define AVR32_USBB_UPCONXSET_PERRES_OFFSET                  AVR32_USBB_UPCON0SET_PERRES_OFFSET
#define AVR32_USBB_UPCONXSET_PERRES_SIZE                    AVR32_USBB_UPCON0SET_PERRES_SIZE
#define AVR32_USBB_UPCONXSET_PFREEZES                       AVR32_USBB_UPCON0SET_PFREEZES
#define AVR32_USBB_UPCONXSET_PFREEZES_MASK                  AVR32_USBB_UPCON0SET_PFREEZES_MASK
#define AVR32_USBB_UPCONXSET_PFREEZES_OFFSET                AVR32_USBB_UPCON0SET_PFREEZES_OFFSET
#define AVR32_USBB_UPCONXSET_PFREEZES_SIZE                  AVR32_USBB_UPCON0SET_PFREEZES_SIZE
#define AVR32_USBB_UPCONXSET_RSTDTS                         AVR32_USBB_UPCON0SET_RSTDTS
#define AVR32_USBB_UPCONXSET_RSTDTS_MASK                    AVR32_USBB_UPCON0SET_RSTDTS_MASK
#define AVR32_USBB_UPCONXSET_RSTDTS_OFFSET                  AVR32_USBB_UPCON0SET_RSTDTS_OFFSET
#define AVR32_USBB_UPCONXSET_RSTDTS_SIZE                    AVR32_USBB_UPCON0SET_RSTDTS_SIZE
#define AVR32_USBB_UPCONXSET_RXINES                         AVR32_USBB_UPCON0SET_RXINES
#define AVR32_USBB_UPCONXSET_RXINES_MASK                    AVR32_USBB_UPCON0SET_RXINES_MASK
#define AVR32_USBB_UPCONXSET_RXINES_OFFSET                  AVR32_USBB_UPCON0SET_RXINES_OFFSET
#define AVR32_USBB_UPCONXSET_RXINES_SIZE                    AVR32_USBB_UPCON0SET_RXINES_SIZE
#define AVR32_USBB_UPCONXSET_RXSTALLDES                     AVR32_USBB_UPCON0SET_RXSTALLDES
#define AVR32_USBB_UPCONXSET_RXSTALLDES_MASK                AVR32_USBB_UPCON0SET_RXSTALLDES_MASK
#define AVR32_USBB_UPCONXSET_RXSTALLDES_OFFSET              AVR32_USBB_UPCON0SET_RXSTALLDES_OFFSET
#define AVR32_USBB_UPCONXSET_RXSTALLDES_SIZE                AVR32_USBB_UPCON0SET_RXSTALLDES_SIZE
#define AVR32_USBB_UPCONXSET_SHORTPACKETIES                 AVR32_USBB_UPCON0SET_SHORTPACKETIES
#define AVR32_USBB_UPCONXSET_SHORTPACKETIES_MASK            AVR32_USBB_UPCON0SET_SHORTPACKETIES_MASK
#define AVR32_USBB_UPCONXSET_SHORTPACKETIES_OFFSET          AVR32_USBB_UPCON0SET_SHORTPACKETIES_OFFSET
#define AVR32_USBB_UPCONXSET_SHORTPACKETIES_SIZE            AVR32_USBB_UPCON0SET_SHORTPACKETIES_SIZE
#define AVR32_USBB_UPCONXSET_TXOUTES                        AVR32_USBB_UPCON0SET_TXOUTES
#define AVR32_USBB_UPCONXSET_TXOUTES_MASK                   AVR32_USBB_UPCON0SET_TXOUTES_MASK
#define AVR32_USBB_UPCONXSET_TXOUTES_OFFSET                 AVR32_USBB_UPCON0SET_TXOUTES_OFFSET
#define AVR32_USBB_UPCONXSET_TXOUTES_SIZE                   AVR32_USBB_UPCON0SET_TXOUTES_SIZE
#define AVR32_USBB_UPCONXSET_TXSTPES                        AVR32_USBB_UPCON0SET_TXSTPES
#define AVR32_USBB_UPCONXSET_TXSTPES_MASK                   AVR32_USBB_UPCON0SET_TXSTPES_MASK
#define AVR32_USBB_UPCONXSET_TXSTPES_OFFSET                 AVR32_USBB_UPCON0SET_TXSTPES_OFFSET
#define AVR32_USBB_UPCONXSET_TXSTPES_SIZE                   AVR32_USBB_UPCON0SET_TXSTPES_SIZE
#define AVR32_USBB_UPCONX_FIFOCON                           AVR32_USBB_UPCON0_FIFOCON
#define AVR32_USBB_UPCONX_FIFOCON_MASK                      AVR32_USBB_UPCON0_FIFOCON_MASK
#define AVR32_USBB_UPCONX_FIFOCON_OFFSET                    AVR32_USBB_UPCON0_FIFOCON_OFFSET
#define AVR32_USBB_UPCONX_FIFOCON_SIZE                      AVR32_USBB_UPCON0_FIFOCON_SIZE
#define AVR32_USBB_UPCONX_NAKEDE                            AVR32_USBB_UPCON0_NAKEDE
#define AVR32_USBB_UPCONX_NAKEDE_MASK                       AVR32_USBB_UPCON0_NAKEDE_MASK
#define AVR32_USBB_UPCONX_NAKEDE_OFFSET                     AVR32_USBB_UPCON0_NAKEDE_OFFSET
#define AVR32_USBB_UPCONX_NAKEDE_SIZE                       AVR32_USBB_UPCON0_NAKEDE_SIZE
#define AVR32_USBB_UPCONX_NBUSYBKE                          AVR32_USBB_UPCON0_NBUSYBKE
#define AVR32_USBB_UPCONX_NBUSYBKE_MASK                     AVR32_USBB_UPCON0_NBUSYBKE_MASK
#define AVR32_USBB_UPCONX_NBUSYBKE_OFFSET                   AVR32_USBB_UPCON0_NBUSYBKE_OFFSET
#define AVR32_USBB_UPCONX_NBUSYBKE_SIZE                     AVR32_USBB_UPCON0_NBUSYBKE_SIZE
#define AVR32_USBB_UPCONX_OVERFIE                           AVR32_USBB_UPCON0_OVERFIE
#define AVR32_USBB_UPCONX_OVERFIE_MASK                      AVR32_USBB_UPCON0_OVERFIE_MASK
#define AVR32_USBB_UPCONX_OVERFIE_OFFSET                    AVR32_USBB_UPCON0_OVERFIE_OFFSET
#define AVR32_USBB_UPCONX_OVERFIE_SIZE                      AVR32_USBB_UPCON0_OVERFIE_SIZE
#define AVR32_USBB_UPCONX_PDISHDMA                          AVR32_USBB_UPCON0_PDISHDMA
#define AVR32_USBB_UPCONX_PDISHDMA_MASK                     AVR32_USBB_UPCON0_PDISHDMA_MASK
#define AVR32_USBB_UPCONX_PDISHDMA_OFFSET                   AVR32_USBB_UPCON0_PDISHDMA_OFFSET
#define AVR32_USBB_UPCONX_PDISHDMA_SIZE                     AVR32_USBB_UPCON0_PDISHDMA_SIZE
#define AVR32_USBB_UPCONX_PERRE                             AVR32_USBB_UPCON0_PERRE
#define AVR32_USBB_UPCONX_PERRE_MASK                        AVR32_USBB_UPCON0_PERRE_MASK
#define AVR32_USBB_UPCONX_PERRE_OFFSET                      AVR32_USBB_UPCON0_PERRE_OFFSET
#define AVR32_USBB_UPCONX_PERRE_SIZE                        AVR32_USBB_UPCON0_PERRE_SIZE
#define AVR32_USBB_UPCONX_PFREEZE                           AVR32_USBB_UPCON0_PFREEZE
#define AVR32_USBB_UPCONX_PFREEZE_MASK                      AVR32_USBB_UPCON0_PFREEZE_MASK
#define AVR32_USBB_UPCONX_PFREEZE_OFFSET                    AVR32_USBB_UPCON0_PFREEZE_OFFSET
#define AVR32_USBB_UPCONX_PFREEZE_SIZE                      AVR32_USBB_UPCON0_PFREEZE_SIZE
#define AVR32_USBB_UPCONX_RSTDT                             AVR32_USBB_UPCON0_RSTDT
#define AVR32_USBB_UPCONX_RSTDT_MASK                        AVR32_USBB_UPCON0_RSTDT_MASK
#define AVR32_USBB_UPCONX_RSTDT_OFFSET                      AVR32_USBB_UPCON0_RSTDT_OFFSET
#define AVR32_USBB_UPCONX_RSTDT_SIZE                        AVR32_USBB_UPCON0_RSTDT_SIZE
#define AVR32_USBB_UPCONX_RXINE                             AVR32_USBB_UPCON0_RXINE
#define AVR32_USBB_UPCONX_RXINE_MASK                        AVR32_USBB_UPCON0_RXINE_MASK
#define AVR32_USBB_UPCONX_RXINE_OFFSET                      AVR32_USBB_UPCON0_RXINE_OFFSET
#define AVR32_USBB_UPCONX_RXINE_SIZE                        AVR32_USBB_UPCON0_RXINE_SIZE
#define AVR32_USBB_UPCONX_RXSTALLDE                         AVR32_USBB_UPCON0_RXSTALLDE
#define AVR32_USBB_UPCONX_RXSTALLDE_MASK                    AVR32_USBB_UPCON0_RXSTALLDE_MASK
#define AVR32_USBB_UPCONX_RXSTALLDE_OFFSET                  AVR32_USBB_UPCON0_RXSTALLDE_OFFSET
#define AVR32_USBB_UPCONX_RXSTALLDE_SIZE                    AVR32_USBB_UPCON0_RXSTALLDE_SIZE
#define AVR32_USBB_UPCONX_SHORTPACKETIE                     AVR32_USBB_UPCON0_SHORTPACKETIE
#define AVR32_USBB_UPCONX_SHORTPACKETIE_MASK                AVR32_USBB_UPCON0_SHORTPACKETIE_MASK
#define AVR32_USBB_UPCONX_SHORTPACKETIE_OFFSET              AVR32_USBB_UPCON0_SHORTPACKETIE_OFFSET
#define AVR32_USBB_UPCONX_SHORTPACKETIE_SIZE                AVR32_USBB_UPCON0_SHORTPACKETIE_SIZE
#define AVR32_USBB_UPCONX_TXOUTE                            AVR32_USBB_UPCON0_TXOUTE
#define AVR32_USBB_UPCONX_TXOUTE_MASK                       AVR32_USBB_UPCON0_TXOUTE_MASK
#define AVR32_USBB_UPCONX_TXOUTE_OFFSET                     AVR32_USBB_UPCON0_TXOUTE_OFFSET
#define AVR32_USBB_UPCONX_TXOUTE_SIZE                       AVR32_USBB_UPCON0_TXOUTE_SIZE
#define AVR32_USBB_UPCONX_TXSTPE                            AVR32_USBB_UPCON0_TXSTPE
#define AVR32_USBB_UPCONX_TXSTPE_MASK                       AVR32_USBB_UPCON0_TXSTPE_MASK
#define AVR32_USBB_UPCONX_TXSTPE_OFFSET                     AVR32_USBB_UPCON0_TXSTPE_OFFSET
#define AVR32_USBB_UPCONX_TXSTPE_SIZE                       AVR32_USBB_UPCON0_TXSTPE_SIZE
#define AVR32_USBB_UPERRX                                   AVR32_USBB_UPERR0
#define AVR32_USBB_UPERRX_COUNTER                           AVR32_USBB_UPERR0_COUNTER
#define AVR32_USBB_UPERRX_COUNTER_MASK                      AVR32_USBB_UPERR0_COUNTER_MASK
#define AVR32_USBB_UPERRX_COUNTER_OFFSET                    AVR32_USBB_UPERR0_COUNTER_OFFSET
#define AVR32_USBB_UPERRX_COUNTER_SIZE                      AVR32_USBB_UPERR0_COUNTER_SIZE
#define AVR32_USBB_UPERRX_CRC16                             AVR32_USBB_UPERR0_CRC16
#define AVR32_USBB_UPERRX_CRC16_MASK                        AVR32_USBB_UPERR0_CRC16_MASK
#define AVR32_USBB_UPERRX_CRC16_OFFSET                      AVR32_USBB_UPERR0_CRC16_OFFSET
#define AVR32_USBB_UPERRX_CRC16_SIZE                        AVR32_USBB_UPERR0_CRC16_SIZE
#define AVR32_USBB_UPERRX_DATATGL                           AVR32_USBB_UPERR0_DATATGL
#define AVR32_USBB_UPERRX_DATATGL_MASK                      AVR32_USBB_UPERR0_DATATGL_MASK
#define AVR32_USBB_UPERRX_DATATGL_OFFSET                    AVR32_USBB_UPERR0_DATATGL_OFFSET
#define AVR32_USBB_UPERRX_DATATGL_SIZE                      AVR32_USBB_UPERR0_DATATGL_SIZE
#define AVR32_USBB_UPERRX_DATAPID                           AVR32_USBB_UPERR0_DATAPID
#define AVR32_USBB_UPERRX_DATAPID_MASK                      AVR32_USBB_UPERR0_DATAPID_MASK
#define AVR32_USBB_UPERRX_DATAPID_OFFSET                    AVR32_USBB_UPERR0_DATAPID_OFFSET
#define AVR32_USBB_UPERRX_DATAPID_SIZE                      AVR32_USBB_UPERR0_DATAPID_SIZE
#define AVR32_USBB_UPERRX_PID                               AVR32_USBB_UPERR0_PID
#define AVR32_USBB_UPERRX_PID_MASK                          AVR32_USBB_UPERR0_PID_MASK
#define AVR32_USBB_UPERRX_PID_OFFSET                        AVR32_USBB_UPERR0_PID_OFFSET
#define AVR32_USBB_UPERRX_PID_SIZE                          AVR32_USBB_UPERR0_PID_SIZE
#define AVR32_USBB_UPERRX_TIMEOUT                           AVR32_USBB_UPERR0_TIMEOUT
#define AVR32_USBB_UPERRX_TIMEOUT_MASK                      AVR32_USBB_UPERR0_TIMEOUT_MASK
#define AVR32_USBB_UPERRX_TIMEOUT_OFFSET                    AVR32_USBB_UPERR0_TIMEOUT_OFFSET
#define AVR32_USBB_UPERRX_TIMEOUT_SIZE                      AVR32_USBB_UPERR0_TIMEOUT_SIZE
#define AVR32_USBB_UPINRQX                                  AVR32_USBB_UPINRQ0
#define AVR32_USBB_UPINRQX_INMODE                           AVR32_USBB_UPINRQ0_INMODE
#define AVR32_USBB_UPINRQX_INMODE_MASK                      AVR32_USBB_UPINRQ0_INMODE_MASK
#define AVR32_USBB_UPINRQX_INMODE_OFFSET                    AVR32_USBB_UPINRQ0_INMODE_OFFSET
#define AVR32_USBB_UPINRQX_INMODE_SIZE                      AVR32_USBB_UPINRQ0_INMODE_SIZE
#define AVR32_USBB_UPINRQX_INRQ                             AVR32_USBB_UPINRQ0_INRQ
#define AVR32_USBB_UPINRQX_INRQ_MASK                        AVR32_USBB_UPINRQ0_INRQ_MASK
#define AVR32_USBB_UPINRQX_INRQ_OFFSET                      AVR32_USBB_UPINRQ0_INRQ_OFFSET
#define AVR32_USBB_UPINRQX_INRQ_SIZE                        AVR32_USBB_UPINRQ0_INRQ_SIZE
#define AVR32_USBB_UPSTAX                                   AVR32_USBB_UPSTA0
#define AVR32_USBB_UPSTAXCLR                                AVR32_USBB_UPSTA0CLR
#define AVR32_USBB_UPSTAXCLR_NAKEDIC                        AVR32_USBB_UPSTA0CLR_NAKEDIC
#define AVR32_USBB_UPSTAXCLR_NAKEDIC_MASK                   AVR32_USBB_UPSTA0CLR_NAKEDIC_MASK
#define AVR32_USBB_UPSTAXCLR_NAKEDIC_OFFSET                 AVR32_USBB_UPSTA0CLR_NAKEDIC_OFFSET
#define AVR32_USBB_UPSTAXCLR_NAKEDIC_SIZE                   AVR32_USBB_UPSTA0CLR_NAKEDIC_SIZE
#define AVR32_USBB_UPSTAXCLR_OVERFIC                        AVR32_USBB_UPSTA0CLR_OVERFIC
#define AVR32_USBB_UPSTAXCLR_OVERFIC_MASK                   AVR32_USBB_UPSTA0CLR_OVERFIC_MASK
#define AVR32_USBB_UPSTAXCLR_OVERFIC_OFFSET                 AVR32_USBB_UPSTA0CLR_OVERFIC_OFFSET
#define AVR32_USBB_UPSTAXCLR_OVERFIC_SIZE                   AVR32_USBB_UPSTA0CLR_OVERFIC_SIZE
#define AVR32_USBB_UPSTAXCLR_RXINIC                         AVR32_USBB_UPSTA0CLR_RXINIC
#define AVR32_USBB_UPSTAXCLR_RXINIC_MASK                    AVR32_USBB_UPSTA0CLR_RXINIC_MASK
#define AVR32_USBB_UPSTAXCLR_RXINIC_OFFSET                  AVR32_USBB_UPSTA0CLR_RXINIC_OFFSET
#define AVR32_USBB_UPSTAXCLR_RXINIC_SIZE                    AVR32_USBB_UPSTA0CLR_RXINIC_SIZE
#define AVR32_USBB_UPSTAXCLR_RXSTALLDIC                     AVR32_USBB_UPSTA0CLR_RXSTALLDIC
#define AVR32_USBB_UPSTAXCLR_RXSTALLDIC_MASK                AVR32_USBB_UPSTA0CLR_RXSTALLDIC_MASK
#define AVR32_USBB_UPSTAXCLR_RXSTALLDIC_OFFSET              AVR32_USBB_UPSTA0CLR_RXSTALLDIC_OFFSET
#define AVR32_USBB_UPSTAXCLR_RXSTALLDIC_SIZE                AVR32_USBB_UPSTA0CLR_RXSTALLDIC_SIZE
#define AVR32_USBB_UPSTAXCLR_SHORTPACKETIC                  AVR32_USBB_UPSTA0CLR_SHORTPACKETIC
#define AVR32_USBB_UPSTAXCLR_SHORTPACKETIC_MASK             AVR32_USBB_UPSTA0CLR_SHORTPACKETIC_MASK
#define AVR32_USBB_UPSTAXCLR_SHORTPACKETIC_OFFSET           AVR32_USBB_UPSTA0CLR_SHORTPACKETIC_OFFSET
#define AVR32_USBB_UPSTAXCLR_SHORTPACKETIC_SIZE             AVR32_USBB_UPSTA0CLR_SHORTPACKETIC_SIZE
#define AVR32_USBB_UPSTAXCLR_TXOUTIC                        AVR32_USBB_UPSTA0CLR_TXOUTIC
#define AVR32_USBB_UPSTAXCLR_TXOUTIC_MASK                   AVR32_USBB_UPSTA0CLR_TXOUTIC_MASK
#define AVR32_USBB_UPSTAXCLR_TXOUTIC_OFFSET                 AVR32_USBB_UPSTA0CLR_TXOUTIC_OFFSET
#define AVR32_USBB_UPSTAXCLR_TXOUTIC_SIZE                   AVR32_USBB_UPSTA0CLR_TXOUTIC_SIZE
#define AVR32_USBB_UPSTAXCLR_TXSTPIC                        AVR32_USBB_UPSTA0CLR_TXSTPIC
#define AVR32_USBB_UPSTAXCLR_TXSTPIC_MASK                   AVR32_USBB_UPSTA0CLR_TXSTPIC_MASK
#define AVR32_USBB_UPSTAXCLR_TXSTPIC_OFFSET                 AVR32_USBB_UPSTA0CLR_TXSTPIC_OFFSET
#define AVR32_USBB_UPSTAXCLR_TXSTPIC_SIZE                   AVR32_USBB_UPSTA0CLR_TXSTPIC_SIZE
#define AVR32_USBB_UPSTAXSET                                AVR32_USBB_UPSTA0SET
#define AVR32_USBB_UPSTAXSET_NAKEDIS                        AVR32_USBB_UPSTA0SET_NAKEDIS
#define AVR32_USBB_UPSTAXSET_NAKEDIS_MASK                   AVR32_USBB_UPSTA0SET_NAKEDIS_MASK
#define AVR32_USBB_UPSTAXSET_NAKEDIS_OFFSET                 AVR32_USBB_UPSTA0SET_NAKEDIS_OFFSET
#define AVR32_USBB_UPSTAXSET_NAKEDIS_SIZE                   AVR32_USBB_UPSTA0SET_NAKEDIS_SIZE
#define AVR32_USBB_UPSTAXSET_NBUSYBKS                       AVR32_USBB_UPSTA0SET_NBUSYBKS
#define AVR32_USBB_UPSTAXSET_NBUSYBKS_MASK                  AVR32_USBB_UPSTA0SET_NBUSYBKS_MASK
#define AVR32_USBB_UPSTAXSET_NBUSYBKS_OFFSET                AVR32_USBB_UPSTA0SET_NBUSYBKS_OFFSET
#define AVR32_USBB_UPSTAXSET_NBUSYBKS_SIZE                  AVR32_USBB_UPSTA0SET_NBUSYBKS_SIZE
#define AVR32_USBB_UPSTAXSET_OVERFIS                        AVR32_USBB_UPSTA0SET_OVERFIS
#define AVR32_USBB_UPSTAXSET_OVERFIS_MASK                   AVR32_USBB_UPSTA0SET_OVERFIS_MASK
#define AVR32_USBB_UPSTAXSET_OVERFIS_OFFSET                 AVR32_USBB_UPSTA0SET_OVERFIS_OFFSET
#define AVR32_USBB_UPSTAXSET_OVERFIS_SIZE                   AVR32_USBB_UPSTA0SET_OVERFIS_SIZE
#define AVR32_USBB_UPSTAXSET_PERRIS                         AVR32_USBB_UPSTA0SET_PERRIS
#define AVR32_USBB_UPSTAXSET_PERRIS_MASK                    AVR32_USBB_UPSTA0SET_PERRIS_MASK
#define AVR32_USBB_UPSTAXSET_PERRIS_OFFSET                  AVR32_USBB_UPSTA0SET_PERRIS_OFFSET
#define AVR32_USBB_UPSTAXSET_PERRIS_SIZE                    AVR32_USBB_UPSTA0SET_PERRIS_SIZE
#define AVR32_USBB_UPSTAXSET_RXINIS                         AVR32_USBB_UPSTA0SET_RXINIS
#define AVR32_USBB_UPSTAXSET_RXINIS_MASK                    AVR32_USBB_UPSTA0SET_RXINIS_MASK
#define AVR32_USBB_UPSTAXSET_RXINIS_OFFSET                  AVR32_USBB_UPSTA0SET_RXINIS_OFFSET
#define AVR32_USBB_UPSTAXSET_RXINIS_SIZE                    AVR32_USBB_UPSTA0SET_RXINIS_SIZE
#define AVR32_USBB_UPSTAXSET_RXSTALLDIS                     AVR32_USBB_UPSTA0SET_RXSTALLDIS
#define AVR32_USBB_UPSTAXSET_RXSTALLDIS_MASK                AVR32_USBB_UPSTA0SET_RXSTALLDIS_MASK
#define AVR32_USBB_UPSTAXSET_RXSTALLDIS_OFFSET              AVR32_USBB_UPSTA0SET_RXSTALLDIS_OFFSET
#define AVR32_USBB_UPSTAXSET_RXSTALLDIS_SIZE                AVR32_USBB_UPSTA0SET_RXSTALLDIS_SIZE
#define AVR32_USBB_UPSTAXSET_SHORTPACKETIS                  AVR32_USBB_UPSTA0SET_SHORTPACKETIS
#define AVR32_USBB_UPSTAXSET_SHORTPACKETIS_MASK             AVR32_USBB_UPSTA0SET_SHORTPACKETIS_MASK
#define AVR32_USBB_UPSTAXSET_SHORTPACKETIS_OFFSET           AVR32_USBB_UPSTA0SET_SHORTPACKETIS_OFFSET
#define AVR32_USBB_UPSTAXSET_SHORTPACKETIS_SIZE             AVR32_USBB_UPSTA0SET_SHORTPACKETIS_SIZE
#define AVR32_USBB_UPSTAXSET_TXOUTIS                        AVR32_USBB_UPSTA0SET_TXOUTIS
#define AVR32_USBB_UPSTAXSET_TXOUTIS_MASK                   AVR32_USBB_UPSTA0SET_TXOUTIS_MASK
#define AVR32_USBB_UPSTAXSET_TXOUTIS_OFFSET                 AVR32_USBB_UPSTA0SET_TXOUTIS_OFFSET
#define AVR32_USBB_UPSTAXSET_TXOUTIS_SIZE                   AVR32_USBB_UPSTA0SET_TXOUTIS_SIZE
#define AVR32_USBB_UPSTAXSET_TXSTPIS                        AVR32_USBB_UPSTA0SET_TXSTPIS
#define AVR32_USBB_UPSTAXSET_TXSTPIS_MASK                   AVR32_USBB_UPSTA0SET_TXSTPIS_MASK
#define AVR32_USBB_UPSTAXSET_TXSTPIS_OFFSET                 AVR32_USBB_UPSTA0SET_TXSTPIS_OFFSET
#define AVR32_USBB_UPSTAXSET_TXSTPIS_SIZE                   AVR32_USBB_UPSTA0SET_TXSTPIS_SIZE
#define AVR32_USBB_UPSTAX_CFGOK                             AVR32_USBB_UPSTA0_CFGOK
#define AVR32_USBB_UPSTAX_CFGOK_MASK                        AVR32_USBB_UPSTA0_CFGOK_MASK
#define AVR32_USBB_UPSTAX_CFGOK_OFFSET                      AVR32_USBB_UPSTA0_CFGOK_OFFSET
#define AVR32_USBB_UPSTAX_CFGOK_SIZE                        AVR32_USBB_UPSTA0_CFGOK_SIZE
#define AVR32_USBB_UPSTAX_CURRBK                            AVR32_USBB_UPSTA0_CURRBK
#define AVR32_USBB_UPSTAX_CURRBK_MASK                       AVR32_USBB_UPSTA0_CURRBK_MASK
#define AVR32_USBB_UPSTAX_CURRBK_OFFSET                     AVR32_USBB_UPSTA0_CURRBK_OFFSET
#define AVR32_USBB_UPSTAX_CURRBK_SIZE                       AVR32_USBB_UPSTA0_CURRBK_SIZE
#define AVR32_USBB_UPSTAX_DTSEQ                             AVR32_USBB_UPSTA0_DTSEQ
#define AVR32_USBB_UPSTAX_DTSEQ_MASK                        AVR32_USBB_UPSTA0_DTSEQ_MASK
#define AVR32_USBB_UPSTAX_DTSEQ_OFFSET                      AVR32_USBB_UPSTA0_DTSEQ_OFFSET
#define AVR32_USBB_UPSTAX_DTSEQ_SIZE                        AVR32_USBB_UPSTA0_DTSEQ_SIZE
#define AVR32_USBB_UPSTAX_NAKEDI                            AVR32_USBB_UPSTA0_NAKEDI
#define AVR32_USBB_UPSTAX_NAKEDI_MASK                       AVR32_USBB_UPSTA0_NAKEDI_MASK
#define AVR32_USBB_UPSTAX_NAKEDI_OFFSET                     AVR32_USBB_UPSTA0_NAKEDI_OFFSET
#define AVR32_USBB_UPSTAX_NAKEDI_SIZE                       AVR32_USBB_UPSTA0_NAKEDI_SIZE
#define AVR32_USBB_UPSTAX_NBUSYBK                           AVR32_USBB_UPSTA0_NBUSYBK
#define AVR32_USBB_UPSTAX_NBUSYBK_MASK                      AVR32_USBB_UPSTA0_NBUSYBK_MASK
#define AVR32_USBB_UPSTAX_NBUSYBK_OFFSET                    AVR32_USBB_UPSTA0_NBUSYBK_OFFSET
#define AVR32_USBB_UPSTAX_NBUSYBK_SIZE                      AVR32_USBB_UPSTA0_NBUSYBK_SIZE
#define AVR32_USBB_UPSTAX_OVERFI                            AVR32_USBB_UPSTA0_OVERFI
#define AVR32_USBB_UPSTAX_OVERFI_MASK                       AVR32_USBB_UPSTA0_OVERFI_MASK
#define AVR32_USBB_UPSTAX_OVERFI_OFFSET                     AVR32_USBB_UPSTA0_OVERFI_OFFSET
#define AVR32_USBB_UPSTAX_OVERFI_SIZE                       AVR32_USBB_UPSTA0_OVERFI_SIZE
#define AVR32_USBB_UPSTAX_PBYCT                             AVR32_USBB_UPSTA0_PBYCT
#define AVR32_USBB_UPSTAX_PBYCT_MASK                        AVR32_USBB_UPSTA0_PBYCT_MASK
#define AVR32_USBB_UPSTAX_PBYCT_OFFSET                      AVR32_USBB_UPSTA0_PBYCT_OFFSET
#define AVR32_USBB_UPSTAX_PBYCT_SIZE                        AVR32_USBB_UPSTA0_PBYCT_SIZE
#define AVR32_USBB_UPSTAX_PERRI                             AVR32_USBB_UPSTA0_PERRI
#define AVR32_USBB_UPSTAX_PERRI_MASK                        AVR32_USBB_UPSTA0_PERRI_MASK
#define AVR32_USBB_UPSTAX_PERRI_OFFSET                      AVR32_USBB_UPSTA0_PERRI_OFFSET
#define AVR32_USBB_UPSTAX_PERRI_SIZE                        AVR32_USBB_UPSTA0_PERRI_SIZE
#define AVR32_USBB_UPSTAX_RWALL                             AVR32_USBB_UPSTA0_RWALL
#define AVR32_USBB_UPSTAX_RWALL_MASK                        AVR32_USBB_UPSTA0_RWALL_MASK
#define AVR32_USBB_UPSTAX_RWALL_OFFSET                      AVR32_USBB_UPSTA0_RWALL_OFFSET
#define AVR32_USBB_UPSTAX_RWALL_SIZE                        AVR32_USBB_UPSTA0_RWALL_SIZE
#define AVR32_USBB_UPSTAX_RXINI                             AVR32_USBB_UPSTA0_RXINI
#define AVR32_USBB_UPSTAX_RXINI_MASK                        AVR32_USBB_UPSTA0_RXINI_MASK
#define AVR32_USBB_UPSTAX_RXINI_OFFSET                      AVR32_USBB_UPSTA0_RXINI_OFFSET
#define AVR32_USBB_UPSTAX_RXINI_SIZE                        AVR32_USBB_UPSTA0_RXINI_SIZE
#define AVR32_USBB_UPSTAX_RXSTALLDI                         AVR32_USBB_UPSTA0_RXSTALLDI
#define AVR32_USBB_UPSTAX_RXSTALLDI_MASK                    AVR32_USBB_UPSTA0_RXSTALLDI_MASK
#define AVR32_USBB_UPSTAX_RXSTALLDI_OFFSET                  AVR32_USBB_UPSTA0_RXSTALLDI_OFFSET
#define AVR32_USBB_UPSTAX_RXSTALLDI_SIZE                    AVR32_USBB_UPSTA0_RXSTALLDI_SIZE
#define AVR32_USBB_UPSTAX_SHORTPACKETI                      AVR32_USBB_UPSTA0_SHORTPACKETI
#define AVR32_USBB_UPSTAX_SHORTPACKETI_MASK                 AVR32_USBB_UPSTA0_SHORTPACKETI_MASK
#define AVR32_USBB_UPSTAX_SHORTPACKETI_OFFSET               AVR32_USBB_UPSTA0_SHORTPACKETI_OFFSET
#define AVR32_USBB_UPSTAX_SHORTPACKETI_SIZE                 AVR32_USBB_UPSTA0_SHORTPACKETI_SIZE
#define AVR32_USBB_UPSTAX_TXOUTI                            AVR32_USBB_UPSTA0_TXOUTI
#define AVR32_USBB_UPSTAX_TXOUTI_MASK                       AVR32_USBB_UPSTA0_TXOUTI_MASK
#define AVR32_USBB_UPSTAX_TXOUTI_OFFSET                     AVR32_USBB_UPSTA0_TXOUTI_OFFSET
#define AVR32_USBB_UPSTAX_TXOUTI_SIZE                       AVR32_USBB_UPSTA0_TXOUTI_SIZE
#define AVR32_USBB_UPSTAX_TXSTPI                            AVR32_USBB_UPSTA0_TXSTPI
#define AVR32_USBB_UPSTAX_TXSTPI_MASK                       AVR32_USBB_UPSTA0_TXSTPI_MASK
#define AVR32_USBB_UPSTAX_TXSTPI_OFFSET                     AVR32_USBB_UPSTA0_TXSTPI_OFFSET
#define AVR32_USBB_UPSTAX_TXSTPI_SIZE                       AVR32_USBB_UPSTA0_TXSTPI_SIZE
#define AVR32_USBB_UXDMAX_ADDR                              AVR32_USBB_UDDMA1_ADDR
#define AVR32_USBB_UXDMAX_ADDR_HSB_ADDR                     AVR32_USBB_UDDMA1_ADDR_HSB_ADDR
#define AVR32_USBB_UXDMAX_ADDR_HSB_ADDR_MASK                AVR32_USBB_UDDMA1_ADDR_HSB_ADDR_MASK
#define AVR32_USBB_UXDMAX_ADDR_HSB_ADDR_OFFSET              AVR32_USBB_UDDMA1_ADDR_HSB_ADDR_OFFSET
#define AVR32_USBB_UXDMAX_ADDR_HSB_ADDR_SIZE                AVR32_USBB_UDDMA1_ADDR_HSB_ADDR_SIZE
#define AVR32_USBB_UXDMAX_CONTROL                           AVR32_USBB_UDDMA1_CONTROL
#define AVR32_USBB_UXDMAX_CONTROL_BUFF_CLOSE_IN_EN          AVR32_USBB_UDDMA1_CONTROL_BUFF_CLOSE_IN_EN
#define AVR32_USBB_UXDMAX_CONTROL_BUFF_CLOSE_IN_EN_MASK     AVR32_USBB_UDDMA1_CONTROL_BUFF_CLOSE_IN_EN_MASK
#define AVR32_USBB_UXDMAX_CONTROL_BUFF_CLOSE_IN_EN_OFFSET   AVR32_USBB_UDDMA1_CONTROL_BUFF_CLOSE_IN_EN_OFFSET
#define AVR32_USBB_UXDMAX_CONTROL_BUFF_CLOSE_IN_EN_SIZE     AVR32_USBB_UDDMA1_CONTROL_BUFF_CLOSE_IN_EN_SIZE
#define AVR32_USBB_UXDMAX_CONTROL_BURST_LOCK_EN             AVR32_USBB_UDDMA1_CONTROL_BURST_LOCK_EN
#define AVR32_USBB_UXDMAX_CONTROL_BURST_LOCK_EN_MASK        AVR32_USBB_UDDMA1_CONTROL_BURST_LOCK_EN_MASK
#define AVR32_USBB_UXDMAX_CONTROL_BURST_LOCK_EN_OFFSET      AVR32_USBB_UDDMA1_CONTROL_BURST_LOCK_EN_OFFSET
#define AVR32_USBB_UXDMAX_CONTROL_BURST_LOCK_EN_SIZE        AVR32_USBB_UDDMA1_CONTROL_BURST_LOCK_EN_SIZE
#define AVR32_USBB_UXDMAX_CONTROL_CH_BYTE_LENGTH            AVR32_USBB_UDDMA1_CONTROL_CH_BYTE_LENGTH
#define AVR32_USBB_UXDMAX_CONTROL_CH_BYTE_LENGTH_MASK       AVR32_USBB_UDDMA1_CONTROL_CH_BYTE_LENGTH_MASK
#define AVR32_USBB_UXDMAX_CONTROL_CH_BYTE_LENGTH_OFFSET     AVR32_USBB_UDDMA1_CONTROL_CH_BYTE_LENGTH_OFFSET
#define AVR32_USBB_UXDMAX_CONTROL_CH_BYTE_LENGTH_SIZE       AVR32_USBB_UDDMA1_CONTROL_CH_BYTE_LENGTH_SIZE
#define AVR32_USBB_UXDMAX_CONTROL_CH_EN                     AVR32_USBB_UDDMA1_CONTROL_CH_EN
#define AVR32_USBB_UXDMAX_CONTROL_CH_EN_MASK                AVR32_USBB_UDDMA1_CONTROL_CH_EN_MASK
#define AVR32_USBB_UXDMAX_CONTROL_CH_EN_OFFSET              AVR32_USBB_UDDMA1_CONTROL_CH_EN_OFFSET
#define AVR32_USBB_UXDMAX_CONTROL_CH_EN_SIZE                AVR32_USBB_UDDMA1_CONTROL_CH_EN_SIZE
#define AVR32_USBB_UXDMAX_CONTROL_DESC_LD_IRQ_EN            AVR32_USBB_UDDMA1_CONTROL_DESC_LD_IRQ_EN
#define AVR32_USBB_UXDMAX_CONTROL_DESC_LD_IRQ_EN_MASK       AVR32_USBB_UDDMA1_CONTROL_DESC_LD_IRQ_EN_MASK
#define AVR32_USBB_UXDMAX_CONTROL_DESC_LD_IRQ_EN_OFFSET     AVR32_USBB_UDDMA1_CONTROL_DESC_LD_IRQ_EN_OFFSET
#define AVR32_USBB_UXDMAX_CONTROL_DESC_LD_IRQ_EN_SIZE       AVR32_USBB_UDDMA1_CONTROL_DESC_LD_IRQ_EN_SIZE
#define AVR32_USBB_UXDMAX_CONTROL_DMAEND_EN                 AVR32_USBB_UDDMA1_CONTROL_DMAEND_EN
#define AVR32_USBB_UXDMAX_CONTROL_DMAEND_EN_MASK            AVR32_USBB_UDDMA1_CONTROL_DMAEND_EN_MASK
#define AVR32_USBB_UXDMAX_CONTROL_DMAEND_EN_OFFSET          AVR32_USBB_UDDMA1_CONTROL_DMAEND_EN_OFFSET
#define AVR32_USBB_UXDMAX_CONTROL_DMAEND_EN_SIZE            AVR32_USBB_UDDMA1_CONTROL_DMAEND_EN_SIZE
#define AVR32_USBB_UXDMAX_CONTROL_EOBUFF_IRQ_EN             AVR32_USBB_UDDMA1_CONTROL_EOBUFF_IRQ_EN
#define AVR32_USBB_UXDMAX_CONTROL_EOBUFF_IRQ_EN_MASK        AVR32_USBB_UDDMA1_CONTROL_EOBUFF_IRQ_EN_MASK
#define AVR32_USBB_UXDMAX_CONTROL_EOBUFF_IRQ_EN_OFFSET      AVR32_USBB_UDDMA1_CONTROL_EOBUFF_IRQ_EN_OFFSET
#define AVR32_USBB_UXDMAX_CONTROL_EOBUFF_IRQ_EN_SIZE        AVR32_USBB_UDDMA1_CONTROL_EOBUFF_IRQ_EN_SIZE
#define AVR32_USBB_UXDMAX_CONTROL_EOT_IRQ_EN                AVR32_USBB_UDDMA1_CONTROL_EOT_IRQ_EN
#define AVR32_USBB_UXDMAX_CONTROL_EOT_IRQ_EN_MASK           AVR32_USBB_UDDMA1_CONTROL_EOT_IRQ_EN_MASK
#define AVR32_USBB_UXDMAX_CONTROL_EOT_IRQ_EN_OFFSET         AVR32_USBB_UDDMA1_CONTROL_EOT_IRQ_EN_OFFSET
#define AVR32_USBB_UXDMAX_CONTROL_EOT_IRQ_EN_SIZE           AVR32_USBB_UDDMA1_CONTROL_EOT_IRQ_EN_SIZE
#define AVR32_USBB_UXDMAX_CONTROL_LD_NXT_CH_DESC_EN         AVR32_USBB_UDDMA1_CONTROL_LD_NXT_CH_DESC_EN
#define AVR32_USBB_UXDMAX_CONTROL_LD_NXT_CH_DESC_EN_MASK    AVR32_USBB_UDDMA1_CONTROL_LD_NXT_CH_DESC_EN_MASK
#define AVR32_USBB_UXDMAX_CONTROL_LD_NXT_CH_DESC_EN_OFFSET  AVR32_USBB_UDDMA1_CONTROL_LD_NXT_CH_DESC_EN_OFFSET
#define AVR32_USBB_UXDMAX_CONTROL_LD_NXT_CH_DESC_EN_SIZE    AVR32_USBB_UDDMA1_CONTROL_LD_NXT_CH_DESC_EN_SIZE
#define AVR32_USBB_UXDMAX_NEXTDESC                          AVR32_USBB_UDDMA1_NEXTDESC
#define AVR32_USBB_UXDMAX_NEXTDESC_NXT_DESC_ADDR            AVR32_USBB_UDDMA1_NEXTDESC_NXT_DESC_ADDR
#define AVR32_USBB_UXDMAX_NEXTDESC_NXT_DESC_ADDR_MASK       AVR32_USBB_UDDMA1_NEXTDESC_NXT_DESC_ADDR_MASK
#define AVR32_USBB_UXDMAX_NEXTDESC_NXT_DESC_ADDR_OFFSET     AVR32_USBB_UDDMA1_NEXTDESC_NXT_DESC_ADDR_OFFSET
#define AVR32_USBB_UXDMAX_NEXTDESC_NXT_DESC_ADDR_SIZE       AVR32_USBB_UDDMA1_NEXTDESC_NXT_DESC_ADDR_SIZE
#define AVR32_USBB_UXDMAX_STATUS                            AVR32_USBB_UDDMA1_STATUS
#define AVR32_USBB_UXDMAX_STATUS_CH_ACTIVE                  AVR32_USBB_UDDMA1_STATUS_CH_ACTIVE
#define AVR32_USBB_UXDMAX_STATUS_CH_ACTIVE_MASK             AVR32_USBB_UDDMA1_STATUS_CH_ACTIVE_MASK
#define AVR32_USBB_UXDMAX_STATUS_CH_ACTIVE_OFFSET           AVR32_USBB_UDDMA1_STATUS_CH_ACTIVE_OFFSET
#define AVR32_USBB_UXDMAX_STATUS_CH_ACTIVE_SIZE             AVR32_USBB_UDDMA1_STATUS_CH_ACTIVE_SIZE
#define AVR32_USBB_UXDMAX_STATUS_CH_BYTE_CNT                AVR32_USBB_UDDMA1_STATUS_CH_BYTE_CNT
#define AVR32_USBB_UXDMAX_STATUS_CH_BYTE_CNT_MASK           AVR32_USBB_UDDMA1_STATUS_CH_BYTE_CNT_MASK
#define AVR32_USBB_UXDMAX_STATUS_CH_BYTE_CNT_OFFSET         AVR32_USBB_UDDMA1_STATUS_CH_BYTE_CNT_OFFSET
#define AVR32_USBB_UXDMAX_STATUS_CH_BYTE_CNT_SIZE           AVR32_USBB_UDDMA1_STATUS_CH_BYTE_CNT_SIZE
#define AVR32_USBB_UXDMAX_STATUS_CH_EN                      AVR32_USBB_UDDMA1_STATUS_CH_EN
#define AVR32_USBB_UXDMAX_STATUS_CH_EN_MASK                 AVR32_USBB_UDDMA1_STATUS_CH_EN_MASK
#define AVR32_USBB_UXDMAX_STATUS_CH_EN_OFFSET               AVR32_USBB_UDDMA1_STATUS_CH_EN_OFFSET
#define AVR32_USBB_UXDMAX_STATUS_CH_EN_SIZE                 AVR32_USBB_UDDMA1_STATUS_CH_EN_SIZE
#define AVR32_USBB_UXDMAX_STATUS_DESC_LD_STA                AVR32_USBB_UDDMA1_STATUS_DESC_LD_STA
#define AVR32_USBB_UXDMAX_STATUS_DESC_LD_STA_MASK           AVR32_USBB_UDDMA1_STATUS_DESC_LD_STA_MASK
#define AVR32_USBB_UXDMAX_STATUS_DESC_LD_STA_OFFSET         AVR32_USBB_UDDMA1_STATUS_DESC_LD_STA_OFFSET
#define AVR32_USBB_UXDMAX_STATUS_DESC_LD_STA_SIZE           AVR32_USBB_UDDMA1_STATUS_DESC_LD_STA_SIZE
#define AVR32_USBB_UXDMAX_STATUS_EOCH_BUFF_STA              AVR32_USBB_UDDMA1_STATUS_EOCH_BUFF_STA
#define AVR32_USBB_UXDMAX_STATUS_EOCH_BUFF_STA_MASK         AVR32_USBB_UDDMA1_STATUS_EOCH_BUFF_STA_MASK
#define AVR32_USBB_UXDMAX_STATUS_EOCH_BUFF_STA_OFFSET       AVR32_USBB_UDDMA1_STATUS_EOCH_BUFF_STA_OFFSET
#define AVR32_USBB_UXDMAX_STATUS_EOCH_BUFF_STA_SIZE         AVR32_USBB_UDDMA1_STATUS_EOCH_BUFF_STA_SIZE
#define AVR32_USBB_UXDMAX_STATUS_EOT_STA                    AVR32_USBB_UDDMA1_STATUS_EOT_STA
#define AVR32_USBB_UXDMAX_STATUS_EOT_STA_MASK               AVR32_USBB_UDDMA1_STATUS_EOT_STA_MASK
#define AVR32_USBB_UXDMAX_STATUS_EOT_STA_OFFSET             AVR32_USBB_UDDMA1_STATUS_EOT_STA_OFFSET
#define AVR32_USBB_UXDMAX_STATUS_EOT_STA_SIZE               AVR32_USBB_UDDMA1_STATUS_EOT_STA_SIZE
//! @}




//! Generic types for all USBB registers that can be arrayed
//! @{
typedef avr32_usbb_uecfg0_t avr32_usbb_uecfgx_t;



typedef avr32_usbb_uesta0_t avr32_usbb_uestax_t;



typedef avr32_usbb_uesta0clr_t avr32_usbb_uestaxclr_t;



typedef avr32_usbb_uesta0set_t avr32_usbb_uestaxset_t;



typedef avr32_usbb_uecon0_t avr32_usbb_ueconx_t;



typedef avr32_usbb_uecon0clr_t avr32_usbb_ueconxclr_t;



typedef avr32_usbb_uecon0set_t avr32_usbb_ueconxset_t;



typedef avr32_usbb_uddma1_nextdesc_t avr32_usbb_uxdmax_nextdesc_t;



typedef avr32_usbb_uddma1_control_t avr32_usbb_uxdmax_control_t;



typedef avr32_usbb_uddma1_status_t avr32_usbb_uxdmax_status_t;



typedef struct {
  union {
          unsigned long                  nextdesc  ;
          avr32_usbb_uxdmax_nextdesc_t   NEXTDESC  ;
  };
          unsigned long                  addr      ;
  union {
          unsigned long                  control   ;
          avr32_usbb_uxdmax_control_t    CONTROL   ;
  };
  union {
          unsigned long                  status    ;
          avr32_usbb_uxdmax_status_t     STATUS    ;
  };
} avr32_usbb_uxdmax_t;



typedef avr32_usbb_upcfg0_t avr32_usbb_upcfgx_t;



typedef avr32_usbb_upsta0_t avr32_usbb_upstax_t;



typedef avr32_usbb_upsta0clr_t avr32_usbb_upstaxclr_t;



typedef avr32_usbb_upsta0set_t avr32_usbb_upstaxset_t;



typedef avr32_usbb_upcon0_t avr32_usbb_upconx_t;



typedef avr32_usbb_upcon0clr_t avr32_usbb_upconxclr_t;



typedef avr32_usbb_upcon0set_t avr32_usbb_upconxset_t;



typedef avr32_usbb_upinrq0_t avr32_usbb_upinrqx_t;



typedef avr32_usbb_uperr0_t avr32_usbb_uperrx_t;
//! @}




//! Access points to the USBB memory map with arrayed registers
//! @{
  //! Access points to the USBB arbiter memory map with arrayed registers
  //! @{
#ifdef  AVR32_USBB_USBCON
  #undef  AVR32_USBB_USBCON
#endif
#define AVR32_USBB_usbcon                 (AVR32_USBB.usbcon)
#define AVR32_USBB_USBCON                 (AVR32_USBB.USBCON)

#ifdef  AVR32_USBB_USBSTA
  #undef  AVR32_USBB_USBSTA
#endif
#define AVR32_USBB_usbsta                 (AVR32_USBB.usbsta)
#define AVR32_USBB_USBSTA                 (AVR32_USBB.USBSTA)

#ifdef  AVR32_USBB_USBSTACLR
  #undef  AVR32_USBB_USBSTACLR
#endif
#define AVR32_USBB_usbstaclr              (AVR32_USBB.usbstaclr)
#define AVR32_USBB_USBSTACLR              (AVR32_USBB.USBSTACLR)

#ifdef  AVR32_USBB_USBSTASET
  #undef  AVR32_USBB_USBSTASET
#endif
#define AVR32_USBB_usbstaset              (AVR32_USBB.usbstaset)
#define AVR32_USBB_USBSTASET              (AVR32_USBB.USBSTASET)

#ifdef  AVR32_USBB_UVERS
  #undef  AVR32_USBB_UVERS
#endif
#define AVR32_USBB_uvers                  (AVR32_USBB.uvers)
#define AVR32_USBB_UVERS                  (AVR32_USBB.UVERS)

#ifdef  AVR32_USBB_UFEATURES
  #undef  AVR32_USBB_UFEATURES
#endif
#define AVR32_USBB_ufeatures              (AVR32_USBB.ufeatures)
#define AVR32_USBB_UFEATURES              (AVR32_USBB.UFEATURES)

#define AVR32_USBB_uaddrsize              (AVR32_USBB.uaddrsize)

#define AVR32_USBB_unamex(x)              ((&AVR32_USBB.uname1)[(x) - 1])

#ifdef  AVR32_USBB_USBFSM
  #undef  AVR32_USBB_USBFSM
#endif
#define AVR32_USBB_usbfsm                 (AVR32_USBB.usbfsm)
#define AVR32_USBB_USBFSM                 (AVR32_USBB.USBFSM)
  //! @}

  //! Access points to the USBB device memory map with arrayed registers
  //! @{
#ifdef  AVR32_USBB_UDCON
  #undef  AVR32_USBB_UDCON
#endif
#define AVR32_USBB_udcon                  (AVR32_USBB.udcon)
#define AVR32_USBB_UDCON                  (AVR32_USBB.UDCON)

#ifdef  AVR32_USBB_UDINT
  #undef  AVR32_USBB_UDINT
#endif
#define AVR32_USBB_udint                  (AVR32_USBB.udint)
#define AVR32_USBB_UDINT                  (AVR32_USBB.UDINT)

#ifdef  AVR32_USBB_UDINTCLR
  #undef  AVR32_USBB_UDINTCLR
#endif
#define AVR32_USBB_udintclr               (AVR32_USBB.udintclr)
#define AVR32_USBB_UDINTCLR               (AVR32_USBB.UDINTCLR)

#ifdef  AVR32_USBB_UDINTSET
  #undef  AVR32_USBB_UDINTSET
#endif
#define AVR32_USBB_udintset               (AVR32_USBB.udintset)
#define AVR32_USBB_UDINTSET               (AVR32_USBB.UDINTSET)

#ifdef  AVR32_USBB_UDINTE
  #undef  AVR32_USBB_UDINTE
#endif
#define AVR32_USBB_udinte                 (AVR32_USBB.udinte)
#define AVR32_USBB_UDINTE                 (AVR32_USBB.UDINTE)

#ifdef  AVR32_USBB_UDINTECLR
  #undef  AVR32_USBB_UDINTECLR
#endif
#define AVR32_USBB_udinteclr              (AVR32_USBB.udinteclr)
#define AVR32_USBB_UDINTECLR              (AVR32_USBB.UDINTECLR)

#ifdef  AVR32_USBB_UDINTESET
  #undef  AVR32_USBB_UDINTESET
#endif
#define AVR32_USBB_udinteset              (AVR32_USBB.udinteset)
#define AVR32_USBB_UDINTESET              (AVR32_USBB.UDINTESET)

#ifdef  AVR32_USBB_UDFNUM
  #undef  AVR32_USBB_UDFNUM
#endif
#define AVR32_USBB_udfnum                 (AVR32_USBB.udfnum)
#define AVR32_USBB_UDFNUM                 (AVR32_USBB.UDFNUM)

    //! Access points to the USBB device endpoint memory map with arrayed registers
    //! @{
#ifdef  AVR32_USBB_UERST
  #undef  AVR32_USBB_UERST
#endif
#define AVR32_USBB_uerst                  (AVR32_USBB.uerst)
#define AVR32_USBB_UERST                  (AVR32_USBB.UERST)

#ifdef  AVR32_USBB_UECFGX
  #undef  AVR32_USBB_UECFGX
#endif
#define AVR32_USBB_uecfgx(x)              ((&AVR32_USBB.uecfg0)[(x)])
#define AVR32_USBB_UECFGX(x)              ((&AVR32_USBB.UECFG0)[(x)])

#ifdef  AVR32_USBB_UESTAX
  #undef  AVR32_USBB_UESTAX
#endif
#define AVR32_USBB_uestax(x)              ((&AVR32_USBB.uesta0)[(x)])
#define AVR32_USBB_UESTAX(x)              ((&AVR32_USBB.UESTA0)[(x)])

#ifdef  AVR32_USBB_UESTAXCLR
  #undef  AVR32_USBB_UESTAXCLR
#endif
#define AVR32_USBB_uestaxclr(x)           ((&AVR32_USBB.uesta0clr)[(x)])
#define AVR32_USBB_UESTAXCLR(x)           ((&AVR32_USBB.UESTA0CLR)[(x)])

#ifdef  AVR32_USBB_UESTAXSET
  #undef  AVR32_USBB_UESTAXSET
#endif
#define AVR32_USBB_uestaxset(x)           ((&AVR32_USBB.uesta0set)[(x)])
#define AVR32_USBB_UESTAXSET(x)           ((&AVR32_USBB.UESTA0SET)[(x)])

#ifdef  AVR32_USBB_UECONX
  #undef  AVR32_USBB_UECONX
#endif
#define AVR32_USBB_ueconx(x)              ((&AVR32_USBB.uecon0)[(x)])
#define AVR32_USBB_UECONX(x)              ((&AVR32_USBB.UECON0)[(x)])

#ifdef  AVR32_USBB_UECONXCLR
  #undef  AVR32_USBB_UECONXCLR
#endif
#define AVR32_USBB_ueconxclr(x)           ((&AVR32_USBB.uecon0clr)[(x)])
#define AVR32_USBB_UECONXCLR(x)           ((&AVR32_USBB.UECON0CLR)[(x)])

#ifdef  AVR32_USBB_UECONXSET
  #undef  AVR32_USBB_UECONXSET
#endif
#define AVR32_USBB_ueconxset(x)           ((&AVR32_USBB.uecon0set)[(x)])
#define AVR32_USBB_UECONXSET(x)           ((&AVR32_USBB.UECON0SET)[(x)])
    //! @}

    //! Access points to the USBB device DMA memory map with arrayed registers
    //! @{
#define AVR32_USBB_UDDMAX(x) \
          (((volatile avr32_usbb_uxdmax_t *)&AVR32_USBB.uddma1_nextdesc)[(x) - 1])

#ifdef  AVR32_USBB_UDDMAX_NEXTDESC
  #undef  AVR32_USBB_UDDMAX_NEXTDESC
#endif
#define AVR32_USBB_UDDMAX_nextdesc(x)     (AVR32_USBB_UDDMAX(x).nextdesc)
#define AVR32_USBB_UDDMAX_NEXTDESC(x)     (AVR32_USBB_UDDMAX(x).NEXTDESC)

#define AVR32_USBB_UDDMAX_addr(x)         (AVR32_USBB_UDDMAX(x).addr)

#ifdef  AVR32_USBB_UDDMAX_CONTROL
  #undef  AVR32_USBB_UDDMAX_CONTROL
#endif
#define AVR32_USBB_UDDMAX_control(x)      (AVR32_USBB_UDDMAX(x).control)
#define AVR32_USBB_UDDMAX_CONTROL(x)      (AVR32_USBB_UDDMAX(x).CONTROL)

#ifdef  AVR32_USBB_UDDMAX_STATUS
  #undef  AVR32_USBB_UDDMAX_STATUS
#endif
#define AVR32_USBB_UDDMAX_status(x)       (AVR32_USBB_UDDMAX(x).status)
#define AVR32_USBB_UDDMAX_STATUS(x)       (AVR32_USBB_UDDMAX(x).STATUS)
    //! @}
  //! @}

  //! Access points to the USBB host memory map with arrayed registers
  //! @{
#ifdef  AVR32_USBB_UHCON
  #undef  AVR32_USBB_UHCON
#endif
#define AVR32_USBB_uhcon                  (AVR32_USBB.uhcon)
#define AVR32_USBB_UHCON                  (AVR32_USBB.UHCON)

#ifdef  AVR32_USBB_UHINT
  #undef  AVR32_USBB_UHINT
#endif
#define AVR32_USBB_uhint                  (AVR32_USBB.uhint)
#define AVR32_USBB_UHINT                  (AVR32_USBB.UHINT)

#ifdef  AVR32_USBB_UHINTCLR
  #undef  AVR32_USBB_UHINTCLR
#endif
#define AVR32_USBB_uhintclr               (AVR32_USBB.uhintclr)
#define AVR32_USBB_UHINTCLR               (AVR32_USBB.UHINTCLR)

#ifdef  AVR32_USBB_UHINTSET
  #undef  AVR32_USBB_UHINTSET
#endif
#define AVR32_USBB_uhintset               (AVR32_USBB.uhintset)
#define AVR32_USBB_UHINTSET               (AVR32_USBB.UHINTSET)

#ifdef  AVR32_USBB_UHINTE
  #undef  AVR32_USBB_UHINTE
#endif
#define AVR32_USBB_uhinte                 (AVR32_USBB.uhinte)
#define AVR32_USBB_UHINTE                 (AVR32_USBB.IHINTE)

#ifdef  AVR32_USBB_UHINTECLR
  #undef  AVR32_USBB_UHINTECLR
#endif
#define AVR32_USBB_uhinteclr              (AVR32_USBB.uhinteclr)
#define AVR32_USBB_UHINTECLR              (AVR32_USBB.UHINTECLR)

#ifdef  AVR32_USBB_UHINTESET
  #undef  AVR32_USBB_UHINTESET
#endif
#define AVR32_USBB_uhinteset              (AVR32_USBB.uhinteset)
#define AVR32_USBB_UHINTESET              (AVR32_USBB.UHINTESET)

#ifdef  AVR32_USBB_UHFNUM
  #undef  AVR32_USBB_UHFNUM
#endif
#define AVR32_USBB_uhfnum                 (AVR32_USBB.uhfnum)
#define AVR32_USBB_UHFNUM                 (AVR32_USBB.UHFNUM)

#ifdef  AVR32_USBB_UHADDRX
  #undef  AVR32_USBB_UHADDRX
#endif
#define AVR32_USBB_uhaddrx(x)             ((&AVR32_USBB.uhaddr1)[(x) - 1])
#define AVR32_USBB_UHADDRX(x)             ((&AVR32_USBB.UHADDR1)[(x) - 1])

    //! Access points to the USBB host pipe memory map with arrayed registers
    //! @{
#ifdef  AVR32_USBB_UPRST
  #undef  AVR32_USBB_UPRST
#endif
#define AVR32_USBB_uprst                  (AVR32_USBB.uprst)
#define AVR32_USBB_UPRST                  (AVR32_USBB.UPRST)

#ifdef  AVR32_USBB_UPCFGX
  #undef  AVR32_USBB_UPCFGX
#endif
#define AVR32_USBB_upcfgx(x)              ((&AVR32_USBB.upcfg0)[(x)])
#define AVR32_USBB_UPCFGX(x)              ((&AVR32_USBB.UPCFG0)[(x)])

#ifdef  AVR32_USBB_UPSTAX
  #undef  AVR32_USBB_UPSTAX
#endif
#define AVR32_USBB_upstax(x)              ((&AVR32_USBB.upsta0)[(x)])
#define AVR32_USBB_UPSTAX(x)              ((&AVR32_USBB.UPSTA0)[(x)])

#ifdef  AVR32_USBB_UPSTAXCLR
  #undef  AVR32_USBB_UPSTAXCLR
#endif
#define AVR32_USBB_upstaxclr(x)           ((&AVR32_USBB.upsta0clr)[(x)])
#define AVR32_USBB_UPSTAXCLR(x)           ((&AVR32_USBB.UPSTA0CLR)[(x)])

#ifdef  AVR32_USBB_UPSTAXSET
  #undef  AVR32_USBB_UPSTAXSET
#endif
#define AVR32_USBB_upstaxset(x)           ((&AVR32_USBB.upsta0set)[(x)])
#define AVR32_USBB_UPSTAXSET(x)           ((&AVR32_USBB.UPSTA0SET)[(x)])

#ifdef  AVR32_USBB_UPCONX
  #undef  AVR32_USBB_UPCONX
#endif
#define AVR32_USBB_upconx(x)              ((&AVR32_USBB.upcon0)[(x)])
#define AVR32_USBB_UPCONX(x)              ((&AVR32_USBB.UPCON0)[(x)])

#ifdef  AVR32_USBB_UPCONXCLR
  #undef  AVR32_USBB_UPCONXCLR
#endif
#define AVR32_USBB_upconxclr(x)           ((&AVR32_USBB.upcon0clr)[(x)])
#define AVR32_USBB_UPCONXCLR(x)           ((&AVR32_USBB.UPCON0CLR)[(x)])

#ifdef  AVR32_USBB_UPCONXSET
  #undef  AVR32_USBB_UPCONXSET
#endif
#define AVR32_USBB_upconxset(x)           ((&AVR32_USBB.upcon0set)[(x)])
#define AVR32_USBB_UPCONXSET(x)           ((&AVR32_USBB.UPCON0SET)[(x)])

#ifdef  AVR32_USBB_UPINRQX
  #undef  AVR32_USBB_UPINRQX
#endif
#define AVR32_USBB_upinrqx(x)             ((&AVR32_USBB.upinrq0)[(x)])
#define AVR32_USBB_UPINRQX(x)             ((&AVR32_USBB.UPINRQ0)[(x)])

#ifdef  AVR32_USBB_UPERRX
  #undef  AVR32_USBB_UPERRX
#endif
#define AVR32_USBB_uperrx(x)              ((&AVR32_USBB.uperr0)[(x)])
#define AVR32_USBB_UPERRX(x)              ((&AVR32_USBB.UPERR0)[(x)])
    //! @}

    //! Access points to the USBB host DMA memory map with arrayed registers
    //! @{
#define AVR32_USBB_UHDMAX(x) \
          (((volatile avr32_usbb_uxdmax_t *)&AVR32_USBB.uhdma1_nextdesc)[(x) - 1])

#ifdef  AVR32_USBB_UHDMAX_NEXTDESC
  #undef  AVR32_USBB_UHDMAX_NEXTDESC
#endif
#define AVR32_USBB_UHDMAX_nextdesc(x)     (AVR32_USBB_UHDMAX(x).nextdesc)
#define AVR32_USBB_UHDMAX_NEXTDESC(x)     (AVR32_USBB_UHDMAX(x).NEXTDESC)

#define AVR32_USBB_UHDMAX_addr(x)         (AVR32_USBB_UHDMAX(x).addr)

#ifdef  AVR32_USBB_UHDMAX_CONTROL
  #undef  AVR32_USBB_UHDMAX_CONTROL
#endif
#define AVR32_USBB_UHDMAX_control(x)      (AVR32_USBB_UHDMAX(x).control)
#define AVR32_USBB_UHDMAX_CONTROL(x)      (AVR32_USBB_UHDMAX(x).CONTROL)

#ifdef  AVR32_USBB_UHDMAX_STATUS
  #undef  AVR32_USBB_UHDMAX_STATUS
#endif
#define AVR32_USBB_UHDMAX_status(x)       (AVR32_USBB_UHDMAX(x).status)
#define AVR32_USBB_UHDMAX_STATUS(x)       (AVR32_USBB_UHDMAX(x).STATUS)
    //! @}
  //! @}

  //! Access point to the FIFO data registers of pipes/endpoints
  //! @param x      Pipe/endpoint of which to access FIFO data register
  //! @param scale  Data index scale in bits: 64, 32, 16 or 8
  //! @return       Volatile 64-, 32-, 16- or 8-bit data pointer to FIFO data register
#define AVR32_USBB_FIFOX_DATA(x, scale) \
          (((volatile TPASTE2(U, scale) (*)[0x10000 / ((scale) / 8)])AVR32_USBB_SLAVE)[(x)])
//! @}




#endif  // _USBB_H_
