/******************************************************************************
 * AVR32 AT32UC3L064 GNU LD script file for the basic Secure State example.
 *
 * - Compiler:           GNU GCC for AVR32
 * - Supported devices:  AVR32 AT32UC3L064
 *
 * - author              Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 ******************************************************************************/

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
 *
 */

OUTPUT_FORMAT("elf32-avr32", "elf32-avr32", "elf32-avr32")

OUTPUT_ARCH(avr32:uc)

ENTRY(_start)

MEMORY
{
  FLASH_SEC (rxai!w) : ORIGIN = 0x80000000, LENGTH = 0x00000400
  FLASH_THIRDPARTY (rxai!w) : ORIGIN = 0x80000400, LENGTH = 0x0000FC00
  INTRAM_SEC (wxa!ri) : ORIGIN = 0x00000000, LENGTH = 0x00000400
  INTRAM_THIRDPARTY (wxa!ri) : ORIGIN = 0x00000400, LENGTH = 0x00003C00
  USERPAGE : ORIGIN = 0x80800000, LENGTH = 0x00000100
}

PHDRS
{
  FLASH_SEC               PT_LOAD;
  FLASH_THIRDPARTY            PT_LOAD;
  INTRAM_SEC_ALIGN        PT_NULL;
  INTRAM_THIRDPARTY_ALIGN     PT_NULL;
  INTRAM_SEC_AT_FLASH     PT_LOAD;
  INTRAM_THIRDPARTY_AT_FLASH  PT_LOAD;
  INTRAM_SEC              PT_NULL;
  INTRAM_THIRDPARTY           PT_NULL;
  USERPAGE                PT_LOAD;
}

SECTIONS
{
  /* If this heap size is selected, all the INTRAM space from the end of the
     data area to the beginning of the stack will be allocated for the heap. */
  __max_heap_size__ = -1;

  /* Use a default heap size if heap size was not defined. */
  __heap_size__ = DEFINED(__heap_size__) ? __heap_size__ : __max_heap_size__;

  /* Use a default stack size if stack size was not defined. */
  __stack_size__ = DEFINED(__stack_size__) ? __stack_size__ : 4K;
  
  /* Use a default stack size if stack size was not defined. */
  __sec_stack_size__ = DEFINED(__sec_stack_size__) ? __sec_stack_size__ : 512;

  /* Read-only sections, merged into text segment: */
  PROVIDE (__executable_start = 0x80000000); . = 0x80000000;
  .interp         : { *(.interp) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .reset          : { *(.reset) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .hash           : { *(.hash) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .dynsym         : { *(.dynsym) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .dynstr         : { *(.dynstr) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .gnu.version    : { *(.gnu.version) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .gnu.version_d  : { *(.gnu.version_d) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .gnu.version_r  : { *(.gnu.version_r) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rel.init       : { *(.rel.init) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rela.init      : { *(.rela.init) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rel.text       : { *(.rel.text .rel.text.* .rel.gnu.linkonce.t.*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rela.text      : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rel.fini       : { *(.rel.fini) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rela.fini      : { *(.rela.fini) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rel.rodata     : { *(.rel.rodata .rel.rodata.* .rel.gnu.linkonce.r.*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rela.rodata    : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rel.data.rel.ro   : { *(.rel.data.rel.ro*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rela.data.rel.ro   : { *(.rel.data.rel.ro*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rel.data       : { *(.rel.data .rel.data.* .rel.gnu.linkonce.d.*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rela.data      : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rel.tdata	  : { *(.rel.tdata .rel.tdata.* .rel.gnu.linkonce.td.*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rela.tdata	  : { *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rel.tbss	  : { *(.rel.tbss .rel.tbss.* .rel.gnu.linkonce.tb.*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rela.tbss	  : { *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rel.ctors      : { *(.rel.ctors) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rela.ctors     : { *(.rela.ctors) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rel.dtors      : { *(.rel.dtors) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rela.dtors     : { *(.rela.dtors) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rel.got        : { *(.rel.got) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rela.got       : { *(.rela.got) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rel.bss        : { *(.rel.bss .rel.bss.* .rel.gnu.linkonce.b.*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rela.bss       : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rel.plt        : { *(.rel.plt) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rela.plt       : { *(.rela.plt) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .init           :
  {
    KEEP (*(.init))
  } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC =0xd703d703
  .plt            : { *(.plt) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .text           :
  {
    *thirdparty_crt0.o
    *(.text .stub .text.* .gnu.linkonce.t.*)
    *(.exception .exception.*)
    KEEP (*(.text.*personality*))
    /* .gnu.warning sections are handled specially by elf32.em.  */
    *(.gnu.warning)
  } >FLASH_THIRDPARTY AT>FLASH_THIRDPARTY :FLASH_THIRDPARTY =0xd703d703
  .fini           :
  {
    KEEP (*(.fini))
  } >FLASH_THIRDPARTY AT>FLASH_THIRDPARTY :FLASH_THIRDPARTY =0xd703d703
  PROVIDE (__etext = .);
  PROVIDE (_etext = .);
  PROVIDE (etext = .);
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  .rodata1        : { *(.rodata1) } >FLASH_THIRDPARTY AT>FLASH_THIRDPARTY :FLASH_THIRDPARTY
  .eh_frame_hdr : { *(.eh_frame_hdr) } >FLASH_THIRDPARTY AT>FLASH_THIRDPARTY :FLASH_THIRDPARTY
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) } >FLASH_THIRDPARTY AT>FLASH_THIRDPARTY :FLASH_THIRDPARTY
  .gcc_except_table   : ONLY_IF_RO { KEEP (*(.gcc_except_table)) *(.gcc_except_table.*) } >FLASH_THIRDPARTY AT>FLASH_THIRDPARTY :FLASH_THIRDPARTY
  .lalign	: { . = ALIGN(8); PROVIDE(sec_data_lma = .); } >FLASH_SEC AT>FLASH_SEC :FLASH_SEC
  . = ORIGIN(INTRAM_SEC);
  .dalign	: { . = ALIGN(8); PROVIDE(sec_data = .); } >INTRAM_SEC AT>INTRAM_SEC :INTRAM_SEC_ALIGN
  /* Exception handling  */
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  .gcc_except_table   : ONLY_IF_RW { KEEP (*(.gcc_except_table)) *(.gcc_except_table.*) } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  /* Thread Local Storage sections  */
  .tdata	  : { *(.tdata .tdata.* .gnu.linkonce.td.*) } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  /* Ensure the __preinit_array_start label is properly aligned.  We
     could instead move the label definition inside the section, but
     the linker would then create the section even if it turns out to
     be empty, which isn't pretty.  */
  PROVIDE (__preinit_array_start = ALIGN(32 / 8));
  .preinit_array     : { KEEP (*(.preinit_array)) } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  PROVIDE (__preinit_array_end = .);
  PROVIDE (__init_array_start = .);
  .init_array     : { KEEP (*(.init_array)) } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  PROVIDE (__init_array_end = .);
  PROVIDE (__fini_array_start = .);
  .fini_array     : { KEEP (*(.fini_array)) } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  PROVIDE (__fini_array_end = .);
  .ctors          :
  {
    /* gcc uses crtbegin.o to find the start of
       the constructors, so we make sure it is
       first.  Because this is a wildcard, it
       doesn't matter if the user does not
       actually link against crtbegin.o; the
       linker won't look for a file to match a
       wildcard.  The wildcard also means that it
       doesn't matter which directory crtbegin.o
       is in.  */
    KEEP (*crtbegin*.o(.ctors))
    /* We don't want to include the .ctor section from
       from the crtend.o file until after the sorted ctors.
       The .ctor section from the crtend file contains the
       end of ctors marker and it must be last */
    KEEP (*(EXCLUDE_FILE (*crtend*.o ) .ctors))
    KEEP (*(SORT(.ctors.*)))
    KEEP (*(.ctors))
  } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  .dtors          :
  {
    KEEP (*crtbegin*.o(.dtors))
    KEEP (*(EXCLUDE_FILE (*crtend*.o ) .dtors))
    KEEP (*(SORT(.dtors.*)))
    KEEP (*(.dtors))
  } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  .jcr            : { KEEP (*(.jcr)) } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  .data.rel.ro : { *(.data.rel.ro.local) *(.data.rel.ro*) } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  .dynamic        : { *(.dynamic) } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  .got            : { *(.got.plt) *(.got) } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  .ramtext        : { *(.ramtext .ramtext.*) } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  .ddalign	: { . = ALIGN(8); } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  .sec_data       :
  {
    *(.sec_data .sec_data.*)
  } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  .balign	: { . = ALIGN(8); PROVIDE(_sec_edata = .); } >INTRAM_SEC AT>FLASH_SEC :INTRAM_SEC_AT_FLASH
  PROVIDE (sec_edata = .);
  sec_bss_start = .;
  .sec_bss        :
  {
    *(.sec_bss .sec_bss.*)
    /* Align here to ensure that the .bss section occupies space up to
       _end.  Align after .bss to ensure correct alignment even if the
       .bss section disappears because there are no input sections.  */
    . = ALIGN(8);
  } >INTRAM_SEC AT>INTRAM_SEC :INTRAM_SEC
  _sec_bss_end = .;
  PROVIDE (sec_bss_end = .);
  .sec_stack         ORIGIN(INTRAM_SEC) + LENGTH(INTRAM_SEC) - __sec_stack_size__ :
  {
    _sec_stack = .;
    *(.stack)
    . = __sec_stack_size__;
    _e_sec_stack = .;
  } >INTRAM_SEC AT>INTRAM_SEC :INTRAM_SEC
  .lalign2	: { . = ALIGN(8); PROVIDE(thirdparty_data_lma = .); } >FLASH_THIRDPARTY AT>FLASH_THIRDPARTY :FLASH_THIRDPARTY
  .thirdparty_data           :
  {
    PROVIDE (thirdparty_data = .);
    *(.data .data.* .thirdparty_data .thirdparty_data.*)
  } >INTRAM_THIRDPARTY AT>FLASH_THIRDPARTY :INTRAM_THIRDPARTY_AT_FLASH
  .data1          : { *(.data1) } >INTRAM_THIRDPARTY AT>FLASH_THIRDPARTY :INTRAM_THIRDPARTY_AT_FLASH
  .balign	: { . = ALIGN(8); PROVIDE(_thirdparty_edata = .); } >INTRAM_THIRDPARTY AT>FLASH_THIRDPARTY :INTRAM_THIRDPARTY_AT_FLASH
  PROVIDE (thirdparty_edata = .);
  thirdparty_bss_start = .;
  .bss            :
  {
    *(.dynbss)
    *(.bss .bss.* .gnu.linkonce.b.*)
    *(COMMON)
    /* Align here to ensure that the .bss section occupies space up to
       _end.  Align after .bss to ensure correct alignment even if the
       .bss section disappears because there are no input sections.  */
    . = ALIGN(8);
  } >INTRAM_THIRDPARTY AT>INTRAM_THIRDPARTY :INTRAM_THIRDPARTY
  . = ALIGN(8);
  _thirdparty_bss_end = .;
  PROVIDE (thirdparty_bss_end = .);
  __heap_start__ = ALIGN(8);
  .heap           :
  {
    *(.heap)
    . = (__heap_size__ == __max_heap_size__) ?
        ORIGIN(INTRAM_THIRDPARTY) + LENGTH(INTRAM_THIRDPARTY) - __stack_size__ - ABSOLUTE(.) :
        __heap_size__;
  } >INTRAM_THIRDPARTY AT>INTRAM_THIRDPARTY :INTRAM_THIRDPARTY
  __heap_end__ = .;
  /* Stabs debugging sections.  */
  .stab          0 : { *(.stab) }
  .stabstr       0 : { *(.stabstr) }
  .stab.excl     0 : { *(.stab.excl) }
  .stab.exclstr  0 : { *(.stab.exclstr) }
  .stab.index    0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .comment       0 : { *(.comment) }
  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  /* DWARF 2 */
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames  0 : { *(.debug_varnames) }
  .stack         ORIGIN(INTRAM_THIRDPARTY) + LENGTH(INTRAM_THIRDPARTY) - __stack_size__ :
  {
    _stack = .;
    *(.stack)
    . = __stack_size__;
    _estack = .;
  } >INTRAM_THIRDPARTY AT>INTRAM_THIRDPARTY :INTRAM_THIRDPARTY
  .userpage       : { *(.userpage .userpage.*) } >USERPAGE AT>USERPAGE :USERPAGE
  /DISCARD/ : { *(.note.GNU-stack) }
}
