/* This header file is part of the ATMEL AVR32-UC3-SoftwareFramework-1.6.0 Release */

/*This file has been prepared for Doxygen automatic documentation generation.*/
/*! \file *********************************************************************
 *
 * \brief AVR32 UC3L FlashVault basic example: FlashVault public API accessible
 * by a third-party application.
 *
 * - Compiler:           GCC for AVR32
 * - Supported devices:  All AVR32UC3 devices that implement a secure execution state.
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 ******************************************************************************/

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
 *
 */
#ifndef FLASHVAULT_H_INCLUDED
#define FLASHVAULT_H_INCLUDED

#include <avr32/io.h>
#include "board.h"


// As long as the ucr3 architecture is not supported by avr32-gcc, we have to insert
// sscall and retss calls using their opcode. Since these instructions are compact
// instructions, we insert a nop before them (because we'll use the .int gas directive).
#define INST_SSCALL             0xd703d753 // nop; sscall;
#define INST_RETSS              0xd703d763 // nop; retss;

//! The FlashVault sections size
//! @{
#define SECURE_FLASH_SIZE       0x400
#define SECURE_RAM_SIZE         0x400
//! @}

//! The FlashVault API: the vector ids to be set into R8 before calling SSCALL.
//! @{
#define FLASHVAULT_API_TGL_LED1  1
//! @}

#endif // FLASHVAULT_H_INCLUDED
