/* This file is part of the ATMEL AVR32-UC3-SoftwareFramework-1.6.0 Release */

/*This file is prepared for Doxygen automatic documentation generation.*/
/*! \file *********************************************************************
 *
 * \brief Exception and interrupt vectors.
 *
 * This file maps all events supported by an AVR32UC.
 *
 * - Compiler:           GNU GCC for AVR32
 * - Supported devices:  All AVR32UC devices with an INTC module can be used.
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 ******************************************************************************/

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
 *
 */

#include <avr32/io.h>


//! @{
//! \verbatim
  .section  .exception, "ax", @progbits


  // Start of Exception Vector Table.

  // EVBA must be aligned with a power of two strictly greater than the EVBA-
  // relative offset of the last vector.
  .balign 0x200
  // Export symbol.
  .global _evba
  .type _evba, @function
_evba:
    .org  0x000
    /* For all exceptions except the SCALL exception (offset 100h), go to exm */
    .rept   0x100 / 4
    pushm   r0-r12, lr          /* Save registers on the stack. */
    rjmp    exm
    .endr

    /* Specific for supervisor call - mapped in (_EVBA+100h) */
    pushm   r0-r12, lr          /* Save registers on the stack. */
    /* Set the parameters given to the handle_exception() function. */
    mov     r10, 0x100 / 4      /* R10 <- Exception cause == (EVBA offset of the exception)>>2 */
    lddsp   r11, sp[14*4+4]     /* R11 <- Address of the offending instruction */
    sub     r12, sp, -14*4      /* R12 <- Ptr to sp before the pushm we just did */
    call    handle_exception    /* Handle the exception now */
    popm    r0-r12, lr          /* Restore registers. */
    rets                        /* Return from SCALL. */

    exm:                        /* All other exceptions */
    mfsr    r10, AVR32_ECR      /* R10 <- AVR32_ECR (exception cause register) */
    lddsp   r11, sp[14*4+4]     /* R11 <- Address of the offending instruction */
    sub     r12, sp, -14*4      /* R12 <- Ptr to sp before the pushm we just did */
    call    handle_exception    /* Handle the exception now */
    popm    r0-r12, lr          /* Restore registers. */
    rete                        /* Return from exception. */


//! \endverbatim
//! @}
