/* This source file is part of the ATMEL AVR32-UC3-SoftwareFramework-1.6.0 Release */

/*! \page License
 * Copyright (C) 2009, H&D Wireless AB All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of H&D Wireless AB may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY H&D WIRELESS AB ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY AND
 * SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "top_defs.h"
#include "util.h"
#include "wl_util.h"
#include <stdio.h>
#include <errno.h>
#include <string.h>

char* ip2str(struct ip_addr addr)
{
        static char buf[16];
        sniprintf(buf, sizeof(buf), "%lu.%lu.%lu.%lu",
                 (addr.addr >> 24) & 0xff,
                 (addr.addr >> 16) & 0xff,
                 (addr.addr >> 8) & 0xff,
                 (addr.addr) & 0xff);
        return buf;
}

struct ip_addr str2ip(const char* str)
{
        int a,b,c,d;
        uint32_t ip = 0;

        if (siscanf(str,"%d.%d.%d.%d",&a,&b,&c,&d) != 4)
                goto out;

        if (a < 0 || a > 255 || b < 0 || b > 255 ||
            c < 0 || c > 255 || d < 0 || d > 255)
                goto out;
        
        ip = (a << 24) | (b << 16) | (c << 8) | d;

 out:
        return *(struct ip_addr*) &ip;
}

void print_network(struct wl_network_t* wl_network)
{
        char ssid[WL_SSID_MAX_LENGTH + 1];
        printk("%s ", mac2str(wl_network->bssid.octet));
        memset(ssid, 0, sizeof(ssid));
        if (wl_network->ssid.len) {
                strncpy(ssid, wl_network->ssid.ssid, wl_network->ssid.len);
                printk("\"%s\"", ssid);
        }
        else {
                printk("\"\"");
        }
        printk(" RSSI %d dBm ", wl_network->rssi);
        switch (wl_network->enc_type) {
        case ENC_TYPE_WEP :
                printk(" (WEP encryption)");
                break;
        case ENC_TYPE_TKIP :
                printk(" (TKIP encryption)");
                break;
        case ENC_TYPE_CCMP :
                printk(" (CCMP encryption)");
                break;
        case ENC_TYPE_NONE :
                break;
        }
        printk("\n");
}

void print_network_list(void)
{
        struct wl_network_t* wl_network_list;
        uint8_t wl_network_cnt, i;
        
        wl_get_network_list(&wl_network_list, &wl_network_cnt);
        if (wl_network_cnt == 0)
                printk("no nets found\n");

        for (i = 0; i < wl_network_cnt; i++)
                print_network(&wl_network_list[i]);
}
