/* This header file is part of the ATMEL AVR32-UC3-SoftwareFramework-1.6.0 Release */

// This file has been prepared for Doxygen automatic documentation generation.

#ifndef _CONF_RTOUCH_H_
#define _CONF_RTOUCH_H_

/*============================ DEFINES =======================================*/

//! Sample count per signal line.
#define RTOUCH_OVERSAMPLING 4
//! Number of right shifts required to scale down to 10 bits after oversampling.
#define RTOUCH_SAMPLESCALE 2

//! Deepest sleep mode allowed when waiting for touch detect.
#define TOUCH_DETECT_SLEEP_MODE SLEEPMGR_SAVE
//! Deepest sleep mode allowed when sampling.
#define TOUCH_SAMPLE_SLEEP_MODE SLEEPMGR_IDLE


//! Set to 1 if soft IRQs are used for raw sample processing.
#define TOUCH_USE_SOFTIRQ 0
//! Which soft IRQ to use for raw sample processing.
#define TOUCH_SAMPLE_IRQ SOFTIRQ_TOUCH

//! Set to 0 if the timer module should be used for delayed resampling.
#define TOUCH_USE_IMMEDIATE_RESAMPLE 1



/*============================ PLATFORM DEPENDENT DEFINES ====================*/

#define RTOUCH_ADC_INT_LEVEL	1
#define RTOUCH_ADC_IRQ		AVR32_ADC_IRQ

//! IO pin used for XL line.
#define RTOUCH_XL_PIN		AVR32_ADC_AD_4_PIN //PA25
#define RTOUCH_XL_PIN_FUNCTION	AVR32_ADC_AD_4_FUNCTION
//! ADC channel number for XL
#define RTOUCH_ADC_XL_CHANNEL	(1 << 4)

//! IO pin used for XH line.
#define RTOUCH_XH_PIN		AVR32_ADC_AD_6_PIN //PA27
#define RTOUCH_XH_PIN_FUNCTION	AVR32_ADC_AD_6_FUNCTION
#define RTOUCH_ADC_XH_CHANNEL	(1 << 6)

//! IO pin used for YL line.
#define RTOUCH_YL_PIN		AVR32_ADC_AD_5_PIN //PA26
#define RTOUCH_YL_PIN_FUNCTION	AVR32_ADC_AD_5_FUNCTION
#define RTOUCH_ADC_YL_CHANNEL	(1 << 5)

//! IO pin used for YH line.
#define RTOUCH_YH_PIN		AVR32_ADC_AD_7_PIN //PA28
#define RTOUCH_YH_PIN_FUNCTION	AVR32_ADC_AD_7_FUNCTION
#define RTOUCH_ADC_YH_CHANNEL	(1 << 7)

//! AVR32 ADC module used for touch panel sampling.
#define RTOUCH_ADC		AVR32_ADC


/*============================ MACROS ========================================*/

#endif
/* EOF */
