/* This header file is part of the ATMEL AVR32-UC3-SoftwareFramework-1.6.0 Release */

/*This file has been prepared for Doxygen automatic documentation generation.*/
/*! \file *********************************************************************
 *
 * \brief NAND flash GPIO driver for AVR32 with local bus support.
 *
 * This file contains data for the example for NAND flash GPIO driver.
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All AVR32 devices with a CPU local bus can be used.
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 *****************************************************************************/

/* Copyright (c) 2008, Atmel Corporation All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of ATMEL may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY AND
 * SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _NAND_GPIO_EXAMPLE_DATA_H
#define _NAND_GPIO_EXAMPLE_DATA_H

#define NAND_GPIO_EXAMPLE_DATA_SIZE	8192

const unsigned char data[NAND_GPIO_EXAMPLE_DATA_SIZE] = {
	19,	189,	188,	189,	210,	88,	186,	209,	48,	76,
	195,	217,	8,	0,	213,	37,	26,	243,	160,	236,
	215,	165,	146,	52,	40,	20,	143,	108,	211,	73,
	137,	65,	38,	57,	104,	49,	59,	67,	222,	185,
	97,	196,	235,	111,	122,	30,	119,	170,	90,	183,
	197,	101,	240,	59,	196,	186,	191,	233,	89,	164,
	114,	75,	28,	92,	205,	255,	235,	249,	148,	214,
	5,	185,	229,	249,	152,	9,	244,	58,	106,	188,
	26,	1,	202,	115,	97,	2,	78,	145,	26,	146,
	42,	21,	139,	160,	154,	73,	65,	41,	189,	109,
	94,	201,	40,	157,	46,	219,	136,	185,	22,	123,
	234,	252,	55,	121,	21,	224,	31,	180,	170,	210,
	58,	127,	139,	242,	17,	43,	20,	198,	95,	253,
	227,	142,	55,	169,	228,	215,	136,	53,	170,	77,
	177,	194,	165,	205,	168,	17,	123,	71,	182,	77,
	129,	192,	25,	78,	161,	16,	56,	206,	18,	72,
	234,	160,	164,	253,	188,	74,	241,	171,	22,	138,
	89,	233,	67,	94,	133,	73,	236,	230,	10,	8,
	18,	23,	98,	22,	253,	185,	250,	121,	12,	241,
	242,	78,	152,	29,	41,	38,	174,	141,	129,	52,
	209,	91,	3,	73,	84,	48,	51,	107,	11,	38,
	241,	110,	172,	67,	87,	181,	73,	23,	214,	34,
	161,	200,	35,	229,	69,	80,	230,	128,	143,	135,
	193,	51,	253,	176,	19,	178,	118,	73,	29,	213,
	213,	212,	186,	47,	253,	151,	119,	47,	50,	87,
	207,	112,	143,	181,	149,	173,	71,	83,	147,	249,
	95,	6,	57,	228,	187,	244,	62,	87,	168,	88,
	149,	218,	173,	89,	33,	12,	208,	109,	60,	165,
	8,	65,	250,	181,	102,	241,	150,	68,	138,	194,
	189,	181,	38,	124,	207,	84,	174,	241,	192,	80,
	61,	82,	22,	175,	148,	125,	159,	99,	3,	143,
	102,	20,	113,	29,	91,	207,	199,	200,	19,	231,
	9,	1,	151,	17,	27,	195,	198,	122,	76,	195,
	222,	63,	182,	223,	78,	34,	83,	235,	74,	241,
	5,	43,	166,	217,	185,	123,	240,	249,	184,	184,
	227,	97,	212,	68,	188,	159,	56,	133,	217,	90,
	192,	42,	244,	53,	189,	113,	149,	172,	65,	50,
	43,	225,	224,	203,	219,	177,	199,	6,	182,	134,
	52,	16,	112,	222,	106,	178,	246,	141,	50,	204,
	144,	244,	27,	99,	204,	8,	39,	200,	232,	58,
	23,	191,	120,	219,	121,	249,	202,	184,	26,	14,
	231,	99,	174,	157,	23,	235,	128,	215,	77,	168,
	91,	97,	172,	167,	160,	202,	79,	172,	32,	223,
	44,	254,	236,	48,	92,	11,	98,	149,	112,	201,
	49,	180,	54,	80,	86,	9,	154,	113,	105,	41,
	144,	190,	102,	48,	210,	56,	151,	143,	54,	249,
	29,	242,	93,	127,	194,	96,	49,	111,	107,	213,
	220,	161,	252,	84,	152,	168,	69,	14,	92,	192,
	11,	85,	108,	236,	59,	222,	94,	139,	97,	15,
	55,	112,	49,	64,	237,	161,	128,	199,	170,	55,
	225,	41,	231,	172,	37,	206,	139,	67,	192,	193,
	99,	65,	23,	20,	220,	92,	228,	120,	194,	106,
	135,	117,	184,	21,	246,	220,	106,	141,	109,	113,
	174,	26,	108,	207,	56,	135,	61,	208,	179,	192,
	8,	177,	204,	62,	10,	252,	129,	189,	212,	216,
	26,	111,	210,	168,	211,	161,	189,	190,	134,	204,
	226,	192,	5,	43,	231,	182,	242,	15,	14,	55,
	15,	139,	182,	73,	56,	25,	183,	15,	146,	162,
	158,	101,	213,	81,	247,	31,	85,	226,	64,	207,
	151,	223,	34,	236,	132,	153,	183,	18,	106,	63,
	141,	73,	35,	62,	163,	177,	226,	179,	158,	240,
	246,	17,	181,	201,	129,	70,	14,	217,	51,	9,
	82,	31,	61,	219,	14,	20,	58,	191,	155,	222,
	250,	52,	169,	162,	47,	150,	158,	89,	96,	80,
	97,	86,	106,	84,	97,	228,	137,	137,	125,	89,
	110,	139,	165,	185,	21,	178,	25,	10,	24,	242,
	91,	198,	133,	117,	108,	3,	44,	59,	132,	215,
	53,	101,	194,	77,	11,	126,	3,	184,	212,	114,
	22,	209,	27,	166,	15,	135,	148,	79,	209,	131,
	191,	147,	184,	105,	149,	153,	74,	80,	100,	84,
	171,	33,	50,	219,	38,	199,	160,	83,	58,	104,
	33,	178,	125,	151,	42,	180,	15,	37,	50,	121,
	189,	226,	117,	64,	100,	9,	20,	197,	130,	64,
	96,	106,	248,	210,	5,	198,	127,	179,	29,	195,
	77,	163,	21,	221,	32,	82,	152,	222,	139,	10,
	218,	48,	30,	117,	200,	236,	15,	110,	243,	220,
	253,	107,	151,	180,	24,	14,	54,	157,	35,	167,
	114,	136,	242,	220,	106,	171,	96,	239,	104,	94,
	163,	248,	234,	174,	98,	85,	181,	125,	178,	162,
	153,	209,	77,	138,	197,	99,	70,	200,	242,	134,
	119,	6,	170,	213,	227,	150,	211,	158,	75,	223,
	0,	38,	3,	31,	173,	0,	27,	162,	228,	23,
	175,	220,	176,	31,	39,	194,	215,	143,	132,	28,
	240,	80,	154,	8,	80,	185,	7,	56,	183,	38,
	55,	211,	75,	170,	114,	40,	199,	228,	29,	244,
	72,	45,	71,	143,	62,	155,	37,	79,	175,	146,
	85,	132,	239,	132,	228,	200,	128,	120,	168,	12,
	30,	235,	99,	137,	109,	209,	71,	122,	78,	220,
	140,	59,	70,	65,	107,	59,	169,	94,	47,	25,
	190,	35,	140,	254,	16,	203,	23,	213,	89,	192,
	126,	66,	173,	165,	199,	20,	30,	12,	8,	27,
	223,	8,	220,	40,	53,	252,	76,	161,	236,	5,
	184,	183,	30,	209,	80,	26,	238,	62,	85,	37,
	119,	103,	110,	0,	80,	13,	237,	139,	131,	203,
	50,	110,	57,	157,	33,	218,	232,	7,	238,	81,
	244,	250,	253,	9,	164,	255,	70,	175,	125,	6,
	136,	182,	18,	43,	172,	157,	240,	211,	169,	47,
	76,	107,	63,	241,	128,	243,	78,	209,	104,	210,
	191,	174,	122,	153,	211,	234,	117,	148,	21,	169,
	78,	150,	24,	75,	177,	36,	132,	64,	160,	235,
	243,	236,	201,	19,	201,	47,	229,	7,	164,	101,
	155,	238,	54,	5,	228,	235,	4,	18,	106,	186,
	6,	236,	181,	171,	154,	226,	121,	244,	150,	209,
	92,	36,	111,	240,	23,	19,	230,	7,	8,	202,
	223,	233,	60,	220,	30,	35,	107,	211,	59,	93,
	160,	5,	155,	165,	143,	161,	85,	65,	40,	230,
	77,	165,	116,	79,	152,	158,	82,	243,	209,	182,
	8,	70,	180,	31,	115,	224,	53,	182,	32,	188,
	221,	215,	191,	189,	74,	159,	199,	224,	51,	81,
	203,	216,	60,	65,	144,	142,	8,	169,	19,	60,
	199,	142,	246,	140,	42,	145,	12,	132,	49,	140,
	166,	44,	131,	121,	221,	247,	104,	255,	219,	26,
	191,	190,	54,	70,	248,	212,	101,	219,	66,	148,
	109,	205,	49,	205,	245,	156,	58,	39,	88,	90,
	100,	181,	224,	156,	14,	243,	35,	33,	230,	228,
	191,	168,	115,	222,	191,	67,	114,	69,	112,	20,
	61,	178,	4,	245,	68,	13,	135,	38,	194,	142,
	161,	137,	248,	239,	147,	2,	142,	88,	53,	34,
	52,	14,	34,	121,	247,	103,	159,	26,	125,	80,
	66,	128,	74,	72,	86,	192,	180,	67,	137,	235,
	110,	231,	190,	139,	235,	244,	193,	66,	245,	137,
	242,	41,	220,	83,	45,	145,	195,	131,	177,	235,
	210,	169,	224,	129,	222,	113,	95,	204,	170,	221,
	151,	34,	199,	46,	226,	98,	130,	18,	79,	222,
	133,	214,	222,	44,	87,	92,	144,	193,	42,	153,
	51,	181,	40,	57,	146,	185,	34,	17,	37,	134,
	239,	68,	233,	24,	122,	132,	245,	241,	168,	54,
	165,	197,	195,	255,	115,	130,	62,	130,	162,	4,
	149,	27,	114,	53,	215,	183,	1,	60,	230,	39,
	21,	155,	177,	247,	184,	128,	100,	37,	16,	77,
	202,	129,	169,	155,	58,	99,	186,	121,	142,	49,
	228,	196,	177,	7,	246,	183,	92,	201,	57,	113,
	127,	51,	180,	110,	141,	7,	18,	45,	220,	95,
	62,	108,	136,	79,	31,	113,	67,	162,	25,	195,
	199,	28,	10,	156,	54,	202,	185,	143,	30,	227,
	133,	125,	242,	196,	165,	253,	131,	226,	89,	32,
	62,	11,	203,	126,	104,	59,	172,	208,	231,	230,
	163,	127,	213,	252,	206,	135,	192,	21,	104,	220,
	148,	109,	228,	28,	205,	139,	185,	23,	110,	148,
	28,	72,	134,	178,	228,	235,	174,	149,	82,	86,
	130,	200,	177,	103,	113,	93,	51,	243,	197,	138,
	157,	87,	151,	18,	29,	75,	44,	1,	199,	196,
	106,	91,	28,	148,	59,	64,	83,	78,	30,	216,
	77,	188,	134,	166,	255,	64,	201,	220,	227,	85,
	20,	19,	18,	242,	213,	151,	231,	49,	210,	179,
	234,	245,	140,	5,	139,	123,	244,	219,	248,	75,
	151,	19,	240,	234,	86,	159,	169,	135,	212,	43,
	39,	39,	198,	55,	149,	43,	52,	93,	213,	12,
	191,	106,	222,	29,	212,	71,	193,	109,	223,	220,
	46,	134,	86,	156,	109,	33,	246,	141,	213,	239,
	190,	137,	221,	62,	155,	22,	124,	139,	192,	79,
	198,	159,	163,	175,	213,	58,	233,	199,	52,	251,
	43,	192,	17,	241,	54,	151,	86,	44,	3,	139,
	153,	44,	103,	16,	196,	60,	123,	121,	28,	205,
	184,	131,	66,	108,	99,	225,	105,	198,	92,	133,
	0,	29,	251,	185,	6,	28,	42,	88,	186,	87,
	195,	49,	217,	181,	188,	146,	125,	197,	116,	163,
	11,	252,	239,	167,	150,	111,	119,	61,	85,	94,
	75,	117,	39,	147,	168,	147,	250,	126,	60,	225,
	75,	205,	217,	166,	86,	58,	179,	135,	123,	118,
	238,	85,	179,	86,	123,	125,	144,	139,	157,	218,
	123,	226,	212,	138,	183,	21,	184,	139,	53,	96,
	3,	196,	36,	58,	243,	44,	184,	26,	243,	154,
	157,	121,	165,	160,	45,	23,	147,	100,	40,	84,
	31,	69,	111,	37,	41,	191,	114,	187,	217,	77,
	84,	65,	143,	12,	188,	59,	77,	38,	69,	249,
	195,	130,	54,	15,	246,	246,	254,	12,	96,	138,
	38,	68,	233,	243,	167,	123,	242,	226,	14,	62,
	146,	64,	207,	144,	117,	134,	169,	246,	134,	67,
	188,	8,	227,	66,	107,	96,	196,	118,	98,	38,
	103,	9,	98,	175,	103,	60,	126,	21,	29,	253,
	201,	200,	70,	244,	253,	78,	239,	76,	245,	189,
	196,	147,	151,	245,	226,	35,	232,	6,	152,	195,
	232,	192,	12,	96,	81,	96,	56,	94,	205,	238,
	204,	155,	90,	231,	91,	217,	196,	227,	165,	136,
	57,	98,	119,	183,	212,	24,	128,	128,	48,	8,
	136,	55,	54,	245,	169,	139,	2,	196,	63,	57,
	96,	83,	128,	157,	49,	225,	4,	115,	70,	195,
	255,	187,	147,	90,	96,	107,	189,	92,	126,	61,
	171,	119,	235,	243,	28,	158,	247,	146,	184,	88,
	62,	129,	132,	152,	105,	236,	199,	205,	153,	103,
	164,	35,	10,	1,	188,	92,	58,	64,	114,	106,
	86,	144,	172,	248,	68,	208,	79,	166,	246,	175,
	229,	154,	89,	35,	241,	39,	81,	79,	45,	1,
	48,	40,	11,	228,	99,	237,	231,	94,	144,	199,
	152,	192,	250,	250,	172,	178,	111,	238,	180,	76,
	48,	7,	87,	200,	145,	189,	99,	73,	81,	52,
	187,	181,	104,	65,	201,	160,	48,	56,	147,	79,
	226,	159,	189,	94,	56,	7,	25,	80,	75,	48,
	212,	4,	86,	145,	148,	224,	44,	16,	54,	150,
	104,	156,	60,	212,	80,	113,	117,	215,	40,	198,
	204,	225,	118,	157,	43,	1,	10,	246,	27,	89,
	57,	60,	66,	134,	68,	229,	7,	214,	109,	112,
	211,	56,	128,	160,	223,	239,	251,	13,	247,	32,
	62,	147,	59,	180,	221,	133,	65,	252,	60,	66,
	194,	129,	14,	183,	161,	31,	187,	89,	15,	241,
	242,	230,	72,	2,	210,	112,	164,	223,	225,	184,
	74,	250,	200,	150,	107,	64,	255,	155,	82,	243,
	141,	58,	212,	180,	135,	244,	84,	63,	83,	88,
	23,	96,	138,	197,	74,	208,	23,	219,	135,	120,
	206,	227,	2,	51,	117,	200,	144,	114,	203,	111,
	185,	242,	221,	190,	63,	11,	78,	182,	136,	105,
	76,	246,	68,	23,	186,	151,	164,	65,	112,	173,
	11,	85,	95,	241,	33,	118,	165,	60,	217,	70,
	249,	13,	210,	172,	19,	105,	124,	150,	105,	151,
	55,	87,	132,	206,	26,	245,	229,	112,	164,	77,
	10,	20,	252,	57,	126,	210,	56,	46,	223,	229,
	49,	90,	167,	195,	34,	169,	177,	129,	32,	34,
	151,	66,	154,	126,	194,	21,	43,	213,	0,	73,
	146,	100,	187,	221,	71,	137,	90,	198,	202,	52,
	88,	94,	5,	26,	124,	87,	185,	223,	22,	78,
	29,	164,	243,	247,	131,	160,	198,	55,	223,	162,
	52,	219,	110,	244,	105,	205,	251,	190,	178,	232,
	174,	202,	122,	255,	118,	63,	58,	9,	111,	29,
	164,	132,	95,	15,	17,	117,	25,	123,	241,	160,
	17,	226,	50,	233,	16,	198,	30,	92,	1,	141,
	69,	24,	56,	233,	245,	219,	222,	44,	242,	153,
	49,	7,	103,	194,	126,	123,	86,	155,	29,	126,
	182,	90,	9,	92,	233,	7,	248,	222,	112,	135,
	254,	254,	176,	156,	175,	100,	9,	92,	224,	162,
	138,	129,	175,	186,	5,	63,	31,	156,	160,	97,
	247,	25,	123,	242,	109,	25,	22,	10,	101,	38,
	251,	40,	92,	139,	49,	179,	78,	82,	131,	57,
	197,	192,	239,	0,	187,	115,	77,	81,	111,	108,
	143,	167,	78,	122,	170,	200,	186,	253,	129,	9,
	137,	122,	240,	75,	171,	231,	18,	58,	55,	202,
	102,	56,	66,	119,	45,	216,	255,	112,	196,	90,
	18,	231,	8,	249,	35,	17,	10,	233,	250,	96,
	96,	235,	6,	232,	162,	12,	43,	235,	174,	140,
	8,	170,	18,	212,	50,	242,	189,	94,	160,	50,
	174,	53,	250,	204,	241,	238,	138,	66,	185,	138,
	8,	25,	17,	236,	118,	234,	14,	27,	177,	60,
	186,	36,	202,	80,	143,	139,	107,	230,	118,	191,
	193,	179,	6,	87,	164,	171,	243,	233,	252,	28,
	217,	213,	126,	180,	221,	99,	85,	135,	31,	222,
	51,	241,	222,	225,	150,	83,	117,	140,	219,	150,
	168,	233,	205,	222,	51,	171,	118,	102,	219,	121,
	149,	64,	224,	87,	177,	186,	18,	147,	60,	20,
	132,	226,	241,	77,	109,	61,	68,	99,	63,	105,
	191,	187,	0,	132,	214,	129,	134,	76,	166,	192,
	182,	82,	135,	216,	84,	80,	94,	51,	122,	115,
	7,	65,	172,	70,	194,	135,	61,	53,	191,	211,
	254,	176,	68,	110,	143,	216,	67,	114,	227,	21,
	255,	240,	26,	133,	234,	53,	211,	73,	45,	230,
	44,	209,	98,	162,	247,	76,	115,	225,	94,	164,
	90,	66,	187,	24,	152,	194,	85,	61,	48,	127,
	47,	89,	152,	135,	189,	197,	99,	51,	200,	17,
	179,	201,	202,	219,	106,	232,	25,	182,	103,	234,
	76,	232,	40,	214,	112,	104,	121,	116,	104,	29,
	175,	151,	255,	133,	181,	139,	129,	230,	88,	96,
	105,	72,	192,	70,	131,	111,	28,	242,	72,	236,
	57,	115,	162,	141,	184,	219,	12,	94,	90,	237,
	106,	95,	164,	219,	140,	50,	131,	146,	107,	89,
	154,	166,	149,	157,	12,	233,	251,	46,	103,	218,
	30,	218,	206,	128,	223,	35,	172,	166,	136,	198,
	2,	171,	95,	94,	244,	20,	17,	21,	122,	36,
	34,	245,	198,	215,	58,	16,	192,	125,	162,	40,
	74,	180,	65,	138,	240,	196,	233,	165,	44,	107,
	68,	55,	13,	102,	164,	14,	144,	199,	113,	49,
	64,	112,	156,	18,	34,	21,	116,	119,	154,	74,
	103,	87,	43,	103,	212,	61,	250,	10,	250,	244,
	46,	13,	97,	2,	15,	252,	207,	103,	84,	32,
	240,	69,	219,	62,	243,	55,	173,	78,	219,	185,
	125,	162,	179,	140,	91,	29,	68,	83,	6,	243,
	194,	235,	12,	86,	104,	174,	132,	72,	223,	11,
	87,	172,	79,	33,	145,	36,	166,	43,	42,	188,
	219,	49,	109,	131,	41,	227,	3,	75,	135,	98,
	105,	109,	249,	74,	72,	99,	213,	49,	242,	203,
	250,	162,	96,	202,	172,	28,	54,	211,	45,	137,
	194,	51,	174,	158,	20,	199,	143,	232,	76,	79,
	193,	30,	57,	44,	164,	41,	178,	215,	82,	33,
	195,	105,	37,	156,	247,	96,	47,	69,	127,	141,
	240,	199,	15,	41,	39,	189,	189,	156,	246,	22,
	112,	144,	219,	118,	27,	78,	173,	217,	130,	197,
	142,	94,	225,	0,	200,	161,	2,	49,	127,	182,
	122,	131,	21,	228,	86,	109,	124,	218,	142,	238,
	198,	169,	247,	130,	177,	114,	247,	8,	231,	98,
	249,	237,	138,	143,	4,	25,	75,	54,	0,	174,
	1,	210,	76,	21,	178,	192,	200,	5,	152,	61,
	172,	126,	104,	100,	232,	92,	6,	129,	131,	59,
	40,	223,	240,	170,	128,	186,	6,	15,	229,	198,
	248,	174,	107,	94,	123,	222,	194,	198,	252,	151,
	162,	75,	102,	212,	38,	196,	88,	201,	211,	176,
	233,	33,	98,	24,	160,	101,	12,	87,	120,	100,
	176,	83,	104,	225,	43,	143,	223,	121,	10,	231,
	146,	69,	44,	142,	153,	238,	157,	109,	181,	254,
	74,	119,	81,	227,	232,	137,	124,	246,	151,	170,
	1,	230,	119,	249,	150,	193,	205,	25,	110,	195,
	29,	93,	224,	197,	12,	74,	196,	94,	69,	125,
	171,	104,	69,	21,	236,	223,	80,	99,	230,	68,
	224,	169,	212,	68,	160,	165,	194,	177,	143,	72,
	198,	127,	37,	23,	29,	79,	12,	54,	235,	99,
	2,	175,	200,	237,	21,	36,	205,	19,	138,	183,
	38,	124,	3,	232,	48,	13,	50,	187,	78,	6,
	4,	132,	241,	8,	121,	244,	133,	167,	178,	84,
	199,	71,	222,	68,	227,	173,	140,	38,	10,	128,
	206,	86,	123,	60,	239,	47,	237,	71,	212,	128,
	79,	42,	23,	76,	246,	5,	186,	37,	87,	212,
	176,	159,	250,	231,	15,	34,	10,	145,	113,	92,
	201,	76,	107,	231,	43,	214,	175,	173,	140,	202,
	221,	206,	99,	181,	40,	235,	16,	204,	213,	80,
	32,	165,	29,	1,	202,	197,	16,	70,	154,	2,
	145,	53,	78,	28,	101,	65,	62,	120,	161,	24,
	64,	215,	152,	132,	85,	100,	155,	98,	165,	157,
	155,	104,	61,	66,	182,	63,	166,	7,	255,	230,
	225,	212,	18,	159,	4,	143,	134,	37,	3,	36,
	30,	179,	54,	67,	36,	200,	221,	113,	207,	202,
	201,	77,	253,	118,	131,	202,	110,	119,	42,	100,
	117,	63,	35,	169,	54,	10,	117,	146,	191,	231,
	229,	140,	72,	75,	116,	48,	234,	67,	62,	161,
	18,	7,	85,	159,	126,	55,	170,	117,	91,	75,
	0,	85,	141,	233,	50,	5,	126,	108,	64,	241,
	103,	143,	23,	89,	57,	130,	15,	137,	55,	54,
	88,	254,	33,	199,	241,	184,	62,	190,	53,	126,
	77,	85,	238,	221,	247,	141,	70,	128,	236,	23,
	229,	147,	200,	195,	208,	130,	199,	254,	210,	195,
	213,	54,	255,	104,	248,	134,	105,	86,	172,	10,
	148,	216,	236,	105,	127,	34,	255,	80,	227,	160,
	78,	85,	36,	18,	98,	254,	197,	93,	3,	100,
	137,	159,	221,	30,	74,	226,	121,	214,	113,	71,
	56,	44,	140,	56,	217,	150,	46,	232,	213,	119,
	145,	29,	143,	141,	226,	2,	81,	58,	243,	74,
	254,	196,	80,	65,	105,	185,	116,	205,	86,	76,
	194,	130,	191,	133,	215,	136,	125,	198,	27,	246,
	8,	40,	133,	201,	159,	58,	142,	222,	107,	143,
	7,	197,	4,	21,	132,	11,	46,	86,	55,	221,
	182,	173,	234,	217,	81,	70,	254,	59,	179,	64,
	140,	46,	207,	13,	129,	175,	150,	107,	182,	226,
	35,	25,	146,	123,	73,	139,	155,	156,	156,	110,
	178,	91,	176,	251,	53,	137,	128,	225,	173,	187,
	6,	85,	232,	173,	216,	103,	170,	142,	116,	3,
	17,	47,	243,	94,	114,	2,	20,	53,	40,	153,
	244,	92,	7,	193,	124,	83,	186,	109,	243,	130,
	51,	43,	69,	78,	83,	177,	201,	233,	75,	96,
	245,	80,	50,	29,	219,	92,	155,	65,	65,	140,
	112,	19,	159,	67,	80,	190,	188,	28,	16,	254,
	221,	173,	189,	142,	244,	244,	7,	235,	244,	253,
	109,	123,	212,	77,	7,	19,	45,	186,	217,	9,
	216,	218,	33,	183,	60,	45,	243,	202,	169,	117,
	211,	71,	7,	90,	34,	49,	227,	161,	110,	133,
	93,	53,	146,	172,	150,	255,	117,	248,	224,	11,
	99,	183,	49,	10,	184,	42,	108,	28,	134,	203,
	149,	3,	22,	93,	124,	44,	134,	95,	116,	155,
	106,	17,	93,	19,	229,	187,	121,	54,	157,	31,
	101,	254,	110,	132,	76,	215,	209,	54,	40,	183,
	190,	90,	224,	157,	34,	21,	47,	133,	48,	121,
	32,	157,	197,	102,	116,	96,	10,	182,	248,	45,
	181,	188,	249,	172,	185,	188,	64,	42,	77,	203,
	44,	55,	51,	226,	30,	239,	179,	200,	171,	238,
	22,	86,	230,	175,	127,	241,	39,	148,	84,	85,
	167,	88,	216,	101,	131,	122,	86,	132,	174,	228,
	75,	102,	122,	106,	1,	171,	71,	56,	198,	223,
	143,	89,	125,	248,	153,	89,	65,	78,	54,	197,
	241,	212,	5,	197,	236,	19,	168,	206,	176,	105,
	24,	81,	192,	170,	193,	15,	168,	155,	211,	141,
	120,	97,	82,	187,	59,	92,	61,	179,	101,	155,
	30,	255,	163,	47,	173,	186,	18,	51,	223,	128,
	204,	191,	134,	197,	200,	148,	55,	128,	110,	142,
	11,	90,	136,	13,	212,	90,	223,	195,	106,	227,
	49,	86,	9,	190,	238,	84,	141,	143,	236,	30,
	94,	71,	84,	59,	199,	6,	141,	31,	70,	85,
	172,	155,	106,	235,	64,	195,	175,	68,	231,	174,
	83,	68,	158,	6,	194,	87,	103,	152,	68,	77,
	101,	175,	67,	154,	153,	224,	253,	169,	131,	181,
	201,	105,	213,	182,	127,	240,	183,	146,	154,	1,
	74,	32,	21,	5,	254,	146,	48,	140,	146,	218,
	88,	162,	147,	38,	54,	61,	34,	93,	159,	19,
	128,	244,	156,	248,	47,	224,	111,	156,	147,	122,
	104,	148,	230,	151,	154,	103,	39,	220,	225,	85,
	24,	84,	73,	141,	143,	45,	124,	10,	248,	254,
	147,	84,	252,	207,	38,	15,	29,	34,	142,	100,
	110,	130,	227,	105,	191,	93,	185,	146,	92,	220,
	48,	7,	127,	83,	164,	228,	30,	184,	186,	71,
	250,	7,	195,	213,	93,	94,	57,	176,	21,	73,
	223,	69,	234,	197,	132,	36,	172,	198,	117,	215,
	177,	26,	172,	25,	59,	73,	215,	16,	91,	102,
	85,	215,	237,	28,	174,	32,	190,	138,	61,	84,
	119,	216,	140,	47,	57,	18,	212,	99,	242,	117,
	218,	233,	139,	42,	117,	45,	92,	207,	251,	59,
	118,	111,	5,	20,	130,	198,	155,	168,	62,	239,
	1,	250,	191,	255,	55,	115,	46,	5,	197,	64,
	218,	124,	82,	230,	170,	195,	184,	195,	253,	105,
	59,	29,	131,	232,	21,	33,	96,	142,	218,	49,
	231,	82,	121,	2,	230,	28,	207,	1,	27,	128,
	109,	68,	185,	168,	242,	109,	234,	237,	10,	156,
	244,	115,	20,	115,	253,	119,	201,	223,	247,	156,
	30,	122,	215,	183,	237,	130,	21,	106,	47,	134,
	137,	165,	20,	146,	94,	2,	0,	206,	2,	75,
	96,	124,	92,	146,	158,	149,	11,	44,	59,	235,
	148,	138,	107,	104,	182,	125,	29,	12,	241,	49,
	137,	195,	22,	195,	246,	101,	19,	191,	248,	195,
	9,	229,	59,	9,	124,	98,	43,	226,	63,	101,
	6,	66,	106,	120,	53,	31,	160,	181,	249,	34,
	44,	38,	22,	212,	61,	221,	226,	112,	236,	59,
	30,	78,	234,	62,	196,	15,	13,	140,	24,	55,
	174,	231,	221,	107,	36,	246,	120,	43,	122,	38,
	168,	192,	208,	137,	87,	187,	248,	172,	189,	121,
	243,	110,	215,	4,	142,	143,	188,	89,	250,	6,
	42,	30,	110,	25,	83,	210,	164,	193,	179,	163,
	36,	190,	116,	35,	63,	168,	202,	75,	93,	77,
	231,	200,	70,	122,	154,	190,	87,	100,	33,	117,
	235,	4,	137,	235,	200,	124,	209,	214,	137,	11,
	149,	217,	118,	3,	62,	140,	243,	162,	203,	54,
	177,	165,	103,	31,	148,	204,	97,	40,	249,	223,
	171,	130,	46,	227,	44,	150,	252,	127,	230,	53,
	83,	82,	123,	174,	180,	105,	169,	255,	107,	23,
	226,	149,	61,	118,	125,	60,	238,	158,	8,	109,
	251,	128,	103,	78,	250,	250,	251,	77,	149,	138,
	109,	80,	198,	156,	31,	88,	214,	250,	107,	202,
	209,	181,	199,	120,	137,	31,	196,	51,	178,	253,
	59,	140,	156,	26,	109,	54,	169,	162,	171,	81,
	169,	87,	68,	2,	199,	62,	48,	227,	131,	193,
	231,	203,	228,	132,	228,	218,	29,	80,	110,	144,
	86,	126,	128,	101,	8,	53,	128,	86,	104,	29,
	175,	57,	99,	241,	89,	124,	69,	182,	122,	110,
	71,	89,	34,	6,	46,	157,	95,	250,	107,	203,
	59,	189,	104,	137,	124,	3,	0,	84,	28,	220,
	188,	185,	223,	214,	210,	66,	72,	52,	166,	35,
	187,	192,	204,	8,	128,	235,	241,	109,	219,	91,
	44,	116,	39,	149,	161,	72,	60,	85,	128,	203,
	64,	9,	25,	203,	17,	70,	148,	65,	100,	165,
	168,	77,	5,	14,	204,	102,	228,	27,	187,	48,
	53,	250,	227,	153,	11,	8,	74,	135,	91,	140,
	74,	225,	3,	192,	240,	209,	194,	81,	134,	196,
	154,	208,	228,	102,	175,	96,	59,	173,	184,	199,
	46,	15,	212,	73,	66,	88,	167,	124,	30,	18,
	202,	240,	244,	132,	54,	83,	2,	57,	150,	170,
	168,	116,	109,	97,	219,	199,	253,	29,	142,	174,
	162,	168,	193,	124,	93,	157,	221,	178,	115,	54,
	32,	29,	230,	181,	51,	231,	112,	122,	69,	196,
	248,	138,	156,	108,	57,	131,	130,	129,	60,	47,
	114,	241,	130,	32,	186,	100,	61,	246,	157,	184,
	80,	179,	156,	88,	29,	4,	124,	107,	9,	0,
	54,	138,	235,	241,	69,	224,	143,	196,	119,	69,
	45,	3,	241,	129,	182,	53,	218,	45,	65,	56,
	161,	233,	76,	128,	91,	22,	232,	241,	192,	35,
	20,	54,	122,	134,	76,	175,	113,	178,	139,	217,
	182,	54,	125,	121,	181,	60,	173,	225,	202,	49,
	8,	20,	134,	255,	60,	183,	247,	45,	195,	106,
	32,	211,	35,	198,	159,	181,	127,	30,	162,	182,
	23,	131,	39,	49,	189,	254,	219,	18,	195,	90,
	114,	224,	61,	121,	172,	247,	253,	80,	183,	83,
	6,	165,	179,	63,	213,	102,	73,	100,	218,	233,
	164,	36,	93,	186,	168,	240,	114,	169,	253,	80,
	13,	189,	225,	196,	241,	252,	193,	107,	131,	102,
	154,	213,	118,	11,	83,	6,	58,	165,	28,	168,
	76,	205,	77,	24,	136,	253,	165,	186,	201,	131,
	103,	217,	92,	197,	217,	159,	196,	28,	101,	64,
	21,	213,	184,	215,	188,	168,	149,	47,	228,	229,
	154,	34,	44,	78,	68,	243,	139,	193,	32,	218,
	102,	133,	195,	157,	39,	115,	90,	125,	93,	228,
	103,	239,	18,	174,	115,	188,	139,	86,	72,	157,
	39,	68,	177,	154,	76,	9,	119,	45,	106,	240,
	189,	222,	96,	161,	143,	175,	43,	118,	13,	68,
	129,	175,	171,	140,	103,	237,	208,	57,	152,	40,
	35,	172,	78,	184,	7,	194,	105,	16,	49,	215,
	37,	56,	196,	55,	69,	15,	39,	221,	218,	11,
	177,	220,	6,	145,	91,	97,	33,	183,	136,	238,
	28,	86,	45,	109,	8,	14,	195,	26,	180,	22,
	152,	116,	61,	138,	149,	96,	235,	165,	244,	2,
	32,	117,	15,	58,	246,	113,	40,	178,	43,	162,
	243,	165,	238,	49,	54,	199,	73,	134,	138,	91,
	126,	40,	92,	198,	55,	251,	221,	190,	139,	68,
	128,	33,	210,	127,	85,	38,	125,	108,	218,	9,
	124,	233,	34,	86,	175,	136,	47,	80,	219,	208,
	131,	200,	122,	111,	71,	204,	46,	125,	10,	93,
	139,	62,	131,	109,	154,	132,	150,	76,	5,	1,
	2,	42,	217,	186,	218,	195,	138,	135,	155,	24,
	104,	69,	68,	206,	197,	189,	42,	239,	135,	237,
	75,	89,	178,	212,	114,	212,	76,	136,	116,	184,
	158,	231,	97,	149,	162,	169,	85,	89,	28,	245,
	109,	67,	190,	142,	40,	29,	212,	247,	40,	19,
	164,	97,	242,	130,	124,	26,	1,	24,	81,	121,
	153,	223,	160,	242,	41,	68,	167,	172,	170,	87,
	192,	46,	192,	27,	22,	251,	35,	172,	232,	91,
	253,	45,	161,	180,	241,	138,	243,	199,	255,	44,
	82,	73,	213,	37,	227,	168,	228,	136,	21,	106,
	135,	31,	99,	121,	26,	182,	38,	115,	127,	13,
	3,	155,	194,	47,	247,	71,	199,	127,	39,	110,
	35,	171,	17,	58,	121,	217,	1,	110,	11,	178,
	79,	134,	167,	193,	86,	1,	192,	238,	75,	71,
	113,	235,	155,	242,	248,	197,	187,	82,	0,	131,
	40,	204,	1,	160,	121,	191,	254,	210,	87,	203,
	98,	198,	111,	61,	47,	107,	214,	164,	62,	57,
	238,	203,	245,	13,	237,	33,	57,	39,	154,	106,
	172,	213,	173,	17,	75,	74,	183,	27,	253,	31,
	223,	127,	231,	212,	120,	150,	206,	188,	89,	21,
	140,	109,	247,	158,	246,	12,	17,	1,	93,	242,
	50,	177,	113,	52,	199,	94,	228,	102,	201,	59,
	58,	21,	148,	222,	234,	91,	99,	47,	65,	216,
	196,	209,	126,	139,	162,	237,	31,	201,	247,	164,
	191,	15,	32,	114,	88,	154,	184,	88,	146,	248,
	7,	28,	53,	150,	149,	254,	192,	222,	66,	44,
	150,	242,	91,	210,	229,	67,	164,	4,	52,	168,
	110,	219,	30,	17,	90,	229,	47,	56,	2,	172,
	170,	71,	152,	69,	46,	18,	102,	96,	3,	140,
	23,	10,	90,	128,	243,	179,	123,	49,	253,	13,
	235,	78,	24,	211,	36,	23,	121,	99,	240,	168,
	146,	135,	153,	194,	254,	3,	219,	171,	208,	62,
	113,	113,	126,	66,	232,	46,	176,	234,	246,	168,
	199,	128,	67,	114,	214,	212,	240,	130,	228,	190,
	232,	101,	203,	214,	129,	105,	188,	86,	174,	223,
	54,	185,	28,	144,	29,	205,	16,	202,	29,	73,
	132,	38,	145,	237,	218,	113,	175,	49,	194,	30,
	83,	219,	42,	33,	61,	79,	23,	245,	166,	103,
	243,	146,	39,	240,	185,	229,	3,	217,	12,	240,
	59,	7,	182,	127,	110,	73,	221,	163,	154,	125,
	22,	126,	241,	119,	22,	111,	231,	175,	3,	157,
	234,	181,	35,	217,	121,	235,	105,	221,	151,	159,
	57,	115,	85,	32,	22,	145,	54,	123,	41,	137,
	133,	182,	198,	123,	71,	74,	196,	31,	21,	49,
	141,	103,	62,	132,	170,	79,	96,	90,	117,	226,
	157,	123,	25,	186,	121,	86,	141,	150,	183,	34,
	181,	143,	40,	160,	47,	246,	176,	12,	23,	130,
	159,	118,	33,	205,	90,	128,	237,	140,	200,	231,
	172,	137,	214,	193,	130,	142,	240,	106,	19,	96,
	196,	144,	127,	194,	41,	108,	79,	131,	45,	105,
	255,	63,	249,	172,	139,	215,	160,	55,	124,	5,
	129,	156,	184,	11,	241,	96,	200,	0,	226,	118,
	83,	174,	208,	197,	216,	3,	55,	223,	85,	114,
	27,	7,	235,	148,	200,	166,	52,	66,	81,	63,
	244,	207,	240,	70,	129,	195,	252,	34,	187,	86,
	95,	134,	155,	157,	147,	177,	62,	72,	154,	111,
	111,	69,	55,	179,	121,	53,	61,	53,	147,	107,
	113,	57,	114,	150,	31,	153,	150,	244,	120,	102,
	193,	202,	83,	206,	177,	82,	238,	227,	72,	249,
	204,	235,	5,	219,	41,	94,	247,	152,	48,	161,
	47,	250,	20,	209,	120,	141,	55,	200,	246,	203,
	10,	27,	180,	82,	253,	228,	179,	26,	250,	254,
	78,	63,	238,	26,	215,	165,	58,	225,	182,	54,
	77,	123,	34,	139,	25,	136,	102,	212,	87,	185,
	87,	163,	51,	52,	247,	76,	226,	122,	105,	67,
	230,	131,	250,	28,	169,	203,	54,	190,	243,	144,
	7,	113,	191,	184,	135,	135,	71,	199,	239,	80,
	170,	31,	197,	52,	182,	231,	179,	24,	229,	170,
	234,	152,	194,	5,	226,	57,	149,	255,	181,	136,
	152,	45,	93,	206,	39,	141,	74,	166,	180,	42,
	102,	74,	163,	135,	123,	199,	150,	141,	6,	167,
	26,	167,	199,	170,	230,	55,	151,	98,	138,	216,
	88,	234,	108,	4,	69,	231,	22,	247,	132,	165,
	30,	110,	123,	133,	216,	176,	127,	41,	215,	16,
	88,	205,	39,	212,	229,	164,	161,	40,	200,	196,
	147,	253,	223,	137,	231,	20,	55,	175,	171,	252,
	143,	3,	177,	26,	153,	140,	47,	179,	233,	212,
	77,	192,	4,	242,	106,	130,	77,	53,	120,	161,
	72,	143,	61,	6,	66,	139,	235,	75,	141,	133,
	37,	22,	220,	78,	127,	211,	177,	215,	117,	244,
	135,	249,	80,	161,	184,	23,	77,	144,	96,	40,
	4,	142,	98,	38,	237,	192,	179,	79,	104,	173,
	110,	43,	168,	98,	139,	170,	66,	90,	242,	206,
	113,	35,	48,	208,	226,	35,	32,	45,	184,	105,
	17,	15,	52,	152,	66,	1,	78,	80,	147,	101,
	45,	58,	65,	80,	143,	118,	242,	202,	56,	145,
	7,	235,	179,	187,	242,	106,	46,	235,	105,	184,
	125,	191,	95,	40,	244,	108,	126,	149,	228,	2,
	36,	104,	155,	105,	224,	78,	193,	50,	56,	244,
	41,	170,	174,	216,	191,	0,	51,	41,	171,	203,
	115,	76,	114,	14,	232,	222,	227,	25,	138,	221,
	236,	2,	210,	209,	174,	8,	212,	214,	238,	19,
	76,	135,	229,	137,	200,	114,	192,	154,	22,	69,
	69,	251,	131,	21,	79,	56,	205,	20,	238,	95,
	151,	127,	117,	40,	208,	40,	238,	172,	239,	122,
	88,	25,	19,	12,	114,	145,	123,	154,	64,	184,
	52,	118,	198,	182,	81,	127,	0,	205,	5,	50,
	106,	18,	140,	69,	192,	194,	49,	52,	3,	227,
	163,	160,	201,	190,	57,	141,	181,	40,	248,	44,
	37,	73,	38,	249,	138,	2,	115,	68,	90,	108,
	33,	177,	93,	64,	31,	37,	90,	124,	158,	240,
	188,	180,	43,	157,	108,	161,	68,	163,	191,	20,
	45,	181,	166,	119,	98,	30,	12,	63,	54,	74,
	31,	148,	130,	103,	156,	90,	29,	61,	111,	90,
	40,	80,	91,	173,	236,	231,	194,	37,	211,	229,
	30,	90,	22,	196,	135,	233,	34,	149,	60,	13,
	145,	212,	164,	40,	74,	23,	8,	86,	100,	70,
	111,	45,	19,	237,	167,	15,	131,	25,	76,	253,
	202,	191,	50,	68,	173,	118,	243,	68,	187,	164,
	84,	119,	241,	111,	179,	169,	46,	31,	30,	233,
	161,	249,	6,	203,	201,	136,	56,	248,	234,	1,
	53,	195,	144,	70,	236,	117,	129,	205,	79,	162,
	136,	227,	8,	134,	235,	11,	231,	109,	204,	27,
	108,	193,	36,	164,	170,	99,	96,	61,	165,	195,
	106,	169,	17,	121,	242,	20,	112,	127,	183,	88,
	220,	23,	203,	249,	150,	170,	186,	107,	246,	116,
	230,	95,	37,	31,	33,	127,	85,	237,	76,	6,
	247,	160,	212,	157,	30,	14,	210,	27,	224,	43,
	246,	60,	60,	208,	27,	128,	14,	227,	53,	56,
	2,	80,	227,	232,	161,	74,	207,	237,	16,	104,
	154,	151,	136,	12,	23,	115,	37,	214,	188,	172,
	77,	145,	225,	134,	199,	175,	139,	102,	153,	189,
	11,	195,	116,	58,	144,	13,	218,	53,	204,	87,
	110,	201,	78,	253,	140,	248,	168,	102,	56,	90,
	78,	157,	113,	1,	227,	133,	191,	50,	191,	29,
	193,	0,	118,	33,	36,	41,	115,	134,	32,	253,
	250,	208,	27,	35,	252,	71,	130,	208,	4,	60,
	181,	79,	133,	194,	3,	154,	148,	213,	86,	143,
	143,	39,	60,	146,	62,	150,	26,	53,	226,	143,
	50,	69,	252,	128,	105,	136,	192,	155,	176,	63,
	77,	190,	61,	67,	82,	129,	234,	212,	226,	50,
	206,	42,	175,	157,	139,	155,	167,	106,	169,	169,
	29,	25,	98,	155,	105,	117,	44,	196,	56,	63,
	214,	231,	191,	90,	102,	255,	109,	214,	83,	226,
	163,	129,	71,	192,	104,	172,	13,	118,	35,	236,
	38,	43,	131,	103,	29,	36,	219,	58,	36,	149,
	129,	1,	31,	40,	17,	197,	175,	159,	174,	168,
	46,	55,	209,	18,	97,	107,	70,	200,	53,	208,
	112,	144,	162,	106,	34,	24,	98,	206,	60,	180,
	124,	110,	36,	203,	130,	160,	44,	24,	210,	72,
	123,	23,	59,	96,	131,	218,	107,	252,	164,	66,
	60,	156,	82,	27,	34,	147,	131,	79,	96,	244,
	57,	97,	51,	193,	100,	19,	247,	51,	183,	190,
	40,	44,	42,	123,	76,	79,	218,	68,	133,	0,
	207,	125,	97,	202,	86,	54,	94,	112,	32,	52,
	52,	92,	118,	143,	105,	211,	114,	204,	92,	187,
	55,	5,	68,	217,	221,	86,	76,	157,	120,	69,
	186,	130,	206,	234,	112,	197,	46,	218,	7,	199,
	92,	135,	190,	46,	196,	207,	244,	46,	50,	64,
	96,	185,	40,	173,	111,	99,	55,	165,	77,	235,
	141,	231,	38,	156,	175,	255,	233,	30,	62,	167,
	129,	38,	208,	203,	74,	135,	92,	83,	176,	173,
	139,	144,	193,	220,	153,	97,	51,	195,	139,	16,
	204,	59,	193,	137,	209,	155,	16,	86,	145,	216,
	231,	234,	248,	248,	181,	47,	2,	175,	248,	133,
	218,	41,	132,	137,	138,	180,	25,	228,	217,	250,
	250,	179,	53,	162,	156,	8,	184,	99,	1,	145,
	30,	66,	123,	43,	169,	58,	99,	196,	205,	160,
	132,	141,	11,	7,	76,	12,	155,	175,	124,	15,
	164,	88,	151,	247,	124,	56,	243,	191,	76,	118,
	127,	241,	60,	228,	106,	97,	156,	79,	196,	202,
	132,	175,	59,	148,	9,	45,	222,	34,	134,	27,
	116,	9,	8,	89,	14,	200,	189,	15,	189,	182,
	149,	228,	163,	105,	117,	133,	181,	10,	7,	218,
	27,	208,	96,	6,	26,	79,	25,	223,	5,	46,
	119,	116,	169,	191,	41,	202,	136,	250,	107,	131,
	59,	4,	116,	28,	161,	141,	141,	43,	81,	42,
	189,	56,	111,	192,	66,	201,	91,	125,	221,	217,
	115,	165,	120,	91,	136,	110,	143,	139,	36,	156,
	104,	93,	73,	230,	175,	55,	181,	125,	214,	199,
	25,	140,	84,	151,	58,	195,	8,	106,	131,	251,
	34,	25,	112,	224,	180,	177,	8,	122,	121,	189,
	249,	94,	169,	72,	18,	163,	71,	141,	156,	193,
	245,	87,	63,	188,	20,	89,	34,	173,	85,	141,
	156,	150,	205,	124,	42,	150,	185,	50,	168,	137,
	159,	46,	19,	128,	61,	187,	53,	180,	150,	35,
	195,	137,	84,	23,	89,	22,	189,	71,	144,	65,
	252,	208,	61,	21,	92,	73,	140,	226,	247,	202,
	177,	178,	185,	65,	73,	70,	133,	81,	68,	117,
	24,	129,	44,	54,	246,	202,	49,	185,	178,	191,
	247,	134,	60,	120,	170,	48,	245,	110,	150,	160,
	143,	120,	110,	23,	94,	87,	222,	165,	200,	220,
	122,	102,	191,	73,	215,	192,	193,	242,	136,	201,
	235,	26,	226,	176,	118,	177,	53,	173,	126,	154,
	232,	20,	29,	63,	231,	237,	112,	31,	148,	240,
	123,	27,	199,	197,	225,	98,	80,	76,	26,	70,
	229,	78,	91,	174,	220,	84,	177,	16,	185,	230,
	149,	45,	115,	132,	82,	219,	53,	245,	214,	163,
	37,	25,	51,	255,	118,	13,	176,	78,	118,	17,
	65,	218,	4,	230,	222,	182,	234,	162,	242,	75,
	201,	222,	31,	234,	153,	42,	33,	77,	183,	132,
	208,	180,	180,	150,	40,	191,	29,	103,	194,	22,
	79,	39,	15,	15,	197,	129,	234,	121,	24,	207,
	243,	148,	33,	245,	96,	134,	180,	45,	71,	161,
	8,	195,	154,	6,	138,	233,	211,	13,	79,	34,
	81,	180,	77,	109,	65,	172,	105,	177,	153,	223,
	19,	136,	69,	166,	207,	172,	185,	149,	98,	109,
	117,	19,	47,	120,	134,	166,	239,	96,	119,	17,
	15,	188,	201,	225,	138,	234,	241,	85,	240,	0,
	182,	34,	99,	84,	146,	96,	168,	61,	73,	15,
	206,	175,	172,	66,	156,	9,	185,	94,	216,	65,
	108,	103,	1,	79,	79,	147,	67,	24,	106,	77,
	20,	175,	145,	89,	10,	67,	240,	110,	110,	34,
	22,	185,	171,	168,	146,	89,	125,	207,	232,	171,
	83,	196,	39,	12,	60,	229,	144,	108,	122,	156,
	74,	24,	95,	210,	225,	210,	164,	102,	115,	140,
	103,	39,	43,	184,	95,	186,	183,	49,	28,	81,
	185,	197,	5,	141,	233,	172,	170,	114,	241,	23,
	255,	253,	55,	191,	231,	23,	97,	150,	53,	26,
	160,	31,	1,	184,	7,	103,	56,	71,	64,	155,
	193,	56,	150,	228,	22,	19,	251,	169,	63,	196,
	123,	181,	194,	177,	181,	151,	201,	57,	146,	63,
	25,	83,	195,	228,	192,	232,	21,	189,	78,	154,
	105,	104,	60,	175,	80,	215,	138,	199,	12,	204,
	17,	140,	129,	72,	82,	87,	96,	134,	243,	133,
	49,	153,	249,	127,	98,	236,	123,	128,	99,	138,
	91,	72,	141,	210,	141,	208,	14,	15,	107,	255,
	132,	254,	128,	108,	74,	228,	66,	123,	190,	173,
	137,	83,	197,	99,	156,	202,	204,	49,	145,	176,
	97,	211,	241,	167,	92,	160,	50,	148,	40,	253,
	214,	139,	204,	9,	23,	167,	18,	206,	64,	216,
	58,	221,	230,	24,	152,	17,	170,	1,	190,	14,
	217,	6,	185,	232,	158,	73,	24,	6,	121,	179,
	131,	106,	209,	46,	65,	9,	46,	39,	247,	162,
	212,	129,	178,	111,	254,	64,	15,	44,	161,	230,
	123,	39,	190,	58,	3,	210,	179,	22,	213,	189,
	147,	173,	248,	208,	41,	115,	74,	154,	165,	42,
	90,	15,	99,	79,	179,	137,	17,	72,	248,	144,
	109,	169,	117,	250,	69,	202,	91,	37,	57,	192,
	139,	64,	208,	27,	159,	141,	164,	72,	238,	251,
	243,	16,	200,	230,	228,	180,	174,	183,	161,	29,
	162,	172,	255,	192,	213,	172,	189,	23,	75,	185,
	81,	168,	55,	43,	244,	66,	71,	234,	149,	59,
	133,	183,	72,	180,	141,	200,	230,	130,	172,	55,
	156,	61,	14,	249,	84,	123,	238,	138,	180,	205,
	161,	119,	37,	79,	85,	209,	144,	215,	110,	196,
	210,	234,	140,	57,	236,	97,	166,	108,	65,	168,
	198,	174,	3,	105,	29,	153,	201,	232,	183,	11,
	52,	50,	219,	43,	132,	19,	223,	49,	142,	138,
	151,	107,	93,	162,	71,	5,	184,	49,	112,	17,
	117,	64,	3,	119,	160,	62,	213,	38,	212,	92,
	12,	236,	99,	246,	156,	69,	82,	12,	229,	0,
	255,	1,	59,	166,	229,	61,	160,	90,	14,	138,
	182,	71,	203,	75,	220,	63,	221,	207,	2,	6,
	187,	68,	71,	238,	221,	115,	81,	223,	15,	59,
	43,	151,	113,	67,	197,	62,	215,	112,	141,	127,
	106,	76,	93,	215,	223,	198,	76,	153,	28,	36,
	32,	173,	64,	250,	192,	72,	97,	186,	140,	69,
	125,	24,	83,	26,	106,	65,	179,	165,	190,	235,
	85,	209,	104,	240,	234,	115,	240,	196,	218,	156,
	128,	213,	245,	67,	123,	71,	42,	25,	155,	49,
	13,	18,	79,	16,	142,	162,	85,	209,	235,	6,
	30,	147,	218,	201,	202,	32,	12,	228,	86,	170,
	236,	23,	113,	191,	3,	169,	196,	18,	43,	218,
	182,	87,	73,	107,	162,	249,	3,	207,	7,	218,
	242,	200,	3,	135,	120,	59,	10,	194,	253,	143,
	186,	160,	9,	202,	232,	25,	57,	250,	199,	56,
	72,	23,	233,	64,	94,	102,	37,	91,	63,	26,
	57,	108,	144,	124,	155,	25,	128,	211,	6,	77,
	24,	211,	246,	90,	150,	113,	175,	121,	121,	40,
	226,	153,	123,	15,	66,	187,	45,	121,	141,	44,
	66,	26,	171,	138,	14,	60,	229,	52,	226,	166,
	233,	214,	167,	26,	149,	174,	237,	5,	209,	255,
	52,	236,	100,	24,	189,	152,	255,	178,	156,	177,
	217,	113,	147,	71,	92,	122,	57,	13,	70,	78,
	210,	49,	165,	51,	101,	77,	109,	9,	91,	64,
	230,	51,	153,	2,	16,	22,	188,	193,	91,	231,
	237,	65,	163,	35,	236,	83,	218,	17,	144,	92,
	144,	27,	76,	248,	43,	53,	171,	148,	185,	10,
	148,	93,	93,	176,	250,	186,	124,	184,	10,	199,
	16,	18,	33,	229,	249,	134,	219,	53,	94,	168,
	113,	56,	237,	13,	34,	11,	222,	157,	183,	89,
	79,	251,	152,	6,	13,	90,	81,	230,	153,	140,
	106,	214,	255,	184,	99,	150,	218,	175,	219,	132,
	187,	200,	27,	245,	85,	143,	33,	180,	37,	195,
	224,	96,	168,	168,	22,	191,	5,	128,	33,	15,
	92,	237,	54,	249,	115,	38,	138,	159,	232,	29,
	70,	70,	103,	218,	51,	15,	162,	213,	83,	64,
	192,	145,	81,	196,	37,	33,	180,	84,	45,	38,
	84,	192,	138,	195,	62,	55,	62,	206,	157,	96,
	214,	176,	209,	238,	50,	235,	245,	27,	98,	87,
	134,	36,	217,	8,	231,	4,	231,	31,	134,	147,
	127,	48,	139,	27,	4,	78,	225,	238,	1,	87,
	47,	40,	205,	111,	125,	240,	207,	16,	203,	167,
	225,	21,	88,	131,	39,	116,	14,	91,	201,	233,
	77,	48,	127,	249,	57,	188,	216,	43,	226,	32,
	11,	141,	243,	2,	165,	42,	51,	208,	22,	35,
	37,	41,	233,	140,	182,	207,	139,	162,	43,	85,
	206,	247,	237,	70,	94,	177,	179,	12,	161,	153,
	98,	54,	132,	132,	25,	105,	236,	185,	113,	164,
	88,	168,	105,	131,	249,	168,	213,	54,	29,	119,
	72,	20,	201,	102,	99,	4,	98,	54,	202,	210,
	121,	130,	197,	50,	105,	184,	245,	107,	223,	70,
	118,	20,	190,	25,	242,	242,	206,	184,	119,	172,
	231,	12,	219,	114,	160,	128,	186,	28,	45,	25,
	90,	78,	74,	173,	46,	75,	61,	198,	199,	9,
	67,	72,	255,	213,	60,	251,	133,	5,	103,	90,
	89,	225,	70,	14,	211,	27,	96,	165,	109,	104,
	94,	103,	52,	130,	44,	90,	37,	227,	7,	209,
	35,	135,	163,	138,	65,	212,	230,	37,	134,	111,
	120,	211,	178,	207,	230,	56,	2,	36,	147,	56,
	30,	107,	212,	229,	66,	8,	147,	11,	139,	242,
	221,	95,	160,	11,	187,	109,	179,	88,	236,	39,
	165,	246,	188,	35,	105,	223,	12,	240,	227,	91,
	193,	1,	55,	220,	155,	27,	39,	214,	146,	23,
	248,	215,	162,	31,	152,	206,	11,	20,	209,	148,
	165,	139,	210,	81,	65,	10,	66,	195,	57,	80,
	187,	220,	142,	124,	224,	48,	138,	195,	1,	147,
	40,	136,	50,	50,	52,	186,	76,	155,	204,	165,
	140,	168,	238,	251,	24,	185,	113,	60,	49,	3,
	111,	227,	75,	166,	52,	200,	114,	39,	75,	21,
	226,	193,	219,	2,	126,	64,	5,	134,	163,	222,
	22,	86,	170,	224,	5,	56,	109,	75,	117,	65,
	86,	155,	160,	200,	147,	188,	167,	88,	235,	67,
	29,	21,	148,	135,	36,	120,	210,	167,	95,	194,
	68,	100,	48,	56,	61,	111,	69,	145,	151,	144,
	212,	238,	98,	100,	232,	2,	243,	46,	18,	28,
	137,	66,	242,	25,	58,	28,	237,	168,	125,	143,
	40,	15,	42,	194,	132,	219,	248,	46,	141,	54,
	96,	237,	137,	108,	192,	176,	79,	34,	181,	37,
	170,	63,	176,	65,	79,	142,	120,	122,	176,	34,
	41,	222,	41,	103,	141,	102,	182,	229,	220,	166,
	81,	18,	115,	158,	43,	109,	49,	210,	77,	94,
	74,	9,	108,	236,	189,	85,	18,	169,	165,	234,
	44,	135,	249,	187,	42,	243,	79,	26,	149,	55,
	118,	57,	79,	151,	94,	0,	166,	9,	251,	39,
	34,	211,	5,	56,	36,	6,	131,	115,	174,	72,
	226,	3,	127,	208,	196,	27,	135,	39,	12,	113,
	35,	149,	201,	91,	202,	209,	83,	63,	191,	96,
	178,	143,	99,	81,	30,	142,	212,	49,	131,	126,
	27,	98,	218,	54,	114,	16,	211,	102,	54,	189,
	106,	47,	232,	130,	202,	138,	251,	90,	16,	74,
	7,	201,	8,	154,	25,	140,	147,	48,	144,	156,
	97,	207,	40,	37,	69,	80,	1,	248,	28,	60,
	51,	60,	249,	175,	105,	9,	229,	249,	63,	34,
	25,	62,	16,	141,	213,	112,	73,	121,	58,	12,
	243,	21,	5,	111,	121,	253,	146,	174,	169,	165,
	224,	60,	107,	244,	193,	91,	216,	70,	228,	87,
	234,	96,	8,	1,	200,	30,	84,	74,	43,	164,
	250,	128,	186,	197,	19,	131,	16,	170,	195,	217,
	105,	189,	64,	42,	14,	146,	47,	172,	48,	88,
	218,	221,	5,	249,	239,	245,	250,	227,	207,	115,
	136,	224,	52,	255,	72,	127,	65,	234,	247,	233,
	225,	235,	243,	38,	149,	107,	163,	126,	19,	69,
	200,	218,	219,	202,	135,	191,	187,	198,	52,	236,
	177,	245,	100,	219,	15,	111,	130,	207,	89,	243,
	91,	3,	192,	231,	232,	45,	149,	113,	126,	229,
	148,	58,	191,	142,	4,	120,	18,	7,	143,	74,
	233,	71,	10,	240,	193,	29,	227,	89,	161,	179,
	37,	206,	40,	103,	21,	109,	40,	248,	110,	244,
	92,	177,	0,	71,	162,	188,	69,	165,	39,	72,
	134,	96,	82,	2,	72,	107,	227,	197,	19,	157,
	239,	135,
};

#endif /* _NAND_GPIO_EXAMPLE_DATA_H */
