/* This header file is part of the ATMEL AVR32-SoftwareFramework-AT32UC3-1.6.0 Release */

/*This file is prepared for Doxygen automatic documentation generation.*/
/*! \file *********************************************************************
 *
 * \brief TLV320AIC23B stereo audio CODEC driver configuration file for UC3.
 *
 * This file contains the possible external configuration of the TLV320AIC23B.
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All AVR32 devices with SSC, PDCA and TWI or SPI modules
 *                       can be used.
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 ******************************************************************************/

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
 *
 */

#ifndef _CONF_TLV320AIC23B_H_
#define _CONF_TLV320AIC23B_H_

#include "tlv320aic23b.h"

#include <avr32/io.h>
#include "intc.h"
#include "board.h"

//! Mode Selected: \c AIC23B_MODE_DAC,  \c AIC23B_MODE_ADC or \c AIC23B_MODE_CODEC
#define AIC23B_MODE                         AIC23B_MODE_CODEC

//! Input Selected: \c AIC23B_INPUT_LINE or \c AIC23B_INPUT_MIC
#define AIC23B_INPUT                        AIC23B_INPUT_LINE

//! Control interface: \c AIC23B_CTRL_INTERFACE_TWI or \c AIC23B_CTRL_INTERFACE_SPI.
#define AIC23B_CTRL_INTERFACE               AIC23B_CTRL_INTERFACE_SPI

//! Master clock (in Hz): \c 12000000 or \c 11289600.
#define AIC23B_MCLK_HZ                      11289600

// If the selected control interface is TWI...
#if AIC23B_CTRL_INTERFACE == AIC23B_CTRL_INTERFACE_TWI

  /*! \name TWI Connections
   */
#error Not Supported by EXT1102
  //! @}

// If the selected control interface is SPI...
#elif AIC23B_CTRL_INTERFACE == AIC23B_CTRL_INTERFACE_SPI

  /*! \name SPI Connections
   */
  //! @{
  #define AIC23B_SPI                          (&AVR32_SPI)
  #define AIC23B_SPI_NPCS                     3
  #define AIC23B_SPI_MASTER_SPEED             6000000
  #define AIC23B_SPI_SCK_PIN                  AVR32_SPI_SCK_0_0_PIN
  #define AIC23B_SPI_SCK_FUNCTION             AVR32_SPI_SCK_0_0_FUNCTION
  #define AIC23B_SPI_MISO_PIN                 AVR32_SPI_MISO_0_0_PIN
  #define AIC23B_SPI_MISO_FUNCTION            AVR32_SPI_MISO_0_0_FUNCTION
  #define AIC23B_SPI_MOSI_PIN                 AVR32_SPI_MOSI_0_0_PIN
  #define AIC23B_SPI_MOSI_FUNCTION            AVR32_SPI_MOSI_0_0_FUNCTION
  #define AIC23B_SPI_NPCS_PIN                 AVR32_SPI_NPCS_3_1_PIN
  #define AIC23B_SPI_NPCS_FUNCTION            AVR32_SPI_NPCS_3_1_FUNCTION
  //! @}

#endif

/*! \name SSC Connections
 */
//! @{
#define AIC23B_SSC                          (&AVR32_SSC)
#define AIC23B_SSC_TX_PDCA_PID              AVR32_PDCA_PID_SSC_TX
#define AIC23B_SSC_TX_PDCA_CHANNEL          0
#define AIC23B_SSC_TX_PDCA_IRQ              AVR32_PDCA_IRQ_0
#define AIC23B_SSC_TX_PDCA_INT_LEVEL        AVR32_INTC_INT3
#define AIC23B_SSC_TX_CLOCK_PIN             AVR32_SSC_TX_CLOCK_0_PIN
#define AIC23B_SSC_TX_CLOCK_FUNCTION        AVR32_SSC_TX_CLOCK_0_FUNCTION
#define AIC23B_SSC_TX_DATA_PIN              AVR32_SSC_TX_DATA_0_PIN
#define AIC23B_SSC_TX_DATA_FUNCTION         AVR32_SSC_TX_DATA_0_FUNCTION
#define AIC23B_SSC_TX_FRAME_SYNC_PIN        AVR32_SSC_TX_FRAME_SYNC_0_PIN
#define AIC23B_SSC_TX_FRAME_SYNC_FUNCTION   AVR32_SSC_TX_FRAME_SYNC_0_FUNCTION

#define AIC23B_SSC_RX_PDCA_PID              AVR32_PDCA_PID_SSC_RX
#define AIC23B_SSC_RX_PDCA_CHANNEL          1
#define AIC23B_SSC_RX_PDCA_IRQ              AVR32_PDCA_IRQ_1
#define AIC23B_SSC_RX_PDCA_INT_LEVEL        AVR32_INTC_INT3
#define AIC23B_SSC_RX_DATA_PIN              AVR32_SSC_RX_DATA_0_PIN
#define AIC23B_SSC_RX_DATA_FUNCTION         AVR32_SSC_RX_DATA_0_FUNCTION
#define AIC23B_SSC_RX_FRAME_SYNC_PIN        AVR32_SSC_RX_FRAME_SYNC_0_PIN
#define AIC23B_SSC_RX_FRAME_SYNC_FUNCTION   AVR32_SSC_RX_FRAME_SYNC_0_FUNCTION
//! @}

/*! \name Audio Codec Sampling Configuration
 */
//! @{
#define DEFAULT_DAC_SAMPLE_RATE_HZ    (22050)     //!< Sample Rate: 22.05KHz
#define DEFAULT_DAC_NUM_CHANNELS      2           //!< Number of channels: 2 in stereo mode
#define DEFAULT_DAC_BITS_PER_SAMPLE   16          //!< Bits per sample: 16
#define DEFAULT_DAC_SWAP_CHANNELS     FALSE       //!< Swap of channel
//! @}

#endif  // _CONF_TLV320AIC23B_H_
