/* This header file is part of the ATMEL AVR32-UC3-SoftwareFramework-1.6.0 Release */

/*This file is prepared for Doxygen automatic documentation generation.*/
/*! \file *********************************************************************
 *
 * \brief AT32UC3A EVK1105 board header file.
 *
 * This file contains definitions and services related to the features of the
 * EVK1105 board rev. A.
 *
 * To use this board, define BOARD=EVK1105 and EVK1105_REVA. 
 * WARNING: This board revisision is not in production. Check the board revision 
 * on the kit PCB silkscren. 
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All AVR32 AT32UC3A devices can be used.
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 ******************************************************************************/

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
 *
 */

#ifndef _EVK1105_REVA_H_
#define _EVK1105_REVA_H_

#include "compiler.h"

#ifdef __AVR32_ABI_COMPILER__ // Automatically defined when compiling for AVR32, not when assembling.
#  include "led.h"
#endif  // __AVR32_ABI_COMPILER__


/*! \name Oscillator Definitions
 */
//! @{

// RCOsc has no custom calibration by default. Set the following definition to
// the appropriate value if a custom RCOsc calibration has been applied to your
// part.
//#define FRCOSC          AVR32_PM_RCOSC_FREQUENCY              //!< RCOsc frequency: Hz.

#define FOSC32          32768                                 //!< Osc32 frequency: Hz.
#define OSC32_STARTUP   AVR32_PM_OSCCTRL32_STARTUP_8192_RCOSC //!< Osc32 startup time: RCOsc periods.

#define FOSC0           12000000                              //!< Osc0 frequency: Hz.
#define OSC0_STARTUP    AVR32_PM_OSCCTRL0_STARTUP_2048_RCOSC  //!< Osc0 startup time: RCOsc periods.

#define FOSC1           11289600                              //!< Osc1 frequency: Hz
#define OSC1_STARTUP    AVR32_PM_OSCCTRL1_STARTUP_2048_RCOSC  //!< Osc1 startup time: RCOsc periods.


//! @}


/*! \name SDRAM Definitions
 */
//! @{

//! Part header file of used SDRAM(s).
#define SDRAM_PART_HDR  "MT48LC16M16A2TG7E/mt48lc16m16a2tg7e.h"

//! Data bus width to use the SDRAM(s) with (16 or 32 bits; always 16 bits on
//! UC3).
#define SDRAM_DBW       16
//! @}


/*! \name USB Definitions
 */
//! @{
//! Multiplexed pin used for USB_ID: AVR32_USBB_USB_ID_x_x.
//! To be selected according to the AVR32_USBB_USB_ID_x_x_PIN and
//! AVR32_USBB_USB_ID_x_x_FUNCTION definitions from <avr32/uc3axxxx.h>.
#define AVR32_USBB_USB_ID_0_2_PIN          21
#define AVR32_USBB_USB_ID_0_2_FUNCTION     2
#define USB_ID                      AVR32_USBB_USB_ID_0_2

//! Multiplexed pin used for USB_VBOF: AVR32_USBB_USB_VBOF_x_x.
//! To be selected according to the AVR32_USBB_USB_VBOF_x_x_PIN and
//! AVR32_USBB_USB_VBOF_x_x_FUNCTION definitions from <avr32/uc3axxxx.h>.
#  define USB_VBOF                    AVR32_USBB_USB_VBOF_0_1


//! Active level of the USB_VBOF output pin.
#  define USB_VBOF_ACTIVE_LEVEL       LOW

//! USB overcurrent detection pin.
#  define USB_OVERCURRENT_DETECT_PIN  AVR32_PIN_PX15

//! @}


//! GPIO connection of the MAC PHY PWR_DOWN/INT signal.
#  define MACB_INTERRUPT_PIN  AVR32_PIN_PA24



//! Number of LEDs.
#define LED_COUNT   4

/*! \name GPIO Connections of LEDs
 */
//! @{
#  define LED0_GPIO   AVR32_PIN_PB27
#  define LED1_GPIO   AVR32_PIN_PB28
#  define LED2_GPIO   AVR32_PIN_PA05
#  define LED3_GPIO   AVR32_PIN_PA06
//! @}

/*! \name PWM Channels of LEDs
 */
//! @{
#define LED0_PWM      4
#define LED1_PWM      5
#define LED2_PWM      (-1)
#define LED3_PWM      (-1)
//! @}

/*! \name PWM Functions of LEDs
 */
//! @{
/* TODO: Implement PWM functionality */
#define LED0_PWM_FUNCTION   (-1)//AVR32_PWM_0_FUNCTION
#define LED1_PWM_FUNCTION   (-1)//AVR32_PWM_1_FUNCTION
#define LED2_PWM_FUNCTION   (-1)
#define LED3_PWM_FUNCTION   (-1)
//! @}

//! External interrupt connection of touch sensor.
#define QT1081_EIC_EXTINT_PIN         AVR32_EIC_EXTINT_1_PIN
#define QT1081_EIC_EXTINT_FUNCTION    AVR32_EIC_EXTINT_1_FUNCTION

/*! \name GPIO Connections of touch buttons
 */
//! @{
#define GPIO_PUSH_BUTTON_0            AVR32_PIN_PB22
#define GPIO_PUSH_BUTTON_0_PRESSED    1
#define GPIO_PUSH_BUTTON_1            AVR32_PIN_PB23
#define GPIO_PUSH_BUTTON_1_PRESSED    1
#define GPIO_PUSH_BUTTON_2            AVR32_PIN_PB24
#define GPIO_PUSH_BUTTON_2_PRESSED    1
#define GPIO_PUSH_BUTTON_3            AVR32_PIN_PB25
#define GPIO_PUSH_BUTTON_3_PRESSED    1
#define GPIO_PUSH_BUTTOM_4            AVR32_PIN_PB26
#define GPIO_PUSH_BUTTOM_4_PRESSED    1
//! @}


/*! \name GPIO Connections of the touch buttons
 */
//! @{
#define GPIO_JOYSTICK_PUSH            AVR32_PIN_PB26
#define GPIO_JOYSTICK_PUSH_PRESSED    1
#define GPIO_JOYSTICK_LEFT            AVR32_PIN_PB25
#define GPIO_JOYSTICK_LEFT_PRESSED    1
#define GPIO_JOYSTICK_RIGHT           AVR32_PIN_PB24
#define GPIO_JOYSTICK_RIGHT_PRESSED   1
#define GPIO_JOYSTICK_UP              AVR32_PIN_PB22
#define GPIO_JOYSTICK_UP_PRESSED      1
#define GPIO_JOYSTICK_DOWN            AVR32_PIN_PB23
#define GPIO_JOYSTICK_DOWN_PRESSED    1
//! @}

/*! \name SPI Connections of the AT45DBX Data Flash Memory
 */
//! @{
#define AT45DBX_SPI                 (&AVR32_SPI0)
#define AT45DBX_SPI_NPCS            0
#define AT45DBX_SPI_SCK_PIN         AVR32_SPI0_SCK_0_0_PIN
#define AT45DBX_SPI_SCK_FUNCTION    AVR32_SPI0_SCK_0_0_FUNCTION
#define AT45DBX_SPI_MISO_PIN        AVR32_SPI0_MISO_0_0_PIN
#define AT45DBX_SPI_MISO_FUNCTION   AVR32_SPI0_MISO_0_0_FUNCTION
#define AT45DBX_SPI_MOSI_PIN        AVR32_SPI0_MOSI_0_0_PIN
#define AT45DBX_SPI_MOSI_FUNCTION   AVR32_SPI0_MOSI_0_0_FUNCTION
#define AT45DBX_SPI_NPCS0_PIN       AVR32_SPI0_NPCS_0_0_PIN
#define AT45DBX_SPI_NPCS0_FUNCTION  AVR32_SPI0_NPCS_0_0_FUNCTION
//! @}

/*! \name GPIO and SPI Connections of the SD/MMC Connector
 */
//! @{
#define SD_MMC_CARD_DETECT_PIN      AVR32_PIN_PA02
#define SD_MMC_WRITE_PROTECT_PIN    AVR32_PIN_PA18
#define SD_MMC_SPI                  (&AVR32_SPI0)
#define SD_MMC_SPI_NPCS             1
#define SD_MMC_SPI_SCK_PIN          AVR32_SPI0_SCK_0_0_PIN
#define SD_MMC_SPI_SCK_FUNCTION     AVR32_SPI0_SCK_0_0_FUNCTION
#define SD_MMC_SPI_MISO_PIN         AVR32_SPI0_MISO_0_0_PIN
#define SD_MMC_SPI_MISO_FUNCTION    AVR32_SPI0_MISO_0_0_FUNCTION
#define SD_MMC_SPI_MOSI_PIN         AVR32_SPI0_MOSI_0_0_PIN
#define SD_MMC_SPI_MOSI_FUNCTION    AVR32_SPI0_MOSI_0_0_FUNCTION
#define SD_MMC_SPI_NPCS_PIN         AVR32_SPI0_NPCS_1_0_PIN
#define SD_MMC_SPI_NPCS_FUNCTION    AVR32_SPI0_NPCS_1_0_FUNCTION
//! @}

/*! \name SPI expansion 0
 */
//! @{
#define EXPANSION0_SPI                  (&AVR32_SPI0)
#define EXPANSION0_SPI_NPCS             2
#define EXPANSION0_SPI_SCK_PIN          AVR32_SPI0_SCK_0_0_PIN
#define EXPANSION0_SPI_SCK_FUNCTION     AVR32_SPI0_SCK_0_0_FUNCTION
#define EXPANSION0_SPI_MISO_PIN         AVR32_SPI0_MISO_0_0_PIN
#define EXPANSION0_SPI_MISO_FUNCTION    AVR32_SPI0_MISO_0_0_FUNCTION
#define EXPANSION0_SPI_MOSI_PIN         AVR32_SPI0_MOSI_0_0_PIN
#define EXPANSION0_SPI_MOSI_FUNCTION    AVR32_SPI0_MOSI_0_0_FUNCTION
#define EXPANSION0_SPI_NPCS_PIN         AVR32_SPI0_NPCS_2_0_PIN
#define EXPANSION0_SPI_NPCS_FUNCTION    AVR32_SPI0_NPCS_2_0_FUNCTION
//! @}

/*! \name SPI expansion 1
 */
//! @{
#define EXPANSION1_SPI                  (&AVR32_SPI0)
#define EXPANSION1_SPI_NPCS             3
#define EXPANSION1_SPI_SCK_PIN          AVR32_SPI0_SCK_0_0_PIN
#define EXPANSION1_SPI_SCK_FUNCTION     AVR32_SPI0_SCK_0_0_FUNCTION
#define EXPANSION1_SPI_MISO_PIN         AVR32_SPI0_MISO_0_0_PIN
#define EXPANSION1_SPI_MISO_FUNCTION    AVR32_SPI0_MISO_0_0_FUNCTION
#define EXPANSION1_SPI_MOSI_PIN         AVR32_SPI0_MOSI_0_0_PIN
#define EXPANSION1_SPI_MOSI_FUNCTION    AVR32_SPI0_MOSI_0_0_FUNCTION
#define EXPANSION1_SPI_NPCS_PIN         AVR32_SPI1_NPCS_3_0_PIN
#define EXPANSION1_SPI_NPCS_FUNCTION    AVR32_SPI1_NPCS_3_0_FUNCTION
//! @}

/*! \name TWI AAP or expansion connection
 */
//! @{
#define AAP_TWI                   (&AVR32_TWI)
#define AAP_RESET                 AVR32_PIN_PA19
#define AAP_TWI_SCL_PIN           AVR32_TWI_SCL_0_0_PIN
#define AAP_TWI_SCL_FUNCTION      AVR32_TWI_SCL_0_0_FUNCTION
#define AAP_TWI_SDA_PIN           AVR32_TWI_SDA_0_0_PIN
#define AAP_TWI_SDA_FUNCTION      AVR32_TWI_SDA_0_0_FUNCTION
//! @}

/*! \name OLED
 */
//! @{
#define DD160128_RS                     AVR32_PIN_PA26
#define DD160128_RESET                  AVR32_PIN_PA17
#define DD160128_VDDH                   AVR32_PIN_PB31
#define DD160128_EBI_NCS_PIN            AVR32_EBI_NCS_0_1_PIN
#define DD160128_EBI_NCS_FUNCTION       AVR32_EBI_NCS_0_1_FUNCTION
//! @}

/*! \name TI TLV320AIC23B sound chip
 */
//! @{
#define TLV320_SSC                           (&AVR32_SSC)
#define TLV320_SSC_TX_CLOCK_PIN              AVR32_SSC_TX_CLOCK_0_PIN
#define TLV320_SSC_TX_CLOCK_FUNCTION         AVR32_SSC_TX_CLOCK_0_FUNCTION
#define TLV320_SSC_TX_DATA_PIN               AVR32_SSC_TX_DATA_0_PIN
#define TLV320_SSC_TX_DATA_FUNCTION          AVR32_SSC_TX_DATA_0_FUNCTION
#define TLV320_SSC_TX_FRAME_SYNC_PIN         AVR32_SSC_TX_FRAME_SYNC_0_PIN
#define TLV320_SSC_TX_FRAME_SYNC_FUNCTION    AVR32_SSC_TX_FRAME_SYNC_0_FUNCTION

#define TLV320_TWI                   (&AVR32_TWI)
#define TLV320_TWI_SCL_PIN           AVR32_TWI_SCL_0_0_PIN
#define TLV320_TWI_SCL_FUNCTION      AVR32_TWI_SCL_0_0_FUNCTION
#define TLV320_TWI_SDA_PIN           AVR32_TWI_SDA_0_0_PIN
#define TLV320_TWI_SDA_FUNCTION      AVR32_TWI_SDA_0_0_FUNCTION

#define TLV320_PM_GCLK_PIN         AVR32_PM_GCLK_0_0_PIN
#define TLV320_PM_GCLK_FUNCTION    AVR32_PM_GCLK_0_0_FUNCTION
//! @}

/*! \name Connections of the iPOD Authentication Coprocessor
 */
//! @{
#define IPOD_AUTH_CO_TWI                  (&AVR32_TWI)
#define IPOD_AUTH_CO_TWI_SCL_PIN          AVR32_TWI_SCL_0_0_PIN
#define IPOD_AUTH_CO_TWI_SCL_FUNCTION     AVR32_TWI_SCL_0_0_FUNCTION
#define IPOD_AUTH_CO_TWI_SDA_PIN          AVR32_TWI_SDA_0_0_PIN
#define IPOD_AUTH_CO_TWI_SDA_FUNCTION     AVR32_TWI_SDA_0_0_FUNCTION
#define IPOD_AUTH_CO_N_RESET_PIN          AVR32_PIN_PA19
//! @}


#endif  // _EVK1105_REVA_H_
