#!/bin/sh

# This shell script programs through DFU the AT32UC3B1256 that is mounted
# on the  UC3L-EK board.

# Copyright (C) 2006-2008, Atmel Corporation All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, this
# list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation and/
# or other materials provided with the distribution.
#
# 3. The name of ATMEL may not be used to endorse or promote products derived
# from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY ATMEL ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY AND
# SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


# Note: the erase old user page step (1/) may be removed if we add a 'erase f' option when programming the new user page (2/).

echo Erase old user page configuration.
batchisp -device at32uc3b1256 -hardware usb -operation memory user addrange 0x1FC 0x1FF fillbuffer 0xFF program verify

echo Programming user page. \`isp_userpage_evk1105.hex\` contains the GPIO configuration to enter bootloader. PA11 is BOOTSEL button.
batchisp -device at32uc3b1256 -hardware usb -operation memory user addrange 0x1FC 0x1FF loadbuffer ./isp_userpage_uc3l_ek.hex program verify


echo Programming MCU memory from \`uc3b1256-avr32_virtual_com_port.elf\'.
batchisp \
  -device at32uc3b1256 \
  -hardware usb \
  -operation \
    erase f \
    memory flash \
    blankcheck \
    loadbuffer uc3b1256-avr32_virtual_com_port.elf \
    program \
    verify \
    start reset 0
