#!/usr/bin/perl


######################################################
# Put an html file into a constante string definition.


undef ($/); # We want to read a file as one scalar (instead of reading it line by line).
            # Indeed, $/ is set by default to "\n", the default end-of-line marker.

# The list of html files to process
my @file_list=("defaultpage.htm",
	            );
foreach $file (@file_list) {
  my $output_file = $file.".h";
  print "++>Processing ".$file."\n";
  open ( INPUT, "<$file");
  $html=<INPUT>;  # Put the whole file in the $html variable.
  close INPUT;
  open ( OUTPUT, ">$output_file");
  printf OUTPUT "static const char *pcDefaultPage = \"";
  $html =~ s/"/\\"/g;       # Escape the " character.
  $html =~ s/[\t]+/ /g;     # Replace any \t by a space
  $html =~ s/[\r\n]+//g;    # Remove all \r\n 
  $html =~ s/ {2,}/ /g;     # Replace subsequent spaces by one space
  $html =~ s/>[ ]*</></g;   # Remove any space between a closing html tag and an opening html tag.
  printf OUTPUT $html;
  printf OUTPUT "\";\r\n";
  close(OUTPUT);
}
