package com.atmel.avr32.sf.core.templates;

import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;

import com.atmel.avr32.sf.core.IFrameworkDataWorkingCopy;
import com.atmel.avr32.sf.core.SFCorePlugin;
import com.atmel.avr32.sf.core.WizardExecutor;

/**
 * Template process used to set one or more software framework options then
 * execute the specified wizard.
 * 
 * @author Torkild Ulvøy Resheim
 * @since 2.3
 */
public class FrameworkWizard extends ProcessRunner {

	@Override
	public void process(TemplateCore template, ProcessArgument[] args,
			String processId, IProgressMonitor monitor)
			throws ProcessFailureException {
		String projectName = args[0].getSimpleValue();
		String wizardId = args[1].getSimpleValue();

		IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(
				projectName);

		IFrameworkDataWorkingCopy data = SFCorePlugin
				.getDataWorkingCopy(project);

		ProcessArgument[][] options = args[2].getComplexArrayValue();

		for (int i = 0; i < options.length; i++) {
			ProcessArgument[] option = options[i];
			String id = option[0].getSimpleValue();
			String value = option[1].getSimpleValue();
			data.setValue(id, value);
		}
		WizardExecutor we = new WizardExecutor(SFCorePlugin.getDefault()
				.getWizardDescription(wizardId), data);
		IStatus status = we.execute(new SubProgressMonitor(monitor, 1));
		if (!status.isOK()) {
			String message = status.getMessage();
			if (status instanceof MultiStatus) {
				IStatus[] stati = ((MultiStatus) status).getChildren();
				for (IStatus iStatus : stati) {
					if (iStatus.getSeverity() == IStatus.ERROR) {
						message = iStatus.getMessage();
						break;
					}
				}
			}
			throw new ProcessFailureException(message);
		}
	}
}
