/****************************************************************************
 * Copyright (c) 2009 Atmel Corporation
 *
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the license which accompanies this code.
 * 
 * Contributors:
 *      Atmel Norway AS - Initial API and implementation  
 ****************************************************************************/
package com.atmel.avr32.sf.core.templates;

import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/**
 * CDT template process for deleting files in the workspace. Normally a template
 * is used only once to set up a projects. However due to the example project
 * mechanism we've implemented it's possible to apply multiple templates when
 * creating a new project. This process is for removing files created by earlier
 * applied templates.
 * 
 * @author Torkild Ulvøy Resheim
 * @since 2.3
 */
public class DeleteFiles extends ProcessRunner {

	@Override
	public void process(TemplateCore template, ProcessArgument[] args,
			String processId, IProgressMonitor monitor)
			throws ProcessFailureException {
		try {
			String projectName = args[0].getSimpleValue();
			IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot()
					.getProject(projectName);
			ProcessArgument[][] files = args[1].getComplexArrayValue();
			for (int i = 0; i < files.length; i++) {
				ProcessArgument[] file = files[i];
				String fileName = file[0].getSimpleValue();
				IFile iFile = projectHandle.getFile(fileName);
				if (iFile.exists()) {
					try {
						iFile.delete(true, monitor);
					} catch (CoreException e) {
						e.printStackTrace();
					}
				}

			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
