/****************************************************************************
 * Copyright (c) 2008 Atmel Corporation
 *
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the license which accompanies this code.
 * 
 * Contributors:
 *      Atmel Norway AS - Initial API and implementation  
 ****************************************************************************/
package com.atmel.avr32.sf.core.internal.filesystem;

import java.io.File;
import java.net.URI;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.IPath;

/**
 * 
 * @author Torkild Ulvøy Resheim
 * @since 2.3.0
 */
public class FrameworkFileSystem extends FileSystem {
    /**
     * The singleton instance of this file system.
     */
    private static IFileSystem instance;

    /**
     * Returns the instance of this file system
     * 
     * @return The instance of this file system.
     */
    public static IFileSystem getInstance() {
        return instance;
    }

    /**
     * Creates a new local file system.
     */
    public FrameworkFileSystem() {
        super();
        instance = this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.core.filesystem.IFileSystem#canDelete()
     */
    public boolean canDelete() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.core.filesystem.IFileSystem#canWrite()
     */
    public boolean canWrite() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.core.filesystem.IFileSystem#fromLocalFile(java.io.File)
     */
    public IFileStore fromLocalFile(File file) {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.eclipse.core.filesystem.IFileSystem#getStore(org.eclipse.core.runtime
     * .IPath)
     */
    public IFileStore getStore(IPath path) {
        return null;
    }

    @Override
    public IFileStore getStore(URI uri) {
        return new FrameworkFileStore(uri);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.core.filesystem.IFileSystem#isCaseSensitive()
     */
    public boolean isCaseSensitive() {
        return true;
    }

}
