/****************************************************************************
 * Copyright (c) 2008 Atmel Corporation
 *
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the license which accompanies this code.
 * 
 * Contributors:
 *		Atmel Norway AS - Initial API and implementation  
 ****************************************************************************/

package com.atmel.avr32.sf.core;

import org.eclipse.core.runtime.IPath;

/**
 * 
 * @author Torkild Ulvøy Resheim
 * @since 2.0
 */
public interface IFrameworkFileDescriptor {

    /**
     * Returns the version of the software framework the file was imported from.
     * 
     * @return the framework version
     */
    public String getVersion();

    /**
     * Returns the identifier of the software framework the file was imported
     * from.
     * 
     * @return the framework identifier
     */
    public String getFrameworkId();

    /**
     * @return the path
     */
    public IPath getPath();

    /**
     * @return the imported
     */
    public long getImported();

    /**
     * @return the updated
     */
    public long getUpdated();

    /**
     * @return the source path
     */
    public String getSource();

    /**
     * Returns the "changed" attribute of this file descriptor.
     * 
     * @return <b>True</b> if the file has been changed
     * @since 2.0
     */
    public boolean isChanged();

}
