/****************************************************************************
 * Copyright (c) 2008 Atmel Corporation
 *
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the license which accompanies this code.
 * 
 * Contributors:
 *		Atmel Norway AS - Initial API and implementation  
 ****************************************************************************/
package com.atmel.avr32.sf.core;

import org.eclipse.core.resources.IResource;

/**
 * 
 * @author Torkild Ulvøy Resheim
 * 
 */
public interface IFrameworkDataChangedListener {
    /**
     * Notifies listeners that the workspace <i>IResource</i> with software
     * framework origins has changed in a way that affects it's framework
     * metadata.
     * 
     * @param resource
     *            The resource that has changed
     * @since 2.0
     */
    public void frameworkDataChanged(IResource resource);
}
