/****************************************************************************
 * Copyright (c) 2008 Atmel Corporation
 *
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the license which accompanies this code.
 * 
 * Contributors:
 *		Atmel Norway AS - Initial API and implementation  
 ****************************************************************************/

package com.atmel.avr32.sf.core;

import java.util.HashMap;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

/**
 * Type to describe software framework metadata for a project.
 * 
 * @author Torkild Ulvøy Resheim
 * @since 2.0
 */
public interface IFrameworkData {

    /**
     * Sets the option value.
     * 
     * @param id
     *            The option identifier.
     * @param value
     *            The value to set.
     * @since 2.0
     */
    public void setValue(String id, String value);

    /**
     * Returns the option value.
     * 
     * @param id
     *            The option identifier.
     * @return The option value.
     * @since 2.0
     */
    public String getValue(String id);

    /**
     * Returns all properties in the form of a map using the wizard option
     * identifier as the value identifier.
     * 
     * @return The properties map
     * @since 2.0
     */
    public HashMap<String, String> getValues();

    /**
     * Indicates that the specified resource is derived from a software
     * framework.
     * 
     * @param resource
     *            The resource
     * @param framwork
     *            The framework identifier
     * @param version
     *            The framework version
     * @param source
     *            The framework source relative location
     * @param value
     *            <b>True</b> if the file is a framework file, <b>False/b>
     *            otherwise.
     * @since 2.0
     */
    public void setIsFrameworkFile(IResource resource, String framework,
            String version, String source, boolean value);

    /**
     * Tests if the file is a framework file and if this is the case <b>True</b>
     * is returned.
     * 
     * @param resource
     *            The resource to test
     * @return <b>True</b> if the resource is a framework file.
     * @since 2.0
     */
    public boolean isFrameworkFile(IResource resource);

    /**
     * Returns the framework file descriptor for the given resource.
     * 
     * @param resource
     *            The resource to obtain data from
     * @return The file descriptor
     * @since 2.0
     */
    public IFrameworkFileDescriptor getFileDescriptor(IResource resource);

    /**
     * Returns all the software framework file descriptors for the project.
     * 
     * @return All the file descriptors
     * @since 2.0
     */
    public IFrameworkFileDescriptor[] getFileDescriptors();

    /**
     * Returns the project the framework data is associated with.
     * 
     * @return the project
     * @since 2.0
     */
    public IProject getProject();

}