/****************************************************************************
 * Copyright (c) 2008 Atmel Corporation
 *
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the license which accompanies this code.
 * 
 * Contributors:
 *		Atmel Norway AS - Initial API and implementation  
 ****************************************************************************/

package com.atmel.avr32.sf.core;

/**
 * Shared constants for framework configuration parsers.
 * 
 * @author Torkild Ulvøy Resheim
 * @since 2.0
 */
public interface IFrameworkConfigurationParser {
	/**
	 * All operations that can be applied. The XML element name is converted to
	 * an <code>Operation</code> instance using the following rules:
	 */
	enum Operation {
		/** import a file into the project */
		IMPORT,
		/** includes a source folder */
		INCLUDE,
		/** generates source code */
		CODE,
		/** removes a source folder from the included */
		RM_INCLUDE,
		/** delete */
		DELETE,
		/** define */
		DEFINE,
		/** rm-define */
		RM_DEFINE,
		/** enable */
		ENABLE,
		/** value */
		VALUE,
		/** dependsOn */
		DEPENDSON,
		/** add-library-path */
		ADD_LIBRARY_PATH,
		/** remove-library-path */
		REMOVE_LIBRARY_PATH,
		/** add-library */
		ADD_LIBRARY,
		/** remove-library */
		REMOVE_LIBRARY,
		/** Executes another named operation */
		EXECUTE
	};

	/** Add library to MBS (-l <i>name</i>) */
	static final String ADD_LIBRARY = "add-library"; //$NON-NLS-1$
	/** Add path to MBS (-L <i>path</i>) */
	static final String ADD_LIBRARY_PATH = "add-library-path"; //$NON-NLS-1$
	/** Attribute "dest" */
	static final String ATTR_DEST = "dest"; //$NON-NLS-1$
	/** Attribute "name" */
	static final String ATTR_NAME = "name"; //$NON-NLS-1$
	/** Attribute "path" */
	static final String ATTR_PATH = "path"; //$NON-NLS-1$
	/** Attribute "source" */
	static final String ATTR_SOURCE = "source"; //$NON-NLS-1$
	/** Attribute "symbol" */
	static final String ATTR_SYMBOL = "symbol"; //$NON-NLS-1$
	/** Attribute "title" */
	static final String ATTR_TITLE = "title"; //$NON-NLS-1$
	/** Attribute "type" */
	static final String ATTR_TYPE = "type"; //$NON-NLS-1$
	static final String CONFIGURATION = "configuration"; //$NON-NLS-1$
	static final String DEFAULT = "default"; //$NON-NLS-1$
	static final String DEFINE = "define"; //$NON-NLS-1$
	static final String DELETE = "delete"; //$NON-NLS-1$
	static final String DESCRIPTION = "description"; //$NON-NLS-1$
	static final String ENABLE = "enable"; //$NON-NLS-1$
	static final String ENABLED = "enabled"; //$NON-NLS-1$
	static final String ENUM = "enum"; //$NON-NLS-1$
	static final String HELP_ID = "helpId"; //$NON-NLS-1$
	static final String ID = "id"; //$NON-NLS-1$
	static final String IMPORT = "import"; //$NON-NLS-1$
	/** Operation for including a folder */
	static final String INCLUDE = "include"; //$NON-NLS-1$
	static final String EXECUTE = "execute"; //$NON-NLS-1$
	static final String LABEL = "label"; //$NON-NLS-1$
	static final String OPERATION = "operation"; //$NON-NLS-1$
	static final String MACRO = "macro";
	static final String OPTION = "option"; //$NON-NLS-1$

	/** Remove library from MBS (-l <i>name</i>) */
	static final String REMOVE_LIBRARY = "remove-library"; //$NON-NLS-1$

	/** Add path to MBS (-L <i>path</i>) */
	static final String REMOVE_LIBRARY_PATH = "remove-library-path"; //$NON-NLS-1$

	static final String RM_DEFINE = "rm-define"; //$NON-NLS-1$

	/** Operation for removing an included folder */
	static final String RM_INCLUDE = "rm-include"; //$NON-NLS-1$

	static final String VALUE = "value"; //$NON-NLS-1$

	/** Identifier for the GNU assembler include path MBS option */
	static final String ASM_INCLUDE_PATH_ID = "gnu.both.asm.option.include.paths"; //$NON-NLS-1$

	/** Identifier for the AVR32 pre-processing assembler path MBS option */
	static final String ASM2_INCLUDE_PATH_ID = "avr32.both.preprocessor.option.paths"; //$NON-NLS-1$

	/** Identifier for the GNU C compiler include path MBS option */
	static final String C_INCLUDE_PATH_ID = "gnu.c.compiler.option.include.paths"; //$NON-NLS-1$

	/** Identifier for the MBS linker path option */
	static final String LIBARY_PATH_ID = "gnu.c.link.option.paths"; //$NON-NLS-1$

	/** Identifier for the MBS linker library option */
	static final String LIBRARY_ID = "gnu.c.link.option.libs"; //$NON-NLS-1$

	static final String SYMBOL_ID = "gnu.c.compiler.option.preprocessor.def.symbols"; //$NON-NLS-1$
}
