/****************************************************************************
 * Copyright (c) 2008 Atmel Corporation
 *
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the license which accompanies this code.
 * 
 * Contributors:
 *		Atmel Norway AS - Initial API and implementation  
 ****************************************************************************/
package com.atmel.avr32.sf.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;


/**
 * 
 * @author Torkild Ulvøy Resheim
 * @since 2.0
 */
public class FrameworkFileDescriptor implements IFrameworkFileDescriptor {
    /** The framework version */
    private String version;
    /** The framework identifier */
    private String framework;
    /** Workspace relative path */
    private IPath path;
    /** Framework source relative path */
    private String source;
    /** The first time the file was imported into the file system */
    private long imported;
    /** The last time the file was touched by a framework wizard */
    private long updated;

    private boolean changed;

    /**
     * 
     * @param resource
     */
    public FrameworkFileDescriptor(IResource resource) {
        path = resource.getProjectRelativePath();
    }

    /**
     * The framework version
     * 
     * @return the framework version
     */
    public String getVersion() {
        return version;
    }

    /**
     * @param version
     *            the version to set
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * @return the framework
     */
    public String getFrameworkId() {
        return framework;
    }

    /**
     * @param framework
     *            the framework to set
     */
    public void setFramework(String framework) {
        this.framework = framework;
    }

    /**
     * @return the path
     */
    public IPath getPath() {
        return path;
    }

    /**
     * @return the imported
     */
    public long getImported() {
        return imported;
    }

    /**
     * @param imported
     *            the imported to set
     */
    public void setImported(long imported) {
        this.imported = imported;
    }

    /**
     * @return the updated
     */
    public long getUpdated() {
        return updated;
    }

    /**
     * @param updated
     *            the updated to set
     */
    public void setUpdated(long updated) {
        this.updated = updated;
        if (imported == 0) {
            imported = updated;
        }
    }

    /**
     * @return the source path
     */
    public String getSource() {
        return source;
    }

    /**
     * @param source
     *            the source to set
     */
    public void setSource(String source) {
        this.source = source;
    }

    /**
     * @param path
     *            the path to set
     */
    public void setPath(IPath path) {
        this.path = path;
    }

    public boolean isChanged() {
        return changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }
}
