/****************************************************************************
 * Copyright (c) 2008 Atmel Corporation
 *
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the license which accompanies this code.
 * 
 * Contributors:
 *		Atmel Norway AS - Initial API and implementation  
 ****************************************************************************/
package com.atmel.avr32.sf.core;

import org.eclipse.core.runtime.IPath;


public class FrameworkDataWorkingCopy extends FrameworkProjectData implements
        IFrameworkDataWorkingCopy {

    public FrameworkDataWorkingCopy(IFrameworkData data) {
        super();
        FrameworkProjectData source = (FrameworkProjectData) data;
        this.project = source.getProject();
        for (String option : source.values.keySet()) {
            setValue(option, source.values.get(option));
        }
        for (IPath path : source.descriptors.keySet()) {
            descriptors.put(path, source.descriptors.get(path));
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.atmel.avr32.sf.core.IFrameworkDataWorkingCopy#updateData(com.atmel.avr32.sf.core.internal.FrameworkData)
     */
    public void updateData(FrameworkProjectData data) {
        data.project = this.project;
        data.descriptors.clear();
        data.values.clear();
        for (String option : values.keySet()) {
            data.setValue(option, values.get(option));
        }
        for (IPath path : descriptors.keySet()) {
            data.descriptors.put(path, descriptors.get(path));
        }
    }

}
